/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.tentackle.common.Service;
import org.tentackle.sql.metadata.MetaDataUtilitiesHolder;

@Service(value=MetaDataUtilities.class)
public class MetaDataUtilities {
    private static final String[] TENTACKLE_TABLE_NAMES = new String[]{"bundle", "bundlekey", "modification", "modlog", "numpool", "numrange", "prefkey", "prefnode", "secrules", "tokenlock"};
    private final Map<Integer, String> typeMap = new HashMap<Integer, String>();

    public static MetaDataUtilities getInstance() {
        return MetaDataUtilitiesHolder.INSTANCE;
    }

    public MetaDataUtilities() {
        for (Field field : Types.class.getDeclaredFields()) {
            if (field.getType() != Integer.TYPE || (field.getModifiers() & 8) == 0) continue;
            try {
                this.typeMap.put((Integer)field.get(null), field.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    public String jdbcTypeToString(int jdbcType) {
        String str = this.typeMap.get(jdbcType);
        if (str == null) {
            str = "UNKNOWN";
        }
        return str;
    }

    public boolean isReservedTable(String tableName) {
        if (tableName != null) {
            int ndx = (tableName = tableName.toLowerCase(Locale.ROOT)).indexOf(46);
            if (ndx >= 0) {
                tableName = tableName.substring(ndx + 1);
            }
            for (String tentackleName : TENTACKLE_TABLE_NAMES) {
                if (!tentackleName.equals(tableName)) continue;
                return true;
            }
        }
        return false;
    }
}

