/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public final class OffsetTimeType
extends AbstractDateTimeType<OffsetTime> {
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss[ ]xxx");
    private static final DateTimeFormatter MS_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS[ ]xxx");

    public static Time timeOf(OffsetTime value) {
        return Time.valueOf(value.toLocalTime());
    }

    public static int offsetOf(OffsetTime value) {
        return value.getOffset().getTotalSeconds();
    }

    @Override
    public String getJavaType() {
        return "OffsetTime";
    }

    @Override
    public int getColumnCount(Backend backend) {
        return 2;
    }

    @Override
    public int[] getSortableColumns() {
        return null;
    }

    @Override
    public Optional<String> getCommentSuffix(Backend backend, int index) {
        return switch (index) {
            case 0 -> Optional.empty();
            case 1 -> Optional.of(" [+-s]");
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public String getColumnGetter(int index, String varName) {
        return switch (index) {
            case 0 -> "OffsetTimeType.timeOf(" + varName + ")";
            case 1 -> "OffsetTimeType.offsetOf(" + varName + ")";
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public String getColumnAlias(int index) {
        return switch (index) {
            case 0 -> "time";
            case 1 -> "offset";
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public Object getColumnValue(Backend backend, int index, OffsetTime value) {
        if (value != null) {
            return switch (index) {
                case 0 -> OffsetTimeType.timeOf(value);
                case 1 -> Integer.valueOf(OffsetTimeType.offsetOf(value));
                default -> throw new IndexOutOfBoundsException(index);
            };
        }
        return null;
    }

    @Override
    public int getSize(Backend backend, int index, Integer size) {
        return switch (index) {
            case 0 -> super.getSize(backend, index, size);
            case 1 -> 0;
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public int getScale(Backend backend, int index, Integer scale) {
        return 0;
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        return switch (index) {
            case 0 -> SqlType.TIME;
            case 1 -> SqlType.INTEGER;
            default -> throw new IndexOutOfBoundsException();
        };
    }

    @Override
    public OffsetTime valueOf(String str) {
        return this.parse(str);
    }

    @Override
    public String toString(OffsetTime object) {
        return StringHelper.toParsableString((String)this.format(object));
    }

    @Override
    public String toLiteral(String str, Integer index) {
        if (index != null && index == 0 && !((String)str).isEmpty() && ((String)str).charAt(0) != '\'') {
            str = "'" + (String)str + "'";
        }
        return str;
    }

    @Override
    public String valueOfLiteralToCode(String str, Integer index) {
        if (index != null) {
            return switch (index) {
                case 0 -> {
                    if ("null".equals(str)) {
                        yield str;
                    }
                    if (!((String)str).isEmpty() && Character.isDigit(((String)str).charAt(0))) {
                        str = "\"" + (String)str + "\"";
                    }
                    yield "Time.valueOf(" + (String)str + ")";
                }
                case 1 -> str;
                default -> throw new IndexOutOfBoundsException(index);
            };
        }
        if (!((String)str).isEmpty() && Character.isDigit(((String)str).charAt(0))) {
            str = "\"" + (String)str + "\"";
        }
        return "OffsetTime.parse(" + (String)str + ")";
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, OffsetTime object, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            statement.setNull(pos, 92);
            statement.setNull(pos + 1, 4);
            return new Object[]{null, null};
        }
        Time time = OffsetTimeType.timeOf(object);
        int offset = OffsetTimeType.offsetOf(object);
        statement.setTime(pos, time);
        statement.setInt(pos + 1, offset);
        return new Object[]{time, offset};
    }

    @Override
    public Object set(Backend backend, PreparedStatement statement, int pos, OffsetTime object, int index, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            switch (index) {
                case 0: {
                    statement.setNull(pos, 92);
                    return null;
                }
                case 1: {
                    statement.setNull(pos, 4);
                    return null;
                }
            }
        } else {
            switch (index) {
                case 0: {
                    Time time = OffsetTimeType.timeOf(object);
                    statement.setTime(pos, time);
                    return time;
                }
                case 1: {
                    int offset = OffsetTimeType.offsetOf(object);
                    statement.setInt(pos, offset);
                    return offset;
                }
            }
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public OffsetTime get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        Time time = resultSet.getTime(pos[0]);
        return resultSet.wasNull() ? null : OffsetTime.of(time.toLocalTime(), ZoneOffset.ofTotalSeconds(resultSet.getInt(pos[1])));
    }

    public OffsetTime parse(String str) throws BackendException {
        if ((str = StringHelper.parseString((String)str)).contains(".")) {
            try {
                return MS_TIME_FORMATTER.parse((CharSequence)str, OffsetTime::from);
            }
            catch (DateTimeParseException e) {
                throw new BackendException("parsing time with ms from '" + str + "' failed", e);
            }
        }
        try {
            return TIME_FORMATTER.parse((CharSequence)str, OffsetTime::from);
        }
        catch (DateTimeParseException e) {
            throw new BackendException("parsing time from '" + str + "' failed", e);
        }
    }

    public String format(OffsetTime time) {
        int nanos = time.getNano();
        if (nanos != 0) {
            return MS_TIME_FORMATTER.format(time);
        }
        return TIME_FORMATTER.format(time);
    }
}

