/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public final class InstantType
extends AbstractDateTimeType<Instant> {
    private static final int[] SORTABLE_COLUMNS = new int[]{0, 1};
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter MS_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter NANO_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnnnnnn").withZone(ZoneId.systemDefault());

    @Override
    public String getJavaType() {
        return "Instant";
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public int getColumnCount(Backend backend) {
        return 2;
    }

    @Override
    public int[] getSortableColumns() {
        return SORTABLE_COLUMNS;
    }

    @Override
    public Optional<String> getCommentSuffix(Backend backend, int index) {
        return switch (index) {
            case 0 -> Optional.of(" [s]");
            case 1 -> Optional.of(" [ns]");
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public String getColumnGetter(int index, String varName) {
        return switch (index) {
            case 0 -> varName + ".getEpochSecond()";
            case 1 -> varName + ".getNano()";
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public String getColumnAlias(int index) {
        return switch (index) {
            case 0 -> "epochSecond";
            case 1 -> "nano";
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public Object getColumnValue(Backend backend, int index, Instant value) {
        if (value != null) {
            return switch (index) {
                case 0 -> value.getEpochSecond();
                case 1 -> value.getNano();
                default -> throw new IndexOutOfBoundsException(index);
            };
        }
        return null;
    }

    @Override
    public int getSize(Backend backend, int index, Integer size) {
        return switch (index) {
            case 0 -> super.getSize(backend, index, size);
            case 1 -> 0;
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public int getScale(Backend backend, int index, Integer scale) {
        return 0;
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        return switch (index) {
            case 0 -> SqlType.BIGINT;
            case 1 -> SqlType.INTEGER;
            default -> throw new IndexOutOfBoundsException();
        };
    }

    @Override
    public Instant valueOf(String str) {
        return this.parse(str);
    }

    @Override
    public String toString(Instant object) {
        return StringHelper.toParsableString((String)this.format(object));
    }

    @Override
    public String valueOfLiteralToCode(String str, Integer index) {
        if (index != null) {
            return str;
        }
        if (!((String)str).isEmpty() && Character.isDigit(((String)str).charAt(0))) {
            str = "\"" + (String)str + "\"";
        }
        return "Instant.parse(" + (String)str + ")";
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, Instant object, boolean mapNull, Integer size) throws SQLException {
        int nanos;
        Long seconds;
        if (object == null) {
            seconds = mapNull ? Long.valueOf(0L) : null;
            nanos = 0;
        } else {
            seconds = object.getEpochSecond();
            nanos = object.getNano();
        }
        if (seconds == null) {
            statement.setNull(pos, -5);
            statement.setNull(pos + 1, 4);
            return new Object[]{null, null};
        }
        statement.setLong(pos, seconds);
        statement.setInt(pos + 1, nanos);
        return new Object[]{seconds, nanos};
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object set(Backend backend, PreparedStatement statement, int pos, Instant object, int index, boolean mapNull, Integer size) throws SQLException {
        switch (index) {
            case 0: {
                Long seconds;
                if (object == null) {
                    if (!mapNull) {
                        statement.setNull(pos, -5);
                        return null;
                    }
                    seconds = 0L;
                } else {
                    seconds = object.getEpochSecond();
                }
                statement.setLong(pos, seconds);
                Number number = seconds;
                return number;
            }
            case 1: {
                Integer nanos;
                if (object == null) {
                    if (!mapNull) {
                        statement.setNull(pos, 4);
                        return null;
                    }
                    nanos = 0;
                } else {
                    nanos = object.getNano();
                }
                statement.setInt(pos, nanos);
                Number number = nanos;
                return number;
            }
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public Instant get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        long seconds = resultSet.getLong(pos[0]);
        int nanos = resultSet.getInt(pos[1]);
        if (resultSet.wasNull() || mapNull && seconds == 0L && nanos == 0) {
            return null;
        }
        return Instant.ofEpochSecond(seconds, nanos);
    }

    public Instant parse(String str) throws BackendException {
        if ((str = StringHelper.parseString((String)str)).length() > 9 && str.charAt(str.length() - 10) == '.') {
            try {
                return NANO_TIMESTAMP_FORMATTER.parse((CharSequence)str, Instant::from);
            }
            catch (DateTimeParseException e) {
                throw new BackendException("parsing instant with ns from '" + str + "' failed", e);
            }
        }
        if (str.length() > 3 && str.charAt(str.length() - 4) == '.') {
            try {
                return MS_TIMESTAMP_FORMATTER.parse((CharSequence)str, Instant::from);
            }
            catch (DateTimeParseException e) {
                throw new BackendException("parsing instant with ms from '" + str + "' failed", e);
            }
        }
        try {
            return TIMESTAMP_FORMATTER.parse((CharSequence)str, Instant::from);
        }
        catch (DateTimeParseException e) {
            throw new BackendException("parsing instant from '" + str + "' failed", e);
        }
    }

    public String format(Instant instant) {
        int nanos = instant.getNano();
        if (nanos != 0) {
            if (nanos % 1000000 == 0) {
                return MS_TIMESTAMP_FORMATTER.format(instant);
            }
            return NANO_TIMESTAMP_FORMATTER.format(instant);
        }
        return TIMESTAMP_FORMATTER.format(instant);
    }
}

