/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.lang.invoke.CallSite;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;

public abstract class AbstractDataType<T>
implements DataType<T> {
    public static int maxLinesInLiteral = -1;
    private static final int[] SORTABLE_COLUMNS = new int[]{0};

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public String getVariant() {
        return "";
    }

    @Override
    public boolean isColumnCountBackendSpecific() {
        return false;
    }

    @Override
    public int getColumnCount(Backend backend) {
        this.assertColumnCountNotBackendSpecific(backend);
        return 1;
    }

    @Override
    public int[] getSortableColumns() {
        this.assertColumnCountNotBackendSpecific(null);
        return SORTABLE_COLUMNS;
    }

    @Override
    public Optional<String> getColumnSuffix(Backend backend, int index) {
        if (index < 0 || index >= this.getColumnCount(backend)) {
            throw new IndexOutOfBoundsException(index);
        }
        return index == 0 ? Optional.empty() : Optional.of("_" + (index + 1));
    }

    @Override
    public Optional<String> getCommentSuffix(Backend backend, int index) {
        Optional<String> columnSuffix = this.getColumnSuffix(backend, index);
        if (columnSuffix.isPresent()) {
            String suffix = columnSuffix.get();
            if (suffix.length() > 1 && suffix.startsWith("_")) {
                suffix = suffix.substring(1);
            }
            return Optional.of(" (" + suffix + ")");
        }
        return Optional.empty();
    }

    @Override
    public List<String> createColumnNames(Backend backend, String columnName) {
        ArrayList<CallSite> columns = new ArrayList<CallSite>();
        int columnCount = this.getColumnCount(backend);
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            columns.add((CallSite)((Object)(columnName + this.getColumnSuffix(backend, columnIndex).orElse(""))));
        }
        return Collections.unmodifiableList(columns);
    }

    @Override
    public String createColumnNamesAsString(Backend backend, String columnName, String separator) {
        List<String> columnNames = this.createColumnNames(backend, columnName);
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String name : columnNames) {
            if (first) {
                first = false;
            } else {
                buf.append(separator);
            }
            buf.append(name);
        }
        return buf.toString();
    }

    @Override
    public int getSize(Backend backend, int index, Integer size) {
        return size == null ? 0 : size;
    }

    @Override
    public int getScale(Backend backend, int index, Integer scale) {
        return scale == null ? 0 : scale;
    }

    @Override
    public Object getColumnValue(Backend backend, int index, T value) {
        this.assertColumnCountNotBackendSpecific(backend);
        return value;
    }

    @Override
    public String getColumnGetter(int index, String varName) {
        if (this.getColumnCount(null) == 1) {
            return "";
        }
        throw new UnsupportedOperationException("getColumnGetter not yet implemented for multi-column datatype " + this);
    }

    @Override
    public String getColumnAlias(int index) {
        if (this.getColumnCount(null) == 1) {
            return "";
        }
        throw new UnsupportedOperationException("getColumnAlias not yet implemented for multi-column datatype " + this);
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public DataType<?> toNonPrimitive() {
        return this;
    }

    @Override
    public Optional<DataType<?>> toPrimitive() {
        return Optional.empty();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isDateOrTime() {
        return false;
    }

    @Override
    public boolean isTimezoneApplicable() {
        return false;
    }

    @Override
    public boolean isBool() {
        return false;
    }

    @Override
    public boolean isMapNullSupported() {
        return false;
    }

    @Override
    public boolean isUTCSupported() {
        return false;
    }

    @Override
    public boolean isModelProvidingInnerType() {
        return this.isJavaTypeGenerified();
    }

    @Override
    public boolean isJavaTypeGenerified() {
        return false;
    }

    @Override
    public boolean isDowncastNecessary() {
        return false;
    }

    @Override
    public boolean isLiteralSupported(Integer index) {
        return this.getColumnCount(null) == 1 || index != null;
    }

    @Override
    public String toLiteral(String str, Integer index) {
        if (index == null && !this.isNumeric() && !((String)str).isEmpty() && ((String)str).charAt(0) != '\'') {
            str = "'" + (String)str + "'";
        }
        return str;
    }

    @Override
    public String valueOfLiteralToCode(String str, Integer index) {
        if (this.isLiteralSupported(index)) {
            return str;
        }
        if (index == null && !((String)str).isEmpty() && ((String)str).charAt(0) != '\"') {
            str = "\"" + (String)str + "\"";
        }
        return (this.isPredefined() ? this.getJavaType() : this.getDataTypeConstant()) + ".valueOf(" + (String)str + ")";
    }

    @Override
    public String toString(T object) {
        return StringHelper.toParsableString((String)object.toString());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getJavaType());
        if (this.isJavaTypeGenerified()) {
            buf.append("<?>");
        }
        return buf.toString();
    }

    @Override
    public String getDataTypeConstant() {
        StringBuilder buf = new StringBuilder();
        buf.append("DT_").append(this.getJavaType().toUpperCase(Locale.ROOT));
        if (!this.getVariant().isEmpty()) {
            buf.append('_').append(this.getVariant().toUpperCase(Locale.ROOT));
        }
        return buf.toString();
    }

    @Override
    public Object set(Backend backend, PreparedStatement statement, int pos, T object, int index, boolean mapNull, Integer size) throws SQLException {
        if (this.getColumnCount(backend) == 1) {
            return this.set(backend, statement, pos, object, mapNull, size);
        }
        throw new UnsupportedOperationException("not yet implemented for multi-column datatype " + this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDataType that = (AbstractDataType)o;
        if (!this.getJavaType().equals(that.getJavaType())) {
            return false;
        }
        return this.getVariant().equals(that.getVariant());
    }

    public int hashCode() {
        int result = this.getJavaType().hashCode();
        result = 31 * result + this.getVariant().hashCode();
        return result;
    }

    protected void assertColumnCountNotBackendSpecific(Backend backend) {
        if (backend == null && this.isColumnCountBackendSpecific()) {
            throw new BackendException("backend-specific type " + this + " cannot be used in a backend-agnostic context");
        }
    }

    protected String valueStringToCode(String str) {
        if (str != null && !((String)str).isEmpty() && ((String)str).charAt(0) != '\"') {
            if (((String)str).contains("\n")) {
                StringBuilder buf = new StringBuilder();
                buf.append("\"\"\"\n");
                long numLines = ((String)str).lines().count();
                boolean truncated = maxLinesInLiteral > 0 && numLines > (long)maxLinesInLiteral;
                Stream<String> lines = truncated ? ((String)str).lines().limit(maxLinesInLiteral) : ((String)str).lines();
                lines.forEach(line -> {
                    if (line.endsWith(" ")) {
                        buf.append((CharSequence)line, 0, line.length() - 1).append("\\s");
                    } else {
                        buf.append((String)line);
                    }
                    buf.append('\n');
                });
                if (truncated) {
                    buf.append("... <").append(maxLinesInLiteral).append('/').append(numLines).append("> ...\n");
                }
                buf.append("\"\"\"");
                str = buf.toString();
            } else {
                str = "\"" + (String)str + "\"";
            }
        }
        return str;
    }
}

