/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.metadata.MetaDataUtilities;
import org.tentackle.sql.metadata.TableMetaData;

public class ColumnMetaData {
    private final TableMetaData tableMetaData;
    private String columnName;
    private String comment;
    private int type;
    private String typeName;
    private int size;
    private int scale;
    private String defaultValue;
    private boolean nullable;

    public ColumnMetaData(TableMetaData tableMetaData) {
        this.tableMetaData = tableMetaData;
    }

    public TableMetaData getTableMetaData() {
        return this.tableMetaData;
    }

    public void setupColumnFromMetaData(ResultSet resultSet) throws SQLException {
        this.columnName = StringHelper.toLower((String)resultSet.getString("COLUMN_NAME"));
        this.comment = resultSet.getString("REMARKS");
        this.size = resultSet.getInt("COLUMN_SIZE");
        this.scale = resultSet.getShort("DECIMAL_DIGITS");
        this.nullable = resultSet.getInt("NULLABLE") == 1;
        this.type = resultSet.getInt("DATA_TYPE");
        this.typeName = resultSet.getString("TYPE_NAME");
        this.defaultValue = resultSet.getString("COLUMN_DEF");
        this.validate();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean matchesSqlType(SqlType sqlType) {
        SqlType[] possibleSqlTypes;
        Backend backend = this.tableMetaData.getModelMetaData().getBackend();
        for (SqlType possibleType : possibleSqlTypes = backend.jdbcTypeToSqlType(this.type, this.size, this.scale)) {
            if (sqlType != possibleType) continue;
            return true;
        }
        return false;
    }

    public void validate() {
        if (StringHelper.isAllWhitespace((String)this.comment)) {
            this.comment = null;
        }
        if (this.defaultValue != null && this.defaultValue.isEmpty()) {
            this.defaultValue = null;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.columnName);
        buf.append(" ");
        buf.append(MetaDataUtilities.getInstance().jdbcTypeToString(this.type));
        if (this.size > 0) {
            buf.append("(");
            buf.append(this.size);
            if (this.scale > 0) {
                buf.append(",");
                buf.append(this.scale);
            }
            buf.append(")");
        }
        if (!this.nullable) {
            buf.append(" NOT NULL");
        }
        if (this.defaultValue != null) {
            buf.append(" DEFAULT ");
            buf.append(this.defaultValue);
        }
        if (this.comment != null) {
            buf.append(' ').append(this.tableMetaData.getModelMetaData().getBackend().getSingleLineComment()).append(' ').append(this.comment);
        }
        return buf.toString();
    }
}

