/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.stream.Stream;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDataType;

@Service(value=DataType.class)
public class StringType
extends AbstractDataType<String> {
    public static int maxLinesInLiteral = -1;

    @Override
    public String getJavaType() {
        return "String";
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.VARCHAR;
    }

    @Override
    public String valueOf(String str) {
        return StringHelper.parseString((String)str);
    }

    @Override
    public String valueOfLiteralToCode(String str, Integer index) {
        if (!((String)str).isEmpty() && ((String)str).charAt(0) != '\"') {
            if (((String)str).contains("\n")) {
                StringBuilder buf = new StringBuilder();
                buf.append("\"\"\"\n");
                long numLines = ((String)str).lines().count();
                boolean truncated = maxLinesInLiteral > 0 && numLines > (long)maxLinesInLiteral;
                Stream<String> lines = truncated ? ((String)str).lines().limit(maxLinesInLiteral) : ((String)str).lines();
                lines.forEach(line -> {
                    if (line.endsWith(" ")) {
                        buf.append((CharSequence)line, 0, line.length() - 1).append("\\s");
                    } else {
                        buf.append((String)line);
                    }
                    buf.append('\n');
                });
                if (truncated) {
                    buf.append("... <").append(maxLinesInLiteral).append('/').append(numLines).append("> ...\n");
                }
                buf.append("\"\"\"");
                str = buf.toString();
            } else {
                str = "\"" + (String)str + "\"";
            }
        }
        return str;
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, String object, boolean mapNull, Integer size) throws SQLException {
        if (object == null && mapNull) {
            object = backend.getEmptyString();
        }
        if (object == null) {
            statement.setNull(pos, 12);
        } else {
            statement.setString(pos, object);
        }
        return new Object[]{object};
    }

    @Override
    public String get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        String str = resultSet.getString(pos[0]);
        if (mapNull && str != null && str.equals(backend.getEmptyString())) {
            return null;
        }
        return str;
    }
}

