/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public class LocalTimeType
extends AbstractDateTimeType<LocalTime> {
    @Override
    public String getJavaType() {
        return "LocalTime";
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.TIME;
    }

    @Override
    public LocalTime valueOf(String str) {
        return this.parse(str);
    }

    @Override
    public String toString(LocalTime object) {
        return StringHelper.toParsableString((String)this.format(object));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, LocalTime object, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            statement.setNull(pos, 92);
        } else {
            statement.setTime(pos, Time.valueOf(object));
        }
        return new Object[]{object};
    }

    @Override
    public LocalTime get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        Time time = resultSet.getTime(pos[0]);
        return time == null ? null : time.toLocalTime();
    }

    protected LocalTime parse(String str) throws BackendException {
        try {
            return LocalTime.parse(StringHelper.parseString((String)str), DateTimeFormatter.ISO_LOCAL_TIME);
        }
        catch (DateTimeParseException e) {
            throw new BackendException("parsing time from '" + str + "' failed", e);
        }
    }

    protected String format(LocalTime time) {
        return DateTimeFormatter.ISO_LOCAL_TIME.format(time);
    }
}

