/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.tentackle.common.Date;
import org.tentackle.common.DateHelper;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public class DateType
extends AbstractDateTimeType<java.sql.Date> {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    @Override
    public boolean isTimezoneApplicable() {
        return true;
    }

    @Override
    public String getJavaType() {
        return "Date";
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.DATE;
    }

    @Override
    public java.sql.Date valueOf(String str) {
        return this.parse(str);
    }

    @Override
    public String toString(java.sql.Date object) {
        return StringHelper.toParsableString((String)this.format(object));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, java.sql.Date object, boolean mapNull, Integer size) throws SQLException {
        if (object == null && mapNull) {
            object = DateHelper.MIN_DATE;
        }
        if (object == null) {
            statement.setNull(pos, 91);
        } else {
            statement.setDate(pos, object);
        }
        return new Object[]{object};
    }

    @Override
    public java.sql.Date get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        java.sql.Date date = resultSet.getDate(pos[0]);
        if (date == null || mapNull && date.equals(DateHelper.MIN_DATE)) {
            return null;
        }
        return Date.createFrozen((long)date.getTime());
    }

    protected java.sql.Date parse(String str) throws BackendException {
        try {
            return java.sql.Date.valueOf(DATE_FORMAT.parse((CharSequence)StringHelper.parseString((String)str), LocalDate::from));
        }
        catch (DateTimeParseException e) {
            throw new BackendException("parsing date from '" + str + "' failed", e);
        }
    }

    protected String format(java.sql.Date date) {
        return DATE_FORMAT.format(date.toLocalDate());
    }
}

