/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.DataTypeFactory;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractNumberType;

@Service(value=DataType.class)
public class ByteType
extends AbstractNumberType<Byte> {
    @Override
    public String getJavaType() {
        return "Byte";
    }

    @Override
    public boolean isDowncastNecessary() {
        return true;
    }

    @Override
    public Optional<DataType<?>> toPrimitive() {
        return Optional.of(DataTypeFactory.getInstance().get("byte"));
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.TINYINT;
    }

    @Override
    public Byte valueOf(String str) {
        return Byte.valueOf(StringHelper.parseString((String)str));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, Byte object, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            statement.setNull(pos, -6);
        } else {
            statement.setByte(pos, object);
        }
        return new Object[]{object};
    }

    @Override
    public Byte get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        return resultSet.getByte(pos[0]);
    }
}

