/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import org.tentackle.sql.Backend;

public class NonStandardCommons {
    public static String sqlCreateCommentOnTable(Backend backend, String tableName, String comment) {
        return "COMMENT ON TABLE " + tableName + " IS " + backend.toQuotedString(comment) + backend.getStatementSeparator() + "\n";
    }

    public static String sqlCreateCommentOnColumn(Backend backend, String tableName, String columnName, String comment) {
        StringBuilder buf = new StringBuilder("COMMENT ON COLUMN ");
        buf.append(tableName);
        buf.append(".");
        buf.append(columnName);
        buf.append(" IS ");
        if (comment == null) {
            buf.append("NULL");
        } else {
            buf.append(backend.toQuotedString(comment));
        }
        buf.append(backend.getStatementSeparator()).append('\n');
        return buf.toString();
    }

    public static String sqlCreateSequence(String name, Long start, Long increment) {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE SEQUENCE ").append(name);
        if (increment != null) {
            buf.append(" INCREMENT BY ").append(increment);
        }
        if (start != null) {
            buf.append(" START WITH ").append(start);
        }
        return buf.toString();
    }

    public static String sqlCreateCommentOnSequence(Backend backend, String sequenceName, String comment) {
        StringBuilder buf = new StringBuilder("COMMENT ON SEQUENCE ");
        buf.append(sequenceName);
        buf.append(" IS ");
        if (comment == null) {
            buf.append("NULL");
        } else {
            buf.append(backend.toQuotedString(comment));
        }
        buf.append(backend.getStatementSeparator()).append('\n');
        return buf.toString();
    }

    private NonStandardCommons() {
    }
}

