/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.DataTypeFactory;
import org.tentackle.sql.datatypes.ConvertibleType;

@Service(value=DataTypeFactory.class)
public class DefaultDataTypeFactory
implements DataTypeFactory {
    private final Map<Key, DataType<?>> dataTypeMap = new HashMap();
    private final ConvertibleType convertibleType;

    public DefaultDataTypeFactory() {
        try {
            for (Class dataTypeClass : ServiceFactory.getServiceFinder().findServiceProviders(DataType.class)) {
                DataType dataType = (DataType)dataTypeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.dataTypeMap.putIfAbsent(new Key(dataType), dataType);
            }
            this.convertibleType = (ConvertibleType)this.get("implementing Convertible");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException nfe) {
            throw new BackendException("supported data types could not be determined", nfe);
        }
    }

    @Override
    public DataType<?> get(String name, String variant) {
        return this.dataTypeMap.get(new Key(name, variant));
    }

    @Override
    public ConvertibleType getConvertibleType() {
        return this.convertibleType;
    }

    private static class Key {
        private final String javaType;
        private final String variant;

        private Key(String javaType, String variant) {
            this.javaType = Objects.requireNonNull(javaType);
            this.variant = Objects.requireNonNull(variant);
        }

        private Key(DataType<?> dataType) {
            this(dataType.getJavaType(), dataType.getVariant());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.javaType.equals(key.javaType)) {
                return false;
            }
            return this.variant.equals(key.variant);
        }

        public int hashCode() {
            int result = this.javaType.hashCode();
            result = 31 * result + this.variant.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (!this.variant.isEmpty()) {
                buf.append(this.variant).append(' ');
            }
            buf.append(this.javaType);
            return buf.toString();
        }
    }
}

