/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.tentackle.common.Service;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.sql.AbstractSql2003Backend;
import org.tentackle.sql.Backend;
import org.tentackle.sql.NonStandardCommons;
import org.tentackle.sql.SqlType;

@Service(value=Backend.class)
public class Db2
extends AbstractSql2003Backend {
    private static final String STR_CONTINUATION = " \\";

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":db2");
    }

    @Override
    public String getName() {
        return "DB2";
    }

    @Override
    public String getDriverClassName() {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    @Override
    public boolean sqlResultSetIsClosedSupported() {
        return true;
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        switch (sqlType) {
            case DECIMAL: {
                return 31;
            }
            case VARCHAR: {
                return 512;
            }
        }
        return super.getMaxSize(sqlType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getBackendId(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT application_id() AS appid FROM SYSIBM.SYSDUMMY1");
            if (rs.next()) {
                String string2 = rs.getString(1);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException ex) {
            throw new TentackleRuntimeException("cannot determine backend id", (Throwable)ex);
        }
    }

    @Override
    public boolean isFunctionBasedIndexSupported() {
        return true;
    }

    @Override
    public String sqlCreateTableIntro(String tableName, String comment) {
        return this.appendContinuationString(super.sqlCreateTableIntro(tableName, comment));
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        switch (sqlType) {
            case BIT: {
                return "SMALLINT";
            }
            case TINYINT: {
                return "SMALLINT";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case FLOAT: {
                return "REAL";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case DECIMAL: {
                return "DECIMAL";
            }
            case CHAR: {
                return "CHAR(1)";
            }
            case VARCHAR: {
                return "VARCHAR";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "DATE";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case BLOB: {
                return "BLOB";
            }
            case CLOB: {
                return "CLOB";
            }
        }
        return super.sqlTypeToString(sqlType, size);
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case 5: {
                return new SqlType[]{SqlType.BIT, SqlType.TINYINT, SqlType.SMALLINT};
            }
            case 91: 
            case 92: {
                return new SqlType[]{SqlType.DATE, SqlType.TIME};
            }
        }
        return super.jdbcTypeToSqlType(jdbcType, size, scale);
    }

    @Override
    public String sqlCreateColumn(String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue, boolean primaryKey, boolean withTrailingComma) {
        return this.appendContinuationString(super.sqlCreateColumn(columnName, comment, sqlType, size, scale, nullable, defaultValue, primaryKey, withTrailingComma));
    }

    @Override
    public String sqlCreateTableComment(String tableName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnTable(this, tableName, comment);
    }

    @Override
    public String sqlCreateColumnComment(String tableName, String columnName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnColumn(this, tableName, columnName, comment);
    }

    @Override
    public String sqlAddColumn(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ADD (" + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false) + ");\n";
    }

    @Override
    public String sqlAlterColumnType(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + columnName + " DATA TYPE " + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false) + ";\n";
    }

    @Override
    public String sqlRenameIndex(String tableName, String oldIndexName, String newIndexName) {
        return "RENAME INDEX " + oldIndexName + " TO " + newIndexName + ";\n";
    }

    @Override
    protected boolean isDropIfExistsSupported() {
        return true;
    }

    private String appendContinuationString(String sql) {
        sql = ((String)sql).endsWith("\n") ? ((String)sql).substring(0, ((String)sql).length() - 1) + " \\\n" : (String)sql + STR_CONTINUATION;
        return sql;
    }
}

