/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.tentackle.sql.AbstractSql92Backend;
import org.tentackle.sql.BackendPreparedStatement;

public abstract class AbstractSql2003Backend
extends AbstractSql92Backend {
    public static final String SQL_WINDOW_1 = "* FROM (SELECT F_O_O.*, ROW_NUMBER() OVER() AS R_O_W FROM (SELECT ";
    public static final String SQL_WINDOW_2 = ") AS F_O_O) AS B_A_R WHERE ";
    public static final String SQL_WINDOW_LIMIT = "R_O_W <= ?";
    public static final String SQL_WINDOW_OFFSET = "R_O_W > ?";
    public static final String[] RESERVED_WORDS_SQL2003 = new String[]{"ARRAY", "ASENSITIVE", "ATOMIC", "BIGINT", "BLOB", "BOOLEAN", "CALLED", "CLOB", "CUBE", "CYCLE", "DEREF", "DYNAMIC", "EACH", "ELEMENT", "FILTER", "ITERATE", "LARGE", "LATERAL", "LOCALTIME", "LOCALTIMESTAMP", "MEMBER", "MERGE", "MULTISET", "NCLOB", "NEW", "NONE", "OVER", "PARTITION", "RANGE", "RECURSIVE", "REF", "REFERENCING", "RELEASE", "RESULT", "ROLLUP", "ROW", "SAVEPOINT", "SCOPE", "SEARCH", "SENSITIVE", "SIMILAR", "SPECIFICTYPE", "START", "SYMMETRIC", "SYSTEM", "TABLESAMPLE", "TREAT", "TRIGGER", "UNNEST", "WINDOW", "WITHOUT"};
    private static Set<String> reservedWords;

    @Override
    public synchronized Set<String> getReservedWords() {
        if (reservedWords == null) {
            reservedWords = new HashSet<String>(super.getReservedWords());
            reservedWords.addAll(Arrays.asList(RESERVED_WORDS_SQL2003));
        }
        return reservedWords;
    }

    @Override
    public void buildSelectSql(StringBuilder sqlBuilder, boolean writeLock, int limit, int offset) {
        if (limit > 0 || offset > 0) {
            sqlBuilder.insert(0, SQL_WINDOW_1);
        }
        sqlBuilder.insert(0, "SELECT ");
        if (writeLock) {
            sqlBuilder.append(" FOR UPDATE");
        }
        if (limit > 0 || offset > 0) {
            sqlBuilder.append(SQL_WINDOW_2);
            if (offset > 0) {
                sqlBuilder.append(SQL_WINDOW_OFFSET);
            }
            if (limit > 0) {
                if (offset > 0) {
                    sqlBuilder.append(" AND ");
                }
                sqlBuilder.append(SQL_WINDOW_LIMIT);
            }
        }
    }

    @Override
    public int setLeadingSelectParameters(BackendPreparedStatement stmt, int limit, int offset) {
        return 1;
    }

    @Override
    public int setTrailingSelectParameters(BackendPreparedStatement stmt, int index, int limit, int offset) {
        if (offset > 0) {
            stmt.setInt(index++, offset);
        }
        if (limit > 0) {
            stmt.setInt(index++, limit);
        }
        return index;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String sqlNextFromSequene(String name) {
        return "SELECT NEXT VALUE FOR " + name;
    }
}

