/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;
import org.tentackle.common.Cryptor;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.BackendInfo;
import org.tentackle.sql.JoinType;
import org.tentackle.sql.MigrationStrategy;
import org.tentackle.sql.SqlNameType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.metadata.ColumnMetaData;
import org.tentackle.sql.metadata.IndexColumnMetaData;
import org.tentackle.sql.metadata.IndexMetaData;
import org.tentackle.sql.metadata.ModelMetaData;
import org.tentackle.sql.metadata.TableMetaData;

public abstract class AbstractBackend
implements Backend {
    protected static final String TYPE_BIGINT = "BIGINT";
    protected static final String TYPE_BIT = "BIT";
    protected static final String TYPE_BLOB = "BLOB";
    protected static final String TYPE_CLOB = "CLOB";
    protected static final String TYPE_BOOL = "BOOL";
    protected static final String TYPE_BOOLEAN = "BOOLEAN";
    protected static final String TYPE_BYTEA = "BYTEA";
    protected static final String TYPE_BYTE = "BYTE";
    protected static final String TYPE_CHAR_1 = "CHAR(1)";
    protected static final String TYPE_DATE = "DATE";
    protected static final String TYPE_DATETIME = "DATETIME";
    protected static final String TYPE_DATETIME_YEAR_TO_SECOND = "DATETIME YEAR TO SECOND";
    protected static final String TYPE_DECIMAL = "DECIMAL";
    protected static final String TYPE_DECIMAL_19 = "DECIMAL(19)";
    protected static final String TYPE_DOUBLE = "DOUBLE";
    protected static final String TYPE_FLOAT = "FLOAT";
    protected static final String TYPE_FLOAT4 = "FLOAT4";
    protected static final String TYPE_FLOAT8 = "FLOAT8";
    protected static final String TYPE_INT = "INT";
    protected static final String TYPE_INT2 = "INT2";
    protected static final String TYPE_INT4 = "INT4";
    protected static final String TYPE_INT8 = "INT8";
    protected static final String TYPE_INTEGER = "INTEGER";
    protected static final String TYPE_NCHAR_1 = "NCHAR(1)";
    protected static final String TYPE_NUMBER = "NUMBER";
    protected static final String TYPE_NUMBER_1 = "NUMBER(1)";
    protected static final String TYPE_NUMBER_5 = "NUMBER(5)";
    protected static final String TYPE_NUMBER_10 = "NUMBER(10)";
    protected static final String TYPE_NUMBER_19 = "NUMBER(19)";
    protected static final String TYPE_NVARCHAR = "NVARCHAR";
    protected static final String TYPE_NVARCHAR_MAX = "NVARCHAR(MAX)";
    protected static final String TYPE_REAL = "REAL";
    protected static final String TYPE_TEXT = "TEXT";
    protected static final String TYPE_TIME = "TIME";
    protected static final String TYPE_TIMESTAMP = "TIMESTAMP";
    protected static final String TYPE_TINYINT = "TINYINT";
    protected static final String TYPE_SMALLFLOAT = "SMALLFLOAT";
    protected static final String TYPE_SMALLINT = "SMALLINT";
    protected static final String TYPE_VARBINARY_MAX = "VARBINARY(MAX)";
    protected static final String TYPE_VARCHAR = "VARCHAR";
    private boolean dropIfExistsEnabled;

    @Override
    public boolean isMatchingName(String name) {
        return this.getName().equalsIgnoreCase(name);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Connection createConnection(String url, String username, char[] password) throws SQLException {
        try {
            Class.forName(this.getDriverClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return DriverManager.getConnection(url, username, this.createPassword(password));
    }

    protected String createPassword(char[] password) {
        String pw = password != null ? (password.length > 1 && password[0] == '~' && password[1] != '~' ? Cryptor.getInstance().decrypt64(new String(password, 1, password.length - 1)) : new String(password)) : "";
        return pw;
    }

    @Override
    public DatabaseMetaData[] getMetaData(BackendInfo backendInfo) throws SQLException {
        Connection con = this.createConnection(backendInfo.getUrl(), backendInfo.getUser(), backendInfo.getPassword());
        DatabaseMetaData metaData = con.getMetaData();
        return new DatabaseMetaData[]{metaData};
    }

    @Override
    public boolean isTemporaryName(String name) {
        return name != null && name.startsWith("_");
    }

    @Override
    public String getEmptyString() {
        return "";
    }

    @Override
    public String sqlAsBeforeTableAlias() {
        return " ";
    }

    @Override
    public boolean needAliasForSubselect() {
        return false;
    }

    @Override
    public boolean sqlRequiresExtraCommit() {
        return false;
    }

    @Override
    public boolean sqlResultSetIsClosedSupported() {
        return false;
    }

    @Override
    public String sqlComment(String text) {
        if (text != null) {
            StringTokenizer stok = new StringTokenizer(text, "\n");
            StringBuilder buf = new StringBuilder();
            while (stok.hasMoreTokens()) {
                String line = stok.nextToken();
                if (!line.startsWith("-- ")) {
                    buf.append("-- ");
                }
                buf.append(line);
                buf.append("\n");
            }
            return buf.toString();
        }
        return null;
    }

    @Override
    public String sqlJoin(JoinType type, String joinedTableName, String joinedTableAlias, String join) {
        StringBuilder buf = new StringBuilder();
        buf.append(' ').append((Object)type).append(' ');
        buf.append(joinedTableName);
        if (joinedTableAlias != null) {
            buf.append(this.sqlAsBeforeTableAlias()).append(joinedTableAlias);
        }
        buf.append(" ON ");
        buf.append(join);
        return buf.toString();
    }

    @Override
    public String sqlFunction(String functionName, String expression) {
        StringBuilder buf = new StringBuilder(functionName.toUpperCase()).append('(');
        if (expression != null) {
            buf.append(expression);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String getCoalesceKeyword() {
        throw new BackendException("backend " + this + " does not support COALESCE or similar keywords");
    }

    @Override
    public boolean allowsExpressionsReferringToTablesBeingUpdated() {
        return true;
    }

    @Override
    public boolean needSetLongWorkaround() {
        return false;
    }

    @Override
    public boolean needTxForFetchsize() {
        return false;
    }

    @Override
    public boolean isConstraintException(SQLException ex) {
        return this.isExceptionStateStartingWith(ex, "23");
    }

    @Override
    public boolean isCommunicationLinkException(SQLException ex) {
        return this.isExceptionStateStartingWith(ex, "08") || this.isExceptionStateStartingWith(ex, "57");
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        switch (sqlType) {
            case BIT: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case CHAR: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case BLOB: 
            case CLOB: {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int getMaxScale(SqlType sqlType, int size) {
        if (size > 0) {
            return size - 1;
        }
        return 0;
    }

    @Override
    public int getDefaultSize(SqlType sqlType) {
        if (sqlType == SqlType.VARCHAR) {
            return this.getMaxSize(sqlType);
        }
        return 0;
    }

    @Override
    public String getDefaultSchema() {
        return null;
    }

    @Override
    public ModelMetaData getModelMetaData(DatabaseMetaData[] metaData, String[] schemas, String ... tableNames) {
        ModelMetaData modelMetaData = new ModelMetaData(this, metaData, schemas);
        for (String tableName : tableNames) {
            TableMetaData table = this.getTableMetaData(modelMetaData, tableName);
            if (table == null) continue;
            modelMetaData.addTableMetaData(table);
        }
        return modelMetaData;
    }

    @Override
    public TableMetaData getTableMetaData(ModelMetaData modelMetaData, String tableName) {
        TableMetaData table = this.createTableMetaData(modelMetaData, tableName);
        String schemaPattern = null;
        String tablePattern = tableName;
        int dotNdx = tableName.indexOf(46);
        if (dotNdx >= 0) {
            schemaPattern = tableName.substring(0, dotNdx);
            tablePattern = tableName.substring(dotNdx + 1);
        }
        boolean found = false;
        for (DatabaseMetaData metaData : modelMetaData.getMetaData()) {
            try {
                try {
                    table.setupTableFromMetaData(metaData, modelMetaData.getSchemas(), schemaPattern, tablePattern);
                    found = true;
                    break;
                }
                catch (BackendException ex1) {
                    try {
                        table.setupTableFromMetaData(metaData, modelMetaData.getSchemas(), schemaPattern == null ? null : schemaPattern.toUpperCase(), tablePattern.toUpperCase());
                        found = true;
                        break;
                    }
                    catch (BackendException ex2) {
                        try {
                            table.setupTableFromMetaData(metaData, modelMetaData.getSchemas(), schemaPattern == null ? null : schemaPattern.toLowerCase(), tablePattern.toLowerCase());
                            found = true;
                            break;
                        }
                        catch (BackendException backendException) {
                        }
                    }
                }
            }
            catch (SQLException sqx) {
                throw new BackendException("backend lacks essential meta data support", sqx);
            }
        }
        return found ? table : null;
    }

    @Override
    public TableMetaData createTableMetaData(ModelMetaData modelMetaData, String tableName) {
        return new TableMetaData(modelMetaData, tableName);
    }

    @Override
    public ColumnMetaData createColumnMetaData(TableMetaData tableMetaData) {
        return new ColumnMetaData(tableMetaData);
    }

    @Override
    public IndexMetaData createIndexMetaData(TableMetaData tableMetaData) {
        return new IndexMetaData(tableMetaData);
    }

    @Override
    public IndexColumnMetaData createIndexColumnMetaData(IndexMetaData indexMetaData) {
        return new IndexColumnMetaData(indexMetaData);
    }

    @Override
    public String sqlCreateTableIntro(String tableName, String comment) {
        StringBuilder buf = new StringBuilder(this.sqlCreateTableIntroWithoutComment(tableName));
        if (comment != null) {
            buf.append(" -- ");
            buf.append(comment);
        }
        buf.append('\n');
        return buf.toString();
    }

    protected String sqlCreateTableIntroWithoutComment(String tableName) {
        return "CREATE TABLE " + tableName + " (";
    }

    @Override
    public String sqlCreateTableClosing(String tableName, String comment) {
        return ");\n";
    }

    @Override
    public String sqlCreateTableComment(String tableName, String comment) {
        return "";
    }

    @Override
    public String sqlAlterTableComment(String tableName, String comment) {
        return this.sqlCreateTableComment(tableName, comment);
    }

    @Override
    public String columnTypeToString(SqlType sqlType, int size, int scale) {
        int maxSize;
        StringBuilder buf = new StringBuilder();
        buf.append(this.sqlTypeToString(sqlType, size));
        if (size == 0) {
            size = this.getDefaultSize(sqlType);
        }
        if ((maxSize = this.getMaxSize(sqlType)) != 0 && size > maxSize) {
            size = maxSize;
        }
        if (size > 0) {
            buf.append('(');
            buf.append(size);
            if (scale > 0) {
                buf.append(',');
                int maxScale = this.getMaxScale(sqlType, size);
                if (maxScale > 0 && scale > maxScale) {
                    scale = maxScale;
                }
                buf.append(scale);
            }
            buf.append(')');
        }
        return buf.toString();
    }

    @Override
    public String columnTypeNullDefaultToString(String columnName, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.columnTypeToString(sqlType, size, scale));
        if (!nullable) {
            buf.append(" NOT NULL");
        }
        if (defaultValue != null) {
            buf.append(" DEFAULT ");
            buf.append(this.valueToLiteral(sqlType, defaultValue));
        }
        return buf.toString();
    }

    @Override
    public String valueToLiteral(SqlType sqlType, Object value) {
        switch (sqlType) {
            case BIT: 
            case CHAR: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case VARCHAR: {
                return "'" + value + "'";
            }
        }
        return value.toString();
    }

    @Override
    public String sqlCreateColumn(String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue, boolean primaryKey, boolean withTrailingComma) {
        StringBuilder buf = new StringBuilder(this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, primaryKey, withTrailingComma));
        if (comment != null) {
            buf.append(" -- ");
            buf.append(comment);
        }
        buf.append('\n');
        return buf.toString();
    }

    @Override
    public boolean isDefaultEqual(ColumnMetaData column, SqlType sqlType, Object defaultValue) {
        String columnDefault;
        String attributeDefault = this.normalizeDefault(defaultValue == null ? null : defaultValue.toString());
        boolean rv = attributeDefault.equals(columnDefault = this.normalizeDefault(column.getDefaultValue()));
        if (!rv && column.getDefaultValue() != null) {
            Object value = sqlType.parse(column.getDefaultValue());
            rv = Objects.equals(defaultValue, value);
        }
        return rv;
    }

    protected String normalizeDefault(String str) {
        if (str == null) {
            str = "";
        } else {
            if ((str = str.toUpperCase()).startsWith("'")) {
                str = str.substring(1);
            }
            if (str.endsWith("'")) {
                str = str.substring(0, str.length() - 1);
            }
        }
        return str;
    }

    @Override
    public MigrationStrategy[] getMigrationStrategy(ColumnMetaData column, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        boolean scaleChanged;
        ArrayList<MigrationStrategy> strategies = new ArrayList<MigrationStrategy>();
        boolean nameChanged = !column.getColumnName().equalsIgnoreCase(columnName);
        boolean commentChanged = !Objects.equals(column.getComment(), comment);
        boolean defaultChanged = !this.isDefaultEqual(column, sqlType, defaultValue);
        boolean nullChanged = column.isNullable() != nullable;
        boolean typeChanged = !column.matchesSqlType(sqlType);
        boolean sizeChanged = size > column.getSize();
        boolean bl = scaleChanged = scale > column.getScale();
        if (nameChanged) {
            strategies.add(MigrationStrategy.NAME);
        }
        if (typeChanged || sizeChanged || scaleChanged) {
            strategies.add(MigrationStrategy.TYPE);
        }
        if (nullChanged) {
            strategies.add(MigrationStrategy.NULL);
        }
        if (defaultChanged) {
            strategies.add(MigrationStrategy.DEFAULT);
        }
        if (commentChanged) {
            strategies.add(MigrationStrategy.COMMENT);
        }
        return strategies.toArray(new MigrationStrategy[0]);
    }

    @Override
    public String sqlRenameColumn(String tableName, String oldColumnName, String newColumnName) {
        return "ALTER TABLE " + tableName + " RENAME COLUMN " + oldColumnName + " TO " + newColumnName + ";\n";
    }

    @Override
    public String sqlRenameIndex(String tableName, String oldIndexName, String newIndexName) {
        return "ALTER INDEX " + oldIndexName + " RENAME TO " + newIndexName + ";\n";
    }

    @Override
    public String sqlRenameAndAlterColumnType(String tableName, String oldColumnName, String newColumnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        throw new BackendException("backend supports rename column without full declaration");
    }

    @Override
    public String sqlAddColumn(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ADD COLUMN " + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false) + ";\n";
    }

    @Override
    public String sqlDropColumn(String tableName, String columnName) {
        StringBuilder buf = new StringBuilder();
        buf.append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ");
        if (this.isDropIfExistsEnabled()) {
            buf.append("IF EXISTS ");
        }
        buf.append(columnName).append(";\n");
        return buf.toString();
    }

    @Override
    public String sqlAlterColumnType(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + columnName + " " + this.columnTypeNullDefaultToString(columnName, sqlType, size, scale, nullable, defaultValue) + ";\n";
    }

    @Override
    public String sqlAlterColumnNullConstraint(String tableName, String columnName, boolean nullable) {
        return null;
    }

    @Override
    public String sqlUpdateToNotNull(String tableName, String columnName, SqlType sqlType, Object defaultValue) {
        return "UPDATE " + tableName + " SET " + columnName + "=" + this.valueToLiteral(sqlType, defaultValue != null ? defaultValue : sqlType.getDefaultValue()) + " WHERE " + columnName + " IS NULL;\n";
    }

    @Override
    public String sqlAlterColumnDefault(String tableName, String columnName, SqlType sqlType, Object defaultValue) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" ALTER COLUMN ");
        buf.append(columnName);
        buf.append(" ");
        if (defaultValue == null) {
            buf.append("DROP DEFAULT");
        } else {
            buf.append("SET DEFAULT ");
            buf.append(this.valueToLiteral(sqlType, defaultValue));
        }
        buf.append(";\n");
        return buf.toString();
    }

    protected String sqlCreateTableAttributeWithoutComment(String columnName, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue, boolean primaryKey, boolean withTrailingComma) {
        StringBuilder buf = new StringBuilder(columnName);
        buf.append(' ');
        buf.append(this.columnTypeNullDefaultToString(columnName, sqlType, size, scale, nullable, defaultValue));
        if (primaryKey) {
            buf.append(" PRIMARY KEY");
        }
        if (withTrailingComma) {
            buf.append(',');
        }
        return buf.toString();
    }

    @Override
    public String sqlCreateColumnComment(String tableName, String columnName, String comment) {
        return "";
    }

    @Override
    public String sqlAlterColumnComment(String tableName, String columnName, String comment) {
        return this.sqlCreateColumnComment(tableName, columnName, comment);
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        throw new TentackleRuntimeException(sqlType + " is not supported for " + this);
    }

    @Override
    public String sqlCreateIndex(String tableName, String indexName, boolean unique, String filterCondition, String ... columnNames) {
        StringBuilder buf = new StringBuilder("CREATE ");
        if (unique) {
            buf.append("UNIQUE ");
        }
        buf.append("INDEX ");
        buf.append(indexName);
        buf.append(" ON ");
        buf.append(tableName);
        buf.append(" (");
        boolean needsComma = false;
        for (String columnName : columnNames) {
            if (needsComma) {
                buf.append(", ");
            }
            boolean descending = false;
            if (columnName.startsWith("-")) {
                columnName = columnName.substring(1);
                descending = true;
            }
            buf.append(columnName);
            if (descending) {
                buf.append(" DESC");
            }
            needsComma = true;
        }
        buf.append(')');
        if (filterCondition != null) {
            buf.append(" WHERE ").append(filterCondition);
        }
        buf.append(";\n");
        return buf.toString();
    }

    @Override
    public String sqlDropIndex(String schemaName, String tableNameWithoutSchema, String indexName) {
        StringBuilder buf = new StringBuilder("DROP INDEX ");
        if (this.isDropIfExistsEnabled()) {
            buf.append("IF EXISTS ");
        }
        if (schemaName != null) {
            buf.append(schemaName);
            buf.append(".");
        }
        buf.append(indexName);
        buf.append(";\n");
        return buf.toString();
    }

    @Override
    public void sqlJoinSelects(JoinType type, boolean addColumns, StringBuilder select, String joinSelect, String joinSelectIdAlias, String joinAlias, String join) {
        int ndx = select.indexOf("SELECT DISTINCT ");
        if (ndx < 0) {
            ndx = select.indexOf("SELECT ");
            if (ndx < 0) {
                throw new BackendException("not a SELECT statement: " + select);
            }
            select.insert(6, " DISTINCT");
        }
        if ((ndx = (joinSelect = this.optimizeSql(joinSelect)).indexOf(" ORDER BY ")) > 0) {
            joinSelect = joinSelect.substring(0, ndx);
        }
        boolean joinSelectNeedsParentheses = joinSelect.contains("SELECT");
        int fromNdx = select.indexOf(" FROM ");
        if (fromNdx < 0) {
            throw new BackendException("missing FROM in '" + select + "'");
        }
        int tailNdx = select.indexOf(" WHERE 1=1");
        if (tailNdx < 0) {
            throw new BackendException("missing WHERE 1=1 in '" + select + "'");
        }
        StringBuilder buf = new StringBuilder();
        buf.append(select.substring(0, fromNdx));
        if (addColumns) {
            buf.append(",").append(joinAlias).append(".*");
        }
        buf.append(select.substring(fromNdx, tailNdx)).append(' ').append((Object)type).append(' ');
        if (joinSelectNeedsParentheses) {
            buf.append('(');
        }
        if (joinSelectIdAlias != null) {
            String joinSelectUC = joinSelect.toUpperCase();
            int joinFromNdx = joinSelectUC.indexOf(" FROM ");
            if (joinFromNdx < 0) {
                throw new BackendException("missing FROM in '" + joinSelect + "'");
            }
            buf.append(joinSelect, 0, joinFromNdx).append(",").append(joinSelectIdAlias).append(joinSelect.substring(joinFromNdx));
        } else {
            buf.append(joinSelect);
        }
        if (joinSelectNeedsParentheses) {
            buf.append(')');
        }
        buf.append(this.sqlAsBeforeTableAlias()).append(joinAlias).append(" ON ").append(join).append(select.substring(tailNdx));
        select.delete(0, select.length());
        select.append((CharSequence)buf);
    }

    protected String extractWhereClause(String sql, int whereOffset) {
        int ndx = sql.lastIndexOf(" ORDER BY ");
        sql = ndx >= 0 ? sql.substring(whereOffset + " WHERE ".length(), ndx) : sql.substring(whereOffset + " WHERE ".length());
        if ((sql = sql.trim()).equals("1=1")) {
            sql = "";
        }
        return sql;
    }

    @Override
    public void assertValidName(SqlNameType nameType, String name) {
        if (name != null) {
            if (this.getReservedWords().contains(name.toUpperCase())) {
                throw new BackendException(nameType + " '" + name + "' is a reserved word for backend " + this);
            }
            if (this.isTemporaryName(name)) {
                throw new BackendException(nameType + " '" + name + "' is a temporary identifier for backend " + this);
            }
        }
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        SqlType sqlType;
        switch (jdbcType) {
            case -7: 
            case 16: {
                sqlType = SqlType.BIT;
                break;
            }
            case -6: {
                sqlType = SqlType.TINYINT;
                break;
            }
            case 5: {
                sqlType = SqlType.SMALLINT;
                break;
            }
            case 4: {
                sqlType = SqlType.INTEGER;
                break;
            }
            case -5: {
                sqlType = SqlType.BIGINT;
                break;
            }
            case 6: 
            case 7: {
                sqlType = SqlType.FLOAT;
                break;
            }
            case 8: {
                sqlType = SqlType.DOUBLE;
                break;
            }
            case 2: 
            case 3: {
                sqlType = SqlType.DECIMAL;
                break;
            }
            case -15: 
            case 1: {
                sqlType = SqlType.CHAR;
                break;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                sqlType = SqlType.VARCHAR;
                break;
            }
            case 91: {
                sqlType = SqlType.DATE;
                break;
            }
            case 92: {
                sqlType = SqlType.TIME;
                break;
            }
            case 93: {
                sqlType = SqlType.TIMESTAMP;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                sqlType = SqlType.BLOB;
                break;
            }
            case 2005: 
            case 2011: {
                sqlType = SqlType.CLOB;
                break;
            }
            default: {
                return new SqlType[0];
            }
        }
        return new SqlType[]{sqlType};
    }

    @Override
    public String toQuotedString(String str) {
        StringBuilder buf = new StringBuilder("'");
        if (str != null) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                buf.append(c);
                if (c != '\'') continue;
                buf.append(c);
            }
        }
        buf.append("'");
        return buf.toString();
    }

    @Override
    public String optimizeSql(String sql) {
        return sql.replace(" WHERE 1=1 AND ", " WHERE ").replace(" WHERE 1=1 OR ", " WHERE ").replace(" WHERE 1=1", "");
    }

    @Override
    public String buildSelectSql(String sql, boolean writeLock, int limit, int offset) {
        StringBuilder buf = new StringBuilder(sql);
        this.buildSelectSql(buf, writeLock, limit, offset);
        return buf.toString();
    }

    @Override
    public String sqlJoinSelects(JoinType type, boolean addColumns, String select, String joinSelect, String joinSelectIdAlias, String joinAlias, String join) {
        StringBuilder buf = new StringBuilder(select);
        this.sqlJoinSelects(type, addColumns, buf, joinSelect, joinSelectIdAlias, joinAlias, join);
        return buf.toString();
    }

    @Override
    public boolean isReleaseSavepointSupported() {
        return false;
    }

    @Override
    public boolean isClobSupported() {
        return true;
    }

    @Override
    public boolean isFunctionBasedIndexSupported() {
        return false;
    }

    @Override
    public boolean isFilteredIndexSupported() {
        return false;
    }

    @Override
    public void setDropIfExistsEnabled(boolean dropIfExistsEnabled) {
        this.dropIfExistsEnabled = dropIfExistsEnabled;
    }

    @Override
    public boolean isDropIfExistsEnabled() {
        return this.dropIfExistsEnabled && this.isDropIfExistsSupported();
    }

    protected boolean isDropIfExistsSupported() {
        return false;
    }

    private boolean isExceptionStateStartingWith(SQLException ex, String prefix) {
        if (ex != null) {
            String state = ex.getSQLState();
            return state != null && state.startsWith(prefix);
        }
        return false;
    }
}

