/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.tentackle.common.Service;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.sql.AbstractSql2003Backend;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.NonStandardCommons;
import org.tentackle.sql.SqlType;

@Service(value=Backend.class)
public class Oracle
extends AbstractSql2003Backend {
    public static final String SQL_NESTED_SELECT_1 = "/*+ FIRST_ROWS */ * FROM (SELECT ";
    public static final String SQL_NESTED_SELECT_2 = ") WHERE ";
    public static final String SQL_NESTED_SELECT_ROWNUM = "ROWNUM";
    public static final String SQL_NESTED_SELECT_LIMIT = "ROWNUM<=?";
    public static final String SQL_NESTED_SELECT_OFFSET = "ROWNUM>?";
    private static final String ORA_DATE_FORMAT = "YYYY-MM-DD";
    private static final String ORA_TIME_FORMAT = "HH24:MI:SS";
    private static final String ORA_TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    private static final String ORA_TO_DATE_LEAD = "TO_DATE('";
    private static final String ORA_TO_DATE_SEP = "','";
    private static final String ORA_TO_DATE_TAIL = "')";
    private static final String JAVA_DATE_FORMAT = "yyyy-MM-dd";
    private static final String JAVA_TIME_FORMAT = "HH:mm:ss";
    private static final String JAVA_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String ORACLE_EMPTY_STRING = " ";
    private static final int MAX_NAME_LENGTH = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateString(Date date) {
        DateFormat dateFormat = DATE_FORMAT;
        synchronized (dateFormat) {
            return ORA_TO_DATE_LEAD + DATE_FORMAT.format(date) + "','YYYY-MM-DD')";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String timeString(Time time) {
        DateFormat dateFormat = TIME_FORMAT;
        synchronized (dateFormat) {
            return ORA_TO_DATE_LEAD + TIME_FORMAT.format(time) + "','HH24:MI:SS')";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String timestampString(Timestamp timestamp) {
        DateFormat dateFormat = TIMESTAMP_FORMAT;
        synchronized (dateFormat) {
            return ORA_TO_DATE_LEAD + TIMESTAMP_FORMAT.format(timestamp) + "','YYYY-MM-DD HH24:MI:SS')";
        }
    }

    @Override
    public String getDriverClassName() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public Connection createConnection(String url, String username, char[] password) throws SQLException {
        Properties props = new Properties();
        props.put("user", username);
        if (password != null) {
            props.put("password", new String(password));
        }
        props.put("remarksReporting", "true");
        try {
            Class.forName(this.getDriverClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return DriverManager.getConnection(url, props);
    }

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":oracle");
    }

    @Override
    public String getName() {
        return "Oracle";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getBackendId(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery("select sys_context('userenv','sid') from dual");
            if (rs.next()) {
                String string2 = "SID-" + rs.getString(1);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException ex) {
            throw new TentackleRuntimeException("cannot determine backend id", (Throwable)ex);
        }
    }

    @Override
    public boolean isTemporaryName(String name) {
        return name != null && (name.startsWith("tmp_") || name.startsWith("TMP_"));
    }

    @Override
    public void assertValidName(String nameType, String name) {
        super.assertValidName(nameType, name);
        this.assertNameLength(nameType, name);
        if (name != null && name.startsWith("_")) {
            throw new BackendException(nameType + " '" + name + "' is illegal for backend " + this);
        }
    }

    @Override
    public String getEmptyString() {
        return ORACLE_EMPTY_STRING;
    }

    @Override
    public String valueToLiteral(SqlType sqlType, Object value) {
        if (value instanceof String && ((String)value).isEmpty()) {
            value = ORACLE_EMPTY_STRING;
        }
        if (value instanceof Boolean) {
            return Boolean.TRUE.equals(value) ? "1" : "0";
        }
        return super.valueToLiteral(sqlType, value);
    }

    @Override
    public boolean sqlRequiresExtraCommit() {
        return true;
    }

    @Override
    public void buildSelectSql(StringBuilder sqlBuilder, boolean writeLock, int limit, int offset) {
        if (limit > 0 || offset > 0) {
            sqlBuilder.insert(0, SQL_NESTED_SELECT_1);
        }
        sqlBuilder.insert(0, "SELECT ");
        if (writeLock) {
            sqlBuilder.append(" FOR UPDATE");
        }
        if (limit > 0 || offset > 0) {
            sqlBuilder.append(SQL_NESTED_SELECT_2);
            if (offset > 0) {
                sqlBuilder.append(SQL_NESTED_SELECT_OFFSET);
            }
            if (limit > 0) {
                if (offset > 0) {
                    sqlBuilder.append(" AND ");
                }
                sqlBuilder.append(SQL_NESTED_SELECT_LIMIT);
            }
        }
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        switch (sqlType) {
            case DECIMAL: {
                return 37;
            }
            case VARCHAR: {
                return 4000;
            }
        }
        return super.getMaxSize(sqlType);
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        switch (sqlType) {
            case BIT: {
                return "NUMBER(1)";
            }
            case TINYINT: {
                return "NUMBER(1)";
            }
            case SMALLINT: {
                return "NUMBER(5)";
            }
            case INTEGER: {
                return "NUMBER(10)";
            }
            case BIGINT: {
                return "NUMBER(19)";
            }
            case FLOAT: {
                return "REAL";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case DECIMAL: {
                return "NUMBER";
            }
            case CHAR: {
                return "CHAR(1)";
            }
            case VARCHAR: {
                return "VARCHAR";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "DATE";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case BLOB: {
                return "BLOB";
            }
            case CLOB: {
                return "CLOB";
            }
        }
        return super.sqlTypeToString(sqlType, size);
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        switch (jdbcType) {
            case -7: 
            case -6: {
                return new SqlType[]{SqlType.BIT, SqlType.TINYINT};
            }
            case 2: 
            case 3: {
                if (scale == 0) {
                    switch (size) {
                        case 1: {
                            return new SqlType[]{SqlType.BIT, SqlType.TINYINT};
                        }
                        case 5: {
                            return new SqlType[]{SqlType.SMALLINT};
                        }
                        case 10: {
                            return new SqlType[]{SqlType.INTEGER};
                        }
                        case 19: {
                            return new SqlType[]{SqlType.BIGINT};
                        }
                    }
                }
                return new SqlType[]{SqlType.DECIMAL};
            }
            case 91: 
            case 92: {
                return new SqlType[]{SqlType.DATE, SqlType.TIME};
            }
        }
        return super.jdbcTypeToSqlType(jdbcType, size, scale);
    }

    @Override
    public String sqlNextFromSequene(String name) {
        return "SELECT " + name + ".NEXTVAL FROM DUAL";
    }

    @Override
    public String sqlCreateTableComment(String tableName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnTable(this, tableName, comment);
    }

    @Override
    public String sqlCreateColumnComment(String tableName, String columnName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnColumn(this, tableName, columnName, comment);
    }

    @Override
    public String sqlAddColumn(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ADD (" + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false) + ");\n";
    }

    @Override
    public String sqlAlterColumnNullConstraint(String tableName, String columnName, boolean nullable) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" MODIFY (");
        buf.append(columnName);
        if (nullable) {
            buf.append(" NULL");
        } else {
            buf.append(" NOT NULL");
        }
        buf.append(");\n");
        return buf.toString();
    }

    @Override
    public String sqlAlterColumnType(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " MODIFY (" + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, true, null, false, false) + ");\n";
    }

    @Override
    public String sqlAlterColumnDefault(String tableName, String columnName, SqlType sqlType, Object defaultValue) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" ALTER COLUMN ");
        buf.append(columnName);
        buf.append(" MODIFY ");
        if (defaultValue == null) {
            buf.append("DROP DEFAULT");
        } else {
            buf.append("SET DEFAULT ");
            buf.append(this.valueToLiteral(sqlType, defaultValue));
        }
        buf.append(";\n");
        return buf.toString();
    }

    @Override
    protected String extractWhereClause(String sql, int whereOffset) {
        int ndx = (sql = super.extractWhereClause(sql, whereOffset)).lastIndexOf(SQL_NESTED_SELECT_ROWNUM, whereOffset);
        if (ndx >= 0) {
            sql = sql.substring(0, ndx);
        }
        return sql;
    }

    private void assertNameLength(String nameType, String name) {
        if (name != null && name.length() > 30) {
            throw new BackendException(nameType + " name " + name + " is too long (" + name.length() + "). " + this + " allows only 30");
        }
    }
}

