/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Objects;
import org.tentackle.common.Service;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.sql.AbstractSql92Backend;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.BackendInfo;
import org.tentackle.sql.BackendPreparedStatement;
import org.tentackle.sql.MigrationStrategy;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.metadata.ColumnMetaData;
import org.tentackle.sql.metadata.MySqlColumnMetaData;
import org.tentackle.sql.metadata.TableMetaData;

@Service(value=Backend.class)
public class MySql
extends AbstractSql92Backend {
    public static final String SQL_LIMIT = " LIMIT ";
    public static final String SQL_OFFSET = " OFFSET ";
    public static final String SQL_LIMIT_PAR = " LIMIT ?";
    public static final String SQL_OFFSET_PAR = " OFFSET ?";

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":mysql");
    }

    @Override
    public String getName() {
        return "MySQL";
    }

    @Override
    public String getDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getBackendId(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT CONNECTION_ID()");
            if (rs.next()) {
                String string2 = "ID-" + rs.getString(1);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException ex) {
            throw new TentackleRuntimeException("cannot determine backend id", (Throwable)ex);
        }
    }

    @Override
    public boolean isReleaseSavepointSupported() {
        return true;
    }

    @Override
    public boolean allowsExpressionsReferringToTablesBeingUpdated() {
        return false;
    }

    @Override
    public void buildSelectSql(StringBuilder sqlBuilder, boolean writeLock, int limit, int offset) {
        sqlBuilder.insert(0, "SELECT ");
        if (writeLock) {
            sqlBuilder.append(" FOR UPDATE");
        }
        if (offset > 0 && limit <= 0) {
            limit = 99999999;
        }
        if (limit > 0) {
            sqlBuilder.append(SQL_LIMIT_PAR);
        }
        if (offset > 0) {
            sqlBuilder.append(SQL_OFFSET_PAR);
        }
    }

    @Override
    public int setLeadingSelectParameters(BackendPreparedStatement stmt, int limit, int offset) {
        return 1;
    }

    @Override
    public int setTrailingSelectParameters(BackendPreparedStatement stmt, int index, int limit, int offset) {
        if (offset > 0 && limit <= 0) {
            limit = 99999999;
        }
        if (limit > 0) {
            stmt.setInt(index++, limit);
        }
        if (offset > 0) {
            stmt.setInt(index++, offset);
        }
        return index;
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        switch (sqlType) {
            case DECIMAL: {
                return 64;
            }
            case VARCHAR: {
                return 4096;
            }
        }
        return super.getMaxSize(sqlType);
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        switch (sqlType) {
            case BIT: {
                return "TINYINT";
            }
            case TINYINT: {
                return "TINYINT";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INTEGER: {
                return "INT";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case FLOAT: {
                return "FLOAT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case DECIMAL: {
                return size == 0 ? "DECIMAL(19)" : "DECIMAL";
            }
            case CHAR: {
                return "CHAR(1)";
            }
            case VARCHAR: {
                return "VARCHAR";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "DATETIME";
            }
            case TIMESTAMP: {
                return "DATETIME";
            }
            case BLOB: {
                return "BLOB";
            }
            case CLOB: {
                return "CLOB";
            }
        }
        return super.sqlTypeToString(sqlType, size);
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case 16: {
                return new SqlType[]{SqlType.BIT, SqlType.TINYINT};
            }
            case 92: 
            case 93: {
                return new SqlType[]{SqlType.TIMESTAMP, SqlType.TIME};
            }
        }
        return super.jdbcTypeToSqlType(jdbcType, size, scale);
    }

    @Override
    public String sqlCreateTableClosing(String tableName, String comment) {
        if (comment == null) {
            return super.sqlCreateTableClosing(tableName, null);
        }
        StringBuilder buf = new StringBuilder(super.sqlCreateTableClosing(tableName, comment));
        buf.setLength(buf.length() - 2);
        buf.append(" COMMENT=");
        buf.append(this.toQuotedString(comment));
        buf.append(";\n");
        return buf.toString();
    }

    @Override
    public DatabaseMetaData[] getMetaData(BackendInfo backendInfo) throws SQLException {
        if (backendInfo.getSchemas() != null) {
            DatabaseMetaData[] metaData = new DatabaseMetaData[backendInfo.getSchemas().length];
            for (int i = 0; i < metaData.length; ++i) {
                int ndx1 = backendInfo.getUrl().lastIndexOf(47);
                if (ndx1 == -1) {
                    throw new BackendException("missing slash in " + backendInfo.getUrl());
                }
                int ndx2 = backendInfo.getUrl().indexOf(63, ndx1);
                if (ndx2 == -1) {
                    ndx2 = backendInfo.getUrl().length();
                }
                if (ndx2 <= ndx1 + 1) {
                    throw new BackendException("missing database name in " + backendInfo.getUrl());
                }
                String schema = backendInfo.getSchemas()[i];
                String url = backendInfo.getUrl().substring(0, ++ndx1) + schema + backendInfo.getUrl().substring(ndx2);
                Connection con = this.createConnection(url, backendInfo.getUser(), backendInfo.getPassword());
                metaData[i] = con.getMetaData();
            }
            return metaData;
        }
        return super.getMetaData(backendInfo);
    }

    @Override
    public ColumnMetaData createColumnMetaData(TableMetaData tableMetaData) {
        return new MySqlColumnMetaData(tableMetaData);
    }

    @Override
    public String sqlCreateColumn(String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue, boolean primaryKey, boolean withTrailingComma) {
        if (comment == null) {
            return super.sqlCreateColumn(columnName, null, sqlType, size, scale, nullable, defaultValue, primaryKey, withTrailingComma);
        }
        StringBuilder buf = new StringBuilder(this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, primaryKey, false));
        buf.append(" COMMENT ");
        buf.append(this.toQuotedString(comment));
        if (withTrailingComma) {
            buf.append(",");
        }
        buf.append('\n');
        return buf.toString();
    }

    @Override
    public String sqlAddColumn(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" ADD COLUMN ");
        buf.append(this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false));
        if (comment != null) {
            buf.append(" COMMENT ");
            buf.append(this.toQuotedString(comment));
        }
        buf.append(";\n");
        return buf.toString();
    }

    @Override
    public String sqlRenameColumn(String tableName, String oldColumnName, String newColumnName) {
        return null;
    }

    @Override
    public String sqlRenameAndAlterColumnType(String tableName, String oldColumnName, String newColumnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" CHANGE ");
        buf.append(oldColumnName);
        buf.append(" ");
        buf.append(this.sqlCreateTableAttributeWithoutComment(newColumnName, sqlType, size, scale, nullable, defaultValue, false, false));
        if (comment != null) {
            buf.append(" COMMENT ");
            buf.append(this.toQuotedString(comment));
        }
        buf.append(";\n");
        return buf.toString();
    }

    @Override
    public String sqlAlterColumnType(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false) + ";\n";
    }

    @Override
    public String sqlAlterColumnComment(String tableName, String columnName, String comment) {
        return null;
    }

    @Override
    public String sqlDropIndex(String schemaName, String tableNameWithoutSchema, String indexName) {
        StringBuilder buf = new StringBuilder("DROP INDEX ");
        buf.append(indexName);
        buf.append(" ON ");
        if (schemaName != null) {
            buf.append(schemaName);
            buf.append(".");
        }
        buf.append(tableNameWithoutSchema);
        buf.append(";\n");
        return buf.toString();
    }

    @Override
    public MigrationStrategy[] getMigrationStrategy(ColumnMetaData column, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        boolean scaleChanged;
        ArrayList<MigrationStrategy> strategies = new ArrayList<MigrationStrategy>();
        boolean nameChanged = !column.getColumnName().equalsIgnoreCase(columnName);
        boolean commentChanged = !Objects.equals(column.getComment(), comment);
        boolean defaultChanged = !this.isDefaultEqual(column, sqlType, defaultValue);
        boolean nullChanged = column.isNullable() != nullable;
        boolean typeChanged = !column.matchesSqlType(sqlType);
        boolean sizeChanged = size > column.getSize();
        boolean bl = scaleChanged = scale > column.getScale();
        if (nameChanged || typeChanged || sizeChanged || scaleChanged || nullChanged || defaultChanged || commentChanged) {
            strategies.add(MigrationStrategy.NAME_AND_TYPE);
        }
        return strategies.toArray(new MigrationStrategy[0]);
    }

    @Override
    protected String extractWhereClause(String sql, int whereOffset) {
        int ndx = (sql = super.extractWhereClause(sql, whereOffset)).lastIndexOf(SQL_LIMIT);
        if (ndx >= 0) {
            sql = sql.substring(0, ndx);
        }
        if ((ndx = sql.lastIndexOf(SQL_OFFSET)) >= 0) {
            sql = sql.substring(0, ndx);
        }
        return sql;
    }
}

