/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.tentackle.common.ExceptionHelper;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.ServiceFinder;
import org.tentackle.common.StringHelper;
import org.tentackle.misc.IdSerialTuple;
import org.tentackle.misc.Identifiable;
import org.tentackle.session.ClassId;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionClosedException;
import org.tentackle.session.SessionKeepAliveDaemon;
import org.tentackle.session.SessionUtilitiesHolder;
import org.tentackle.session.TableName;

@Service(value=SessionUtilities.class)
public class SessionUtilities {
    private SessionKeepAliveDaemon keepAliveDaemon;
    private final Map<String, String> classTableMap;
    private final Map<String, String> tableClassMap;
    private final Map<String, Integer> classIdMap;
    private final Map<Integer, String> idClassMap;
    private final Collection<String> classNames;

    public static SessionUtilities getInstance() {
        return SessionUtilitiesHolder.INSTANCE;
    }

    public SessionUtilities() {
        ServiceFinder finder = ServiceFactory.getServiceFinder();
        this.classTableMap = new HashMap<String, String>();
        this.tableClassMap = new HashMap<String, String>();
        TreeSet<String> sortedNames = new TreeSet<String>();
        for (Map.Entry entry : finder.createNameMap(TableName.class.getName()).entrySet()) {
            String tableName = StringHelper.stripEnclosingDoubleQuotes((String)((String)entry.getKey()));
            this.classTableMap.put((String)entry.getValue(), tableName);
            this.tableClassMap.put(tableName, (String)entry.getValue());
            sortedNames.add((String)entry.getValue());
        }
        Map idMap = finder.createNameMap(ClassId.class.getName());
        this.classIdMap = new HashMap<String, Integer>();
        this.idClassMap = new HashMap<Integer, String>();
        for (Map.Entry entry : idMap.entrySet()) {
            Integer classId = Integer.valueOf((String)entry.getKey());
            sortedNames.add((String)entry.getValue());
            this.classIdMap.put((String)entry.getValue(), classId);
            this.idClassMap.put(classId, (String)entry.getValue());
        }
        this.classNames = new ArrayList<String>(sortedNames);
    }

    public String getTableName(String className) {
        return this.classTableMap.get(className);
    }

    public String getClassName(String tableName) {
        return this.tableClassMap.get(tableName);
    }

    public int getClassId(String pdoClassName) {
        Integer classId = this.classIdMap.get(pdoClassName);
        return classId == null ? 0 : classId;
    }

    public String getClassName(int classId) {
        return this.idClassMap.get(classId);
    }

    public Collection<String> getClassNames() {
        return this.classNames;
    }

    public String determineTablename(Class<?> clazz) {
        TableName tablenameAnno = clazz.getAnnotation(TableName.class);
        if (tablenameAnno != null) {
            Object tablename = tablenameAnno.value();
            if (tablenameAnno.mapSchema()) {
                tablename = ((String)tablename).replace('.', '_');
            }
            if (!((String)(tablename = tablenameAnno.prefix() + (String)tablename)).isEmpty()) {
                return tablename;
            }
        }
        return null;
    }

    public int determineClassId(Class<?> clazz) {
        ClassId anno = clazz.getAnnotation(ClassId.class);
        return anno == null ? 0 : anno.value();
    }

    public synchronized void startKeepAliveDaemonIfNotRunning() {
        if (this.keepAliveDaemon == null || !this.keepAliveDaemon.isAlive()) {
            this.keepAliveDaemon = this.createKeepAliveDaemon();
            this.keepAliveDaemon.start();
        }
    }

    public synchronized void terminateHelperThreads() {
        if (this.keepAliveDaemon != null && this.keepAliveDaemon.isAlive()) {
            this.keepAliveDaemon.terminate();
        }
        this.keepAliveDaemon = null;
    }

    public synchronized void keepAliveIntervalChanged(Session session) {
        this.startKeepAliveDaemonIfNotRunning();
        this.keepAliveDaemon.keepAliveIntervalChanged(session);
    }

    public boolean isSomeRemoved(long lastSerial, List<IdSerialTuple> expireSet, long maxSerial) {
        boolean someRemoved = false;
        for (IdSerialTuple idSer : expireSet) {
            if (lastSerial > 0L && idSer.getSerial() - lastSerial > 1L) {
                someRemoved = true;
                break;
            }
            lastSerial = idSer.getSerial();
        }
        if (maxSerial > lastSerial) {
            someRemoved = true;
        }
        return someRemoved;
    }

    public Throwable alignExceptionCause(Throwable t) {
        return t;
    }

    public void alignTemporaryExceptionStatus(PersistenceException exception) {
    }

    public StringBuilder createLazyExceptionMessage(String msg, Throwable cause, Identifiable identifiable, Session session) {
        StringBuilder buf = new StringBuilder();
        if (msg == null) {
            msg = "";
        }
        boolean multiline = this.isMultiLineExceptionMessage(msg, cause, identifiable, session);
        buf.append(msg);
        String identStr = null;
        if (identifiable != null && msg.contains(identStr = identifiable.toGenericString())) {
            identStr = null;
        }
        String sessionStr = null;
        if (session != null && msg.contains(sessionStr = session.toString())) {
            sessionStr = null;
        }
        if (identStr != null || sessionStr != null) {
            if (multiline) {
                buf.append('\n');
            } else {
                buf.append(' ');
            }
            buf.append("[_ ");
            if (identStr != null) {
                buf.append(identStr);
            }
            if (sessionStr != null) {
                if (identStr != null) {
                    buf.append(" -- ");
                }
                buf.append(sessionStr);
            }
            buf.append(" _]");
        }
        return buf;
    }

    public RuntimeException createFromRemoteException(Object relatedObject, RemoteException remoteException) {
        boolean remoteClosed;
        Throwable remoteCause = remoteException;
        if (remoteCause instanceof NoSuchObjectException) {
            remoteClosed = true;
        } else {
            remoteClosed = false;
            while (remoteCause instanceof RemoteException && ((Throwable)remoteCause).getCause() != null) {
                remoteCause = ((Throwable)remoteCause).getCause();
            }
        }
        Object pex = remoteCause instanceof RuntimeException ? (RuntimeException)remoteCause : (remoteClosed ? (relatedObject instanceof Identifiable ? new SessionClosedException((Identifiable)relatedObject, remoteCause) : (relatedObject instanceof Session ? new SessionClosedException((Session)relatedObject, remoteCause) : new SessionClosedException(relatedObject != null ? relatedObject.toString() : "", remoteCause))) : (relatedObject instanceof Identifiable ? new PersistenceException((Identifiable)relatedObject, remoteCause) : (relatedObject instanceof Session ? new PersistenceException((Session)relatedObject, remoteCause) : new PersistenceException(relatedObject != null ? relatedObject.toString() : "", remoteCause))));
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        List stack = walker.walk(s -> s.filter(sf -> ExceptionHelper.isClassValuableForStackTrace((String)sf.getClassName())).map(sf -> new StackTraceElement(sf.getDeclaringClass().getName(), sf.getMethodName(), sf.getFileName(), sf.getLineNumber())).collect(Collectors.toList()));
        if (stack.isEmpty()) {
            walker.walk(s -> s.map(sf -> new StackTraceElement(sf.getDeclaringClass().getName(), sf.getMethodName(), sf.getFileName(), sf.getLineNumber())).collect(Collectors.toList()));
        }
        StackTraceElement[] localTrace = new StackTraceElement[stack.size()];
        stack.toArray(localTrace);
        StackTraceElement[] remoteTrace = pex.getStackTrace();
        StackTraceElement[] trace = new StackTraceElement[localTrace.length + remoteTrace.length];
        System.arraycopy(remoteTrace, 0, trace, 0, remoteTrace.length);
        trace[remoteTrace.length] = new StackTraceElement(">>>>> REMOTE METHOD INVOCATION >>>>>", "", "", 0);
        System.arraycopy(localTrace, 1, trace, remoteTrace.length + 1, localTrace.length - 1);
        pex.setStackTrace(trace);
        return pex;
    }

    protected boolean isMultiLineExceptionMessage(String msg, Throwable cause, Identifiable identifiable, Session session) {
        return msg.length() > 80 || msg.contains("\n");
    }

    protected SessionKeepAliveDaemon createKeepAliveDaemon() {
        return new SessionKeepAliveDaemon(1000L);
    }
}

