/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.tentackle.session.ModificationEventDetail;
import org.tentackle.session.Session;

public class ModificationEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Session session;
    private final Map<String, ModificationEventDetail> details;
    private final long serial;
    private final String name;

    public ModificationEvent(Session session, Collection<ModificationEventDetail> details) {
        this.session = Objects.requireNonNull(session, "session");
        if (details != null && !details.isEmpty()) {
            this.details = new HashMap<String, ModificationEventDetail>();
            Iterator<ModificationEventDetail> iter = details.iterator();
            ModificationEventDetail detail = iter.next();
            this.serial = detail.getSerial();
            this.name = detail.getName();
            do {
                this.details.put(detail.getName(), detail);
            } while (iter.hasNext() && (detail = iter.next()) != null);
        } else {
            throw new IllegalArgumentException("missing details for named modification event");
        }
    }

    public ModificationEvent(Session session, long serial) {
        this.session = session;
        this.details = null;
        this.serial = serial;
        this.name = null;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isMasterEvent() {
        return this.details == null;
    }

    public boolean isSingleEvent() {
        return !this.isMasterEvent() && this.details.size() == 1;
    }

    public boolean isMultiEvent() {
        return !this.isMasterEvent() && this.details.size() > 1;
    }

    public long getSerial() {
        return this.serial;
    }

    public String getName() {
        return this.name;
    }

    public Collection<ModificationEventDetail> getDetails() {
        return this.details.values();
    }

    public ModificationEventDetail getDetail(String name) {
        return this.details.get(name);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.isMasterEvent()) {
            buf.append("MASTER:").append(this.getSerial());
        } else {
            boolean first = true;
            for (ModificationEventDetail detail : this.getDetails()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(detail);
            }
        }
        return buf.toString();
    }
}

