/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.rmi.RemoteException;
import java.util.List;
import org.tentackle.dbms.rmi.RemoteDbSessionImpl;
import org.tentackle.dbms.rmi.RemoteDelegateImpl;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.persist.ResultSetCursor;
import org.tentackle.persist.rmi.RemoteResultSetCursor;

public class RemoteResultSetCursorImpl<T extends PersistentDomainObject<T>>
extends RemoteDelegateImpl<T>
implements RemoteResultSetCursor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteResultSetCursorImpl.class);
    private ResultSetCursor<T> cursor;

    public RemoteResultSetCursorImpl(RemoteDbSessionImpl session, Class<T> clazz) throws RemoteException {
        super(session, clazz);
    }

    public void configureDelegate(Object ... args) {
        this.setCursor((ResultSetCursor)args[0]);
    }

    public void setCursor(ResultSetCursor<T> cursor) {
        this.cursor = cursor;
    }

    public ResultSetCursor<T> getCursor() {
        return this.cursor;
    }

    @Override
    public int afterLast() throws RemoteException {
        try {
            this.cursor.afterLast();
            return this.cursor.getRow();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public void beforeFirst() throws RemoteException {
        try {
            this.cursor.beforeFirst();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public void close() throws RemoteException {
        try {
            this.cursor.close();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public boolean first() throws RemoteException {
        try {
            return this.cursor.first();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public T get() throws RemoteException {
        try {
            return this.cursor.get();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public boolean isAfterLast() throws RemoteException {
        try {
            return this.cursor.isAfterLast();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public int last() throws RemoteException {
        try {
            return this.cursor.last() ? this.cursor.getRow() : -1;
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public boolean next() throws RemoteException {
        try {
            return this.cursor.next();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public boolean previous() throws RemoteException {
        try {
            return this.cursor.previous();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public int setRow(int row) throws RemoteException {
        try {
            this.cursor.setRow(row);
            return this.cursor.getRow();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public int scroll(int rows) throws RemoteException {
        try {
            this.cursor.scroll(rows);
            return this.cursor.getRow();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<T> toList() throws RemoteException {
        try {
            return this.cursor.toList();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public void setFetchSize(int rows) throws RemoteException {
        try {
            this.cursor.setFetchSize(rows);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public int getFetchSize() throws RemoteException {
        try {
            return this.cursor.getFetchSize();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws RemoteException {
        try {
            this.cursor.setFetchDirection(direction);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public int getFetchDirection() throws RemoteException {
        try {
            return this.cursor.getFetchDirection();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public ResultSetCursor.FetchList<T> fetch() throws RemoteException {
        try {
            return this.cursor.fetch();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    public RemoteException createException(Throwable t) {
        try {
            this.cursor.close();
        }
        catch (RuntimeException r) {
            LOGGER.severe("closing cursor failed", (Throwable)r);
        }
        return super.createException(t);
    }
}

