/**
 * SecurityRemoteDelegate.java
 *
 */

package org.tentackle.persist.security.rmi;

import java.rmi.RemoteException;
import java.util.List;
import org.tentackle.misc.TrackedList;
import org.tentackle.pdo.DomainContext;
import org.tentackle.persist.rmi.AbstractPersistentObjectRemoteDelegate;
import org.tentackle.security.pdo.Security;
import org.tentackle.persist.security.SecurityPersistenceImpl;


/**
 * Remote delegate for {@link SecurityPersistenceImpl}.
 */
public interface SecurityRemoteDelegate
       extends AbstractPersistentObjectRemoteDelegate<Security,SecurityPersistenceImpl> {

  void assertRemoteSecurityManagerInitialized(DomainContext contextDb) throws RemoteException;

  /**
   * Include wurblet-generated method declarations.
   *
   * @wurblet inclrmi Include --missingok .$classname/methods
   */
  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:inclrmi

  List<Security> selectByGrantee(DomainContext context, int granteeClassId, long granteeId) throws RemoteException;
  TrackedList<Security> selectByObject(DomainContext context, int objectClassId, long objectId) throws RemoteException;
  TrackedList<Security> selectByObjectClass(DomainContext context, String objectClassName) throws RemoteException;
  TrackedList<Security> selectByDomainContext(DomainContext context, int domainContextClassId, long domainContextId) throws RemoteException;
  int deleteByGrantee(int granteeClassId, long granteeId) throws RemoteException;
  int deleteByObject(int objectClassId, long objectId) throws RemoteException;
  int deleteByObjectClass(String objectClassName) throws RemoteException;
  int deleteByDomainContext(int domainContextClassId, long domainContextId) throws RemoteException;

  // </editor-fold>//GEN-END:inclrmi

}
