/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.app;

import java.util.Properties;
import org.tentackle.app.AbstractApplication;
import org.tentackle.common.StringHelper;
import org.tentackle.dbms.ConnectionManager;
import org.tentackle.dbms.ConnectionManagerProvider;
import org.tentackle.dbms.Db;
import org.tentackle.dbms.DefaultDbPool;
import org.tentackle.dbms.MpxConnectionManager;
import org.tentackle.dbms.rmi.DbServer;
import org.tentackle.dbms.rmi.RemoteDbConnectionImpl;
import org.tentackle.dbms.rmi.RemoteDbSessionImpl;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.log.LoggerOutputStream;
import org.tentackle.misc.ApplicationException;
import org.tentackle.misc.CommandLine;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.prefs.PersistedPreferencesFactory;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;
import org.tentackle.session.SessionPool;
import org.tentackle.session.SessionPoolProvider;

public abstract class ServerApplication
extends AbstractApplication
implements SessionPoolProvider,
ConnectionManagerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerApplication.class);
    private final Class<? extends RemoteDbConnectionImpl> connectionClass;
    private CommandLine cmdLine;
    private DbServer dbServer;
    private ConnectionManager connectionManager;
    private Db serverDb;
    private SessionPool sessionPool;
    private boolean stopping;

    public static ServerApplication getServerApplication() {
        return (ServerApplication)ServerApplication.getRunningApplication();
    }

    public ServerApplication(String name, Class<? extends RemoteDbConnectionImpl> connectionClass) {
        super(name);
        this.connectionClass = connectionClass;
    }

    public synchronized CommandLine getCommandLine() {
        return this.cmdLine;
    }

    public DbServer getDbServer() {
        return this.dbServer;
    }

    public boolean isServer() {
        return true;
    }

    public void start(String[] args) {
        this.cmdLine = new CommandLine(args);
        this.setProperties(this.cmdLine.getOptionsAsProperties());
        try {
            LOGGER.fine("register application server", new Object[0]);
            this.register();
            LOGGER.fine("initialize application server", new Object[0]);
            this.doInitialize();
            LOGGER.fine("login to backend", new Object[0]);
            this.doLogin();
            LOGGER.fine("configure application server", new Object[0]);
            this.doConfigureApplication();
            LOGGER.fine("finish startup", new Object[0]);
            this.doFinishStartup();
            LOGGER.fine("start services", new Object[0]);
            this.doStartDbServer();
        }
        catch (Exception e) {
            this.doStop(3, e);
        }
    }

    public void start() {
        this.start(null);
    }

    public void stop() {
        try {
            this.doStop(0);
        }
        catch (Exception e) {
            LOGGER.logStacktrace((Throwable)e);
        }
        finally {
            try {
                this.unregister();
            }
            catch (ApplicationException ex) {
                LOGGER.logStacktrace((Throwable)ex);
            }
        }
    }

    protected void configurePreferences() {
        super.configurePreferences();
        PersistedPreferencesFactory.getInstance().setSystemOnly(true);
    }

    protected DbServer createDbServer(Class<? extends RemoteDbConnectionImpl> connectionClass) throws ApplicationException {
        return new DbServer(this.getSessionInfo(), connectionClass);
    }

    public ConnectionManager createConnectionManager() {
        return new MpxConnectionManager(this.serverDb.getBackendInfo(), this.serverDb.getSessionId() + 1);
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public SessionPool createSessionPool() {
        return new DefaultDbPool(this.getConnectionManager(), this.getSessionInfo()){

            public Db getSession() {
                Db db = super.getSession();
                SessionInfo sessionInfo = this.getSessionInfo().clone();
                db.setSessionInfo(sessionInfo);
                sessionInfo.setUserId(0L);
                sessionInfo.setUserClassId(0);
                sessionInfo.setUserName(null);
                return db;
            }
        };
    }

    public SessionPool getSessionPool() {
        return this.sessionPool;
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        if (sessionInfo == null) {
            throw new NullPointerException("userinfo must not be null");
        }
        if (this.getSessionInfo() != null) {
            throw new PersistenceException("userinfo already set, cannot be changed in a running server");
        }
        sessionInfo.setImmutable(true);
        super.setSessionInfo(sessionInfo);
    }

    protected void configureSessionInfo(SessionInfo sessionInfo) {
        Properties sessionProps = null;
        try {
            sessionProps = sessionInfo.getProperties();
        }
        catch (PersistenceException e1) {
            sessionInfo.setProperties(this.getProperties());
        }
        if (sessionProps != null) {
            for (String key : this.getProperties().stringPropertyNames()) {
                sessionProps.setProperty(key, this.getProperties().getProperty(key));
            }
            sessionInfo.setProperties(sessionProps);
        }
        if (sessionInfo.getApplicationName() == null) {
            sessionInfo.setApplicationName(ReflectionHelper.getClassBaseName(((Object)((Object)this)).getClass()));
        }
        sessionInfo.applyProperties();
    }

    protected void doLogin() throws ApplicationException {
        String username = this.getProperty("user");
        char[] password = StringHelper.toCharArray((String)this.getProperty("password"));
        String sessionPropsName = this.getProperty("backend");
        SessionInfo sessionInfo = this.createSessionInfo(username, password, sessionPropsName);
        this.configureSessionInfo(sessionInfo);
        if (this.serverDb != null) {
            throw new ApplicationException("only one server application instance allowed");
        }
        this.serverDb = (Db)this.createSession(sessionInfo);
        this.serverDb.open();
        this.serverDb.makeCurrent();
        this.setSessionInfo(sessionInfo);
        DomainContext context = this.createDomainContext((Session)this.serverDb);
        if (context == null) {
            throw new ApplicationException("creating the database context failed");
        }
        this.setDomainContext(context);
    }

    protected void doFinishStartup() throws ApplicationException {
        super.doFinishStartup();
        ModificationTracker.getInstance().addShutdownRunnable(() -> this.doStop(5));
        this.connectionManager = this.createConnectionManager();
        this.sessionPool = this.createSessionPool();
        this.dbServer = this.createDbServer(this.connectionClass);
    }

    protected void doStartDbServer() throws ApplicationException {
        this.dbServer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop(int exitValue, Exception ex) {
        ServerApplication serverApplication = this;
        synchronized (serverApplication) {
            if (this.stopping) {
                return;
            }
            this.stopping = true;
        }
        LOGGER.info("terminating server {0} with exit value {1} ...", new Object[]{this.getName(), exitValue});
        if (ex != null) {
            LoggerOutputStream.logException((Exception)ex, (Logger)LOGGER);
        }
        try {
            for (RemoteDbSessionImpl session : RemoteDbSessionImpl.getOpenSessions()) {
                try {
                    session.close();
                }
                catch (RuntimeException rex) {
                    LOGGER.warning("closing pending session " + session + " failed:", (Throwable)rex);
                }
            }
            Pdo.terminateHelperThreads();
            RemoteDbSessionImpl.stopCleanupThread();
            if (this.sessionPool != null) {
                this.sessionPool.shutdown();
                this.sessionPool = null;
            }
            if (this.serverDb != null) {
                this.serverDb.close();
                this.serverDb = null;
            }
            if (this.connectionManager != null) {
                this.connectionManager.shutdown();
                this.connectionManager = null;
            }
            if (this.dbServer != null) {
                this.dbServer.stop();
                this.dbServer = null;
            }
            if (this.isRunningInContainer()) {
                this.deregisterJdbcDrivers(Thread.currentThread().getContextClassLoader());
            }
        }
        catch (Exception anyEx) {
            LOGGER.severe("server application stopped ungracefully", (Throwable)anyEx);
        }
        if (!this.isRunningInContainer()) {
            System.exit(exitValue);
        }
    }

    protected void doStop(int exitValue) {
        this.doStop(exitValue, null);
    }
}

