/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.util.List;
import org.tentackle.dbms.AbstractDbOperation;
import org.tentackle.dbms.Db;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainDelegate;
import org.tentackle.pdo.Operation;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistenceDelegate;
import org.tentackle.pdo.PersistentOperation;
import org.tentackle.persist.PersistentOperationClassVariables;
import org.tentackle.reflect.EffectiveClassProvider;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionHolder;

public abstract class AbstractPersistentOperation<T extends Operation<T>, P extends AbstractPersistentOperation<T, P>>
extends AbstractDbOperation<P>
implements PersistenceDelegate<T>,
PersistentOperation<T>,
EffectiveClassProvider<T> {
    private static final long serialVersionUID = 1L;
    private DomainContext context;
    private transient boolean contextImmutable;
    private T operation;

    public AbstractPersistentOperation(T operation, DomainContext context) {
        this.operation = operation;
        this.setDomainContext(context);
    }

    public AbstractPersistentOperation(T operation, Session session) {
        super((Db)session);
        this.operation = operation;
    }

    public AbstractPersistentOperation(T operation) {
        this.operation = operation;
    }

    public AbstractPersistentOperation() {
    }

    public DomainDelegate<T> getDomainDelegate() {
        return this.operation.getDomainDelegate();
    }

    public Class<T> getEffectiveClass() {
        return this.operation.getEffectiveClass();
    }

    public List<Class<? super T>> getEffectiveSuperClasses() {
        return this.operation.getEffectiveSuperClasses();
    }

    public P clone() {
        AbstractPersistentOperation obj = (AbstractPersistentOperation)super.clone();
        obj.setOperation(null);
        return (P)((Object)obj);
    }

    public PersistentOperation<T> clonePersistentOperation() {
        return this.clone();
    }

    public PersistentOperationClassVariables<T, P> getClassVariables() {
        throw new PersistenceException("classvariables undefined for " + ((Object)((Object)this)).getClass());
    }

    public void setSession(Session session) {
        if (this.context != null) {
            this.context.setSession(session);
        }
        super.setSession(session);
    }

    public void setDomainContext(DomainContext context) {
        if (this.context != context) {
            if (context == null) {
                throw new IllegalArgumentException("domain context cannot be cleared to null");
            }
            this.assertDomainContextMutable();
            this.context = context;
            this.setSessionHolder((SessionHolder)this.context);
            this.determineContextId();
        }
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    public PersistentOperation<T> getDelegate() {
        return this;
    }

    public PersistentOperation<T> newInstance() {
        try {
            Operation obj = (Operation)((Object)((Object)this)).getClass().newInstance();
            obj.setSession((Session)this.getSession());
            return obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new PersistenceException((Session)this.getSession(), "creating new object failed", (Throwable)e);
        }
    }

    public T operation() {
        return this.operation;
    }

    public T me() {
        return this.operation;
    }

    public T getOperation() {
        return this.operation;
    }

    public void setOperation(T po) {
        this.operation = po;
    }

    public void determineContextId() {
    }

    public long getContextId() {
        return -1L;
    }

    public DomainContext getBaseContext() {
        return this.getDomainContext();
    }

    public DomainContext createValidContext() {
        Object session = Session.getCurrentSession();
        session = session != null ? null : this.getSession();
        return Pdo.createDomainContext((Session)session);
    }

    public boolean isDomainContextImmutable() {
        return this.contextImmutable;
    }

    public void setDomainContextImmutable(boolean contextImmutable) {
        this.contextImmutable = contextImmutable;
    }

    protected void assertDomainContextMutable() {
        if (this.isDomainContextImmutable()) {
            throw new PersistenceException((Session)this.getSession(), "domain context is immutable");
        }
    }
}

