/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.ns;

import java.rmi.RemoteException;
import java.util.List;
import org.tentackle.dbms.PreparedStatementWrapper;
import org.tentackle.dbms.ResultSetWrapper;
import org.tentackle.dbms.StatementId;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.TrackedList;
import org.tentackle.ns.pdo.NumberPool;
import org.tentackle.ns.pdo.NumberRange;
import org.tentackle.ns.pdo.NumberRangePersistence;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextDependable;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoCache;
import org.tentackle.pdo.PdoListener;
import org.tentackle.pdo.PersistentObjectService;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.PersistentObjectClassVariables;
import org.tentackle.persist.ns.rmi.NumberRangeRemoteDelegate;
import org.tentackle.session.ModificationEvent;
import org.tentackle.session.ModificationListener;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Persistent;
import org.tentackle.session.Session;
import org.tentackle.session.SessionDependable;

@PersistentObjectService(value=NumberRange.class)
public class NumberRangePersistenceImpl
extends AbstractPersistentObject<NumberRange, NumberRangePersistenceImpl>
implements NumberRangePersistence {
    private static final long serialVersionUID = -1178387730540795339L;
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberRangePersistenceImpl.class);
    public static final PersistentObjectClassVariables<NumberRange, NumberRangePersistenceImpl> CLASSVARIABLES = new PersistentObjectClassVariables<NumberRange, NumberRangePersistenceImpl>(NumberRange.class, NumberRangePersistenceImpl.class, "nrange", null, null);
    public static final String CN_NUMBERPOOLID = "poolid";
    public static final String CN_BEGIN = "rbegin";
    public static final String CN_END = "rend";
    @Persistent(value="ID of the number pool")
    private long numberPoolId;
    private long numberPoolIdPersisted;
    @Persistent(value="begin of range")
    private long begin;
    private long beginPersisted;
    @Persistent(value="end of range")
    private long end;
    private long endPersisted;
    private transient NumberPool numberPool;
    private transient boolean numberPoolLoaded;
    private static final StatementId SELECT_BY_NUMBER_POOL_ID_STMT = new StatementId();
    private static PdoCache<NumberRange> cache;

    @Override
    public PersistentObjectClassVariables<NumberRange, NumberRangePersistenceImpl> getClassVariables() {
        return CLASSVARIABLES;
    }

    public NumberRangePersistenceImpl(NumberRange pdo, DomainContext context) {
        super(pdo, context);
    }

    public NumberRangePersistenceImpl(NumberRange pdo, Session session) {
        super(pdo, session);
    }

    public NumberRangePersistenceImpl(NumberRange pdo) {
        super(pdo);
    }

    public NumberRangePersistenceImpl() {
    }

    @Override
    public NumberRangeRemoteDelegate getRemoteDelegate() {
        return (NumberRangeRemoteDelegate)super.getRemoteDelegate();
    }

    @Override
    public long getRootId() {
        return this.numberPoolId;
    }

    @Override
    public int getRootClassId() {
        return 6;
    }

    public boolean isTracked() {
        return true;
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (!modified) {
            this.numberPoolIdPersisted = this.numberPoolId;
            this.beginPersisted = this.begin;
            this.endPersisted = this.end;
        }
    }

    public boolean differsPersisted() {
        return super.differsPersisted() || this.numberPoolIdPersisted != this.numberPoolId || this.beginPersisted != this.begin || this.endPersisted != this.end;
    }

    public boolean attributesModified() {
        return this.differsPersisted();
    }

    public void getFields(ResultSetWrapper rs) {
        super.getFields(rs);
        if (rs.configureSection(CLASSVARIABLES)) {
            rs.configureColumn(CN_NUMBERPOOLID);
            rs.configureColumn(CN_BEGIN);
            rs.configureColumn(CN_END);
            rs.configureColumn("id");
            rs.configureColumn("serial");
        }
        if (rs.getRow() <= 0) {
            throw new PersistenceException((Session)this.getSession(), "no valid row");
        }
        this.numberPoolId = rs.getLong();
        this.begin = rs.getLong();
        this.end = rs.getLong();
        this.setId(rs.getLong());
        this.setSerial(rs.getLong());
    }

    public int setFields(PreparedStatementWrapper st) {
        int ndx = super.setFields(st);
        st.setLong(++ndx, this.numberPoolId);
        st.setLong(++ndx, this.begin);
        st.setLong(++ndx, this.end);
        st.setLong(++ndx, this.getId());
        st.setLong(++ndx, this.getSerial());
        return ndx;
    }

    public String createInsertSql() {
        return "INSERT INTO " + this.getTableName() + " (" + CN_NUMBERPOOLID + "," + CN_BEGIN + "," + CN_END + "," + "id" + "," + "serial" + ") VALUES (" + "?," + "?," + "?," + "?," + "?" + ") ";
    }

    public String createUpdateSql() {
        return "UPDATE " + this.getTableName() + " SET " + CN_NUMBERPOOLID + "=?," + CN_BEGIN + "=?," + CN_END + "=?," + "serial" + "=" + "serial" + "+1" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    public long getNumberPoolId() {
        return this.numberPoolId;
    }

    private void setNumberPoolId(long numberPoolId) {
        this.assertMutable();
        if (this.numberPoolId != numberPoolId) {
            this.firePropertyChange("numberPoolId", this.numberPoolId, numberPoolId);
        }
        this.numberPoolId = numberPoolId;
    }

    public boolean isNumberPoolIdModified() {
        return this.numberPoolId != this.numberPoolIdPersisted;
    }

    public long getNumberPoolIdPersisted() {
        return this.numberPoolIdPersisted;
    }

    public long getBegin() {
        return this.begin;
    }

    public void setBegin(long begin) {
        this.assertMutable();
        if (this.begin != begin) {
            this.firePropertyChange("begin", this.begin, begin);
        }
        this.begin = begin;
    }

    public boolean isBeginModified() {
        return this.begin != this.beginPersisted;
    }

    public long getBeginPersisted() {
        return this.beginPersisted;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.assertMutable();
        if (this.end != end) {
            this.firePropertyChange("end", this.end, end);
        }
        this.end = end;
    }

    public boolean isEndModified() {
        return this.end != this.endPersisted;
    }

    public long getEndPersisted() {
        return this.endPersisted;
    }

    protected void revertAttributesToSnapshot(NumberRangePersistenceImpl snapshot) {
        super.revertAttributesToSnapshot(snapshot);
        this.numberPoolId = snapshot.numberPoolId;
        this.numberPoolIdPersisted = snapshot.numberPoolIdPersisted;
        this.begin = snapshot.begin;
        this.beginPersisted = snapshot.beginPersisted;
        this.end = snapshot.end;
        this.endPersisted = snapshot.endPersisted;
    }

    public NumberPool getNumberPool() {
        if (!this.numberPoolLoaded) {
            this.numberPool = this.numberPoolId == 0L ? null : (NumberPool)((NumberPool)this.on(NumberPool.class)).select(this.numberPoolId);
            this.numberPoolLoaded = true;
        }
        return this.numberPool;
    }

    public void setNumberPool(NumberPool numberPool) {
        this.assertMutable();
        this.numberPool = numberPool;
        this.setNumberPoolId(numberPool == null ? 0L : numberPool.getId());
        this.numberPoolLoaded = true;
    }

    public void setSession(Session session) {
        super.setSession(session);
        session.applyTo((SessionDependable)this.numberPool);
    }

    @Override
    public void setDomainContext(DomainContext context) {
        super.setDomainContext(context);
        context.applyTo((DomainContextDependable)this.numberPool);
    }

    public TrackedList<NumberRange> selectByNumberPoolId(long numberPoolId) {
        if (this.getSession().isRemote()) {
            try {
                TrackedList<NumberRange> list = this.getRemoteDelegate().selectByNumberPoolId(this.getDomainContext(), numberPoolId);
                this.configureRemoteObjects(this.getDomainContext(), list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)((Object)this), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_NUMBER_POOL_ID_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_NUMBERPOOLID));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setLong(ndx++, numberPoolId);
        return this.executeTrackedListQuery(st);
    }

    private static synchronized PdoCache<NumberRange> createCache() {
        if (cache == null) {
            cache = Pdo.createPdoCache(NumberRange.class, (boolean)true, (boolean)true, (boolean)false);
            ModificationTracker.getInstance().addModificationListener((ModificationListener)new PdoListener(new Class[]{NumberRange.class}){

                public void dataChanged(ModificationEvent ev) {
                    cache.expire(ev.getSerial());
                }
            });
        }
        return cache;
    }

    @Override
    public PdoCache<NumberRange> getCache() {
        return cache == null ? NumberRangePersistenceImpl.createCache() : cache;
    }

    public boolean isCountingModification(char modType) {
        return true;
    }

    @Override
    public boolean isReadAllowed() {
        return true;
    }

    @Override
    public boolean expireCache(long maxSerial) {
        this.getCache().expire(maxSerial);
        return true;
    }

    @Override
    public NumberRange selectCachedOnly(long id) {
        return (NumberRange)this.getCache().select(this.getDomainContext(), id, false);
    }

    @Override
    public NumberRange selectCached(long id) {
        return (NumberRange)this.getCache().select(this.getDomainContext(), id);
    }

    @Override
    public List<NumberRange> selectAllCached() {
        return this.getCache().selectAll(this.getDomainContext());
    }
}

