/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.lang.reflect.Method;
import java.util.List;
import org.tentackle.dbms.AbstractDbObject;
import org.tentackle.dbms.Db;
import org.tentackle.dbms.DbObjectClassVariables;
import org.tentackle.dbms.StatementId;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoCache;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.Join;
import org.tentackle.persist.security.SecurityPersistenceImpl;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.permissions.ReadPermission;
import org.tentackle.security.permissions.ViewPermission;
import org.tentackle.session.SessionUtilities;

public class PersistentObjectClassVariables<T extends PersistentDomainObject<T>, P extends AbstractPersistentObject<T, P>>
extends DbObjectClassVariables<P> {
    public static final String PROPERTY_CHECKSECURITY = "checksecurity";
    public static final String CLASSVARIABLES_NAME = "CLASSVARIABLES";
    public final Class<T> pdoClass;
    public final List<Join<T, ?>> eagerJoins;
    public final String pdoClassBaseName;
    public String tableAlias;
    public final PersistentObjectClassVariables<? super T, ? super P> superClassVariables;
    public PersistentObjectClassVariables<? super T, ? super P> topSuperClassVariables;
    public final StatementId selectByNormTextStatementId = new StatementId();
    public final StatementId selectByInvertedNormTextStatementId = new StatementId();
    public final StatementId selectByNormTextCursorStatementId = new StatementId();
    public final StatementId selectByInvertedNormTextCursorStatementId = new StatementId();
    public final StatementId selectAllStatementId = new StatementId();
    public final StatementId selectAllWithExpiredTableSerialsStatementId = new StatementId();
    public final StatementId selectAllCursorStatementId = new StatementId();
    public final StatementId updateTokenLockStatementId = new StatementId();
    public final StatementId updateTokenLockOnlyStatementId = new StatementId();
    public final StatementId selectTokenLockStatementId = new StatementId();
    public final StatementId transferTokenLockStatementId = new StatementId();
    private String effectiveTableName;
    private String effectiveTableAlias;
    private boolean securityEnabled;
    private boolean securityEnabledInitialized;
    private Method createAttributesInSnapshotMethod;
    private Method revertAttributesToSnapshotMethod;
    private Method createComponentsInSnapshotMethod;
    private Method revertComponentsToSnapshotMethod;

    public PersistentObjectClassVariables(Class<T> pdoClass, Class<P> poClass, String tableAlias, PersistentObjectClassVariables<? super T, ? super P> superClassVariables, List<Join<T, ?>> eagerJoins) {
        super(poClass, SessionUtilities.getInstance().determineClassId(pdoClass), SessionUtilities.getInstance().determineTablename(pdoClass));
        this.pdoClass = pdoClass;
        this.tableAlias = tableAlias;
        this.superClassVariables = superClassVariables;
        this.eagerJoins = eagerJoins;
        this.pdoClassBaseName = ReflectionHelper.getClassBaseName(this.pdoClass);
    }

    public PersistentObjectClassVariables(Class<T> pdoClass, Class<P> poClass, String alias) {
        this(pdoClass, poClass, alias, null, null);
    }

    public List<Join<T, ?>> getEagerJoins() {
        return this.eagerJoins;
    }

    public String getTableName() {
        if (this.effectiveTableName == null) {
            this.effectiveTableName = this.tableName;
            if (this.effectiveTableName == null) {
                PersistentObjectClassVariables<? super T, ? super P> superCV = this.superClassVariables;
                while (superCV != null) {
                    this.effectiveTableName = superCV.tableName;
                    if (this.effectiveTableName != null) break;
                    superCV = superCV.superClassVariables;
                }
            }
        }
        return this.effectiveTableName;
    }

    public String getTableAlias() {
        if (this.effectiveTableAlias == null) {
            this.effectiveTableAlias = this.tableAlias;
            if (this.effectiveTableAlias == null) {
                PersistentObjectClassVariables<? super T, ? super P> superCV = this.superClassVariables;
                while (superCV != null) {
                    this.effectiveTableAlias = superCV.tableAlias;
                    if (this.effectiveTableAlias != null) break;
                    superCV = superCV.superClassVariables;
                }
            }
        }
        return this.effectiveTableAlias;
    }

    public String getColumnName(String name) {
        StringBuilder buf = new StringBuilder();
        String alias = this.getTableAlias();
        if (alias != null) {
            buf.append(alias).append('.');
        }
        buf.append(name);
        return buf.toString();
    }

    public PersistentObjectClassVariables<? super T, ? super P> getTopSuperClassVariables() {
        if (this.topSuperClassVariables == null) {
            this.topSuperClassVariables = this;
            while (this.topSuperClassVariables.superClassVariables != null) {
                this.topSuperClassVariables = this.topSuperClassVariables.superClassVariables;
            }
        }
        return this.topSuperClassVariables;
    }

    public boolean isSecurityEnabled() {
        if (!this.securityEnabledInitialized) {
            String prop = this.getProperty(PROPERTY_CHECKSECURITY);
            this.securityEnabled = prop == null || !prop.equals("no") && !prop.equals("off") && !prop.equals("false") && !prop.equals("disabled") && !prop.equals("0");
        }
        return this.securityEnabled;
    }

    public boolean isReferenced(Db db, long id) {
        PersistentObjectClassVariables<? super T, ? super P> cv = this;
        boolean referenced = false;
        while (!referenced && cv != null) {
            referenced = cv.isReferencedImpl(db, id, cv.foreignReferences);
            cv = cv.superClassVariables;
        }
        return referenced;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.pdoClass.getName());
        buf.append("/").append(super.toString());
        if (!this.isSecurityEnabled()) {
            buf.append("/*NOSECURITY*");
        }
        return buf.toString();
    }

    public boolean isAbstract() {
        return this.classId == 0;
    }

    public boolean isReadAllowed(DomainContext context) {
        return this.clazz.isAssignableFrom(SecurityPersistenceImpl.class) || this.checkClassPermission(context, (Permission)SecurityFactory.getInstance().getReadPermission());
    }

    public boolean isReadAllowed() {
        return this.clazz.isAssignableFrom(SecurityPersistenceImpl.class) || this.checkClassPermission(null, (Permission)SecurityFactory.getInstance().getReadPermission());
    }

    public boolean isWriteAllowed(DomainContext context) {
        return this.checkClassPermission(context, (Permission)SecurityFactory.getInstance().getWritePermission());
    }

    public boolean isWriteAllowed() {
        return this.checkClassPermission(null, (Permission)SecurityFactory.getInstance().getWritePermission());
    }

    public boolean isReadAllowed(AbstractPersistentObject<?, ?> object) {
        if (this.isSecurityEnabled()) {
            ReadPermission readPermission = SecurityFactory.getInstance().getReadPermission();
            if (object.isRootEntity()) {
                return object.isPermissionAccepted((Permission)readPermission);
            }
            if (object.getRootClassId() > 0 && object.getRootId() > 0L) {
                return SecurityFactory.getInstance().getSecurityManager().evaluate(object.getBaseContext(), (Permission)readPermission, object.getRootClassId(), object.getRootId()).isAccepted();
            }
        }
        return true;
    }

    public boolean isWriteAllowed(AbstractPersistentObject<?, ?> object) {
        return !this.isSecurityEnabled() || object.isRootEntity() && object.isPermissionAccepted((Permission)SecurityFactory.getInstance().getWritePermission());
    }

    public boolean isViewAllowed(AbstractPersistentObject<?, ?> object) {
        if (this.isSecurityEnabled()) {
            ViewPermission viewPermission = SecurityFactory.getInstance().getViewPermission();
            if (object.isRootEntity()) {
                return object.isPermissionAccepted((Permission)viewPermission);
            }
            if (object.getRootClassId() > 0 && object.getRootId() > 0L) {
                return SecurityFactory.getInstance().getSecurityManager().evaluate(object.getBaseContext(), (Permission)viewPermission, object.getRootClassId(), object.getRootId()).isAccepted();
            }
        }
        return true;
    }

    public boolean isEditAllowed(AbstractPersistentObject<?, ?> object) {
        return !this.isSecurityEnabled() || object.isRootEntity() && object.isPermissionAccepted((Permission)SecurityFactory.getInstance().getEditPermission());
    }

    public Method getCreateAttributesInSnapshotMethod() throws NoSuchMethodException {
        if (this.createAttributesInSnapshotMethod == null) {
            this.createAttributesInSnapshotMethod = this.findSnapshotMethod("createAttributesInSnapshot", this.clazz);
        }
        return this.createAttributesInSnapshotMethod;
    }

    public Method getRevertAttributesToSnapshotMethod() throws NoSuchMethodException {
        if (this.revertAttributesToSnapshotMethod == null) {
            this.revertAttributesToSnapshotMethod = this.findSnapshotMethod("revertAttributesToSnapshot", this.clazz);
        }
        return this.revertAttributesToSnapshotMethod;
    }

    public Method getCreateComponentsInSnapshotMethod() throws NoSuchMethodException {
        if (this.createComponentsInSnapshotMethod == null) {
            this.createComponentsInSnapshotMethod = this.findSnapshotMethod("createComponentsInSnapshot", this.clazz);
        }
        return this.createComponentsInSnapshotMethod;
    }

    public Method getRevertComponentsToSnapshotMethod() throws NoSuchMethodException {
        if (this.revertComponentsToSnapshotMethod == null) {
            this.revertComponentsToSnapshotMethod = this.findSnapshotMethod("revertComponentsToSnapshot", this.clazz);
        }
        return this.revertComponentsToSnapshotMethod;
    }

    protected Method findSnapshotMethod(String methodName, Class<?> clazz) throws NoSuchMethodException {
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, clazz);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException ex) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    protected int determineReferencePriority(Class<? extends AbstractDbObject<?>> clazz) {
        PdoCache cache = Pdo.getPdoCache(clazz);
        if (cache != null) {
            return cache.isPreloading() ? 1 : 2;
        }
        return 3;
    }

    protected boolean checkClassPermission(DomainContext context, Permission permission) {
        try {
            return !this.isSecurityEnabled() || SecurityFactory.getInstance().getSecurityManager().evaluate(context, permission, this.classId, 0L).isAccepted();
        }
        catch (Exception ex) {
            return false;
        }
    }
}

