/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.lock;

import java.sql.Timestamp;
import org.tentackle.common.Freezable;
import org.tentackle.dbms.AbstractDbObject;
import org.tentackle.dbms.Db;
import org.tentackle.dbms.DbObjectClassVariables;
import org.tentackle.dbms.PreparedStatementWrapper;
import org.tentackle.dbms.ResultSetWrapper;
import org.tentackle.persist.TokenLock;
import org.tentackle.session.ClassId;
import org.tentackle.session.Persistent;
import org.tentackle.session.TableName;
import org.tentackle.sql.Backend;

@ClassId(value=10)
@TableName(value="tokenlock")
public class DbTokenLock
extends AbstractDbObject<DbTokenLock>
implements TokenLock {
    private static final long serialVersionUID = 1L;
    public static final DbObjectClassVariables<DbTokenLock> CLASSVARIABLES = DbObjectClassVariables.create(DbTokenLock.class);
    public static final String CN_PDOCLASSID = "pdoclassid";
    public static final String CN_LOCKEDBY = "lockedby";
    public static final String CN_LOCKEDSINCE = "lockedsince";
    public static final String CN_LOCKEXPIRY = "lockexpiry";
    private int pdoClassId;
    private long lockedBy;
    private org.tentackle.common.Timestamp lockedSince;
    private org.tentackle.common.Timestamp lockExpiry;

    public DbTokenLock(Db db) {
        super(db);
    }

    public DbTokenLock() {
    }

    public DbObjectClassVariables<DbTokenLock> getClassVariables() {
        return CLASSVARIABLES;
    }

    public void getFields(ResultSetWrapper rs) {
        super.getFields(rs);
        if (rs.configureSection(CLASSVARIABLES)) {
            rs.configureColumn(CN_PDOCLASSID);
            rs.configureColumn(CN_LOCKEDBY);
            rs.configureColumn(CN_LOCKEDSINCE);
            rs.configureColumn(CN_LOCKEXPIRY);
            rs.configureColumn("id");
            rs.configureColumn("serial");
        }
        this.pdoClassId = rs.getInt();
        this.lockedBy = rs.getLong();
        this.lockedSince = rs.getTimestamp();
        this.lockExpiry = rs.getTimestamp();
        this.setId(rs.getLong());
        this.setSerial(rs.getLong());
    }

    public int setFields(PreparedStatementWrapper st) {
        int ndx = super.setFields(st);
        st.setInt(++ndx, this.pdoClassId);
        st.setLong(++ndx, this.lockedBy);
        st.setTimestamp(++ndx, (Timestamp)this.lockedSince);
        st.setTimestamp(++ndx, (Timestamp)this.lockExpiry);
        st.setLong(++ndx, this.getId());
        st.setLong(++ndx, this.getSerial());
        return ndx;
    }

    public String createInsertSql(Backend backend) {
        return "INSERT INTO " + this.getTableName() + " (pdoclassid,lockedby,lockedsince,lockexpiry,id,serial) VALUES (" + "?,".repeat(5) + "?) ";
    }

    public String createUpdateSql(Backend backend) {
        return "UPDATE " + this.getTableName() + " SET pdoclassid=?,lockedby=?,lockedsince=?,lockexpiry=?,serial=serial+1 WHERE id=? AND serial=?";
    }

    @Override
    @Persistent(ordinal=0, comment="class ID of the PDO")
    public int getPdoClassId() {
        return this.pdoClassId;
    }

    public void setPdoClassId(int pdoClassId) {
        this.assertMutable();
        this.pdoClassId = pdoClassId;
    }

    @Override
    @Persistent(ordinal=1, comment="userId of token lock holder")
    public long getLockedBy() {
        return this.lockedBy;
    }

    public void setLockedBy(long lockedBy) {
        this.assertMutable();
        this.lockedBy = lockedBy;
    }

    @Override
    @Persistent(ordinal=2, comment="time since token lock given to user")
    public org.tentackle.common.Timestamp getLockedSince() {
        return this.lockedSince;
    }

    public void setLockedSince(org.tentackle.common.Timestamp lockedSince) {
        org.tentackle.common.Timestamp.setUTC((org.tentackle.common.Timestamp)lockedSince, (boolean)false);
        Freezable.freeze((Freezable)lockedSince);
        this.assertMutable();
        this.lockedSince = lockedSince;
    }

    @Override
    @Persistent(ordinal=3, comment="time when token lock expires")
    public org.tentackle.common.Timestamp getLockExpiry() {
        return this.lockExpiry;
    }

    public void setLockExpiry(org.tentackle.common.Timestamp lockExpiry) {
        org.tentackle.common.Timestamp.setUTC((org.tentackle.common.Timestamp)lockExpiry, (boolean)false);
        Freezable.freeze((Freezable)lockExpiry);
        this.assertMutable();
        this.lockExpiry = lockExpiry;
    }

    @Override
    public long getPdoId() {
        return this.getId();
    }

    public String toDiagnosticString() {
        return "classId " + this.pdoClassId + ", id " + this.getPdoId() + ", locked by " + this.lockedBy + ", since " + String.valueOf(this.lockedSince) + ", expiry " + String.valueOf(this.lockExpiry);
    }
}

