/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tentackle.common.ServiceFactory;
import org.tentackle.dbms.RemoteSessionAdapter;
import org.tentackle.dbms.rmi.RemoteDbSession;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextDependable;
import org.tentackle.pdo.PdoRemoteSession;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.SecurityManager;
import org.tentackle.security.SecurityResult;
import org.tentackle.session.PersistenceException;

public class PdoRemoteSessionAdapter
extends RemoteSessionAdapter
implements PdoRemoteSession {
    public PdoRemoteSessionAdapter(RemoteDbSession rs) {
        super(rs);
    }

    public <T extends DomainContextDependable> T getExtension(DomainContext context, Class<T> extIf) {
        SecurityFactory sf = SecurityFactory.getInstance();
        SecurityManager sm = sf.getSecurityManager();
        SecurityResult sr = sm.evaluate(context, (Permission)sf.getExecutePermission(), extIf);
        if (!sr.isAccepted()) {
            throw new SecurityException(sr.explain("no execute permission for " + extIf.getName()));
        }
        DomainContextDependable adapter = (DomainContextDependable)ServiceFactory.createService(extIf);
        try {
            Method m = adapter.getClass().getMethod("setDomainContext", DomainContext.class);
            m.invoke((Object)adapter, context);
            return (T)adapter;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new PersistenceException("could not create adapter for " + String.valueOf(extIf), (Throwable)ex);
        }
    }
}

