/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.Join;
import org.tentackle.session.PersistenceException;
import org.tentackle.sql.Backend;
import org.tentackle.sql.JoinType;

public class JoinedSelect<T extends PersistentDomainObject<T>> {
    private final List<Join<? super T, ?>> joins;
    private T pdo;
    private T lastPdo;
    private List<T> list;
    private Map<Long, T> idMap;

    public JoinedSelect() {
        this.joins = new ArrayList();
    }

    public JoinedSelect(List<Join<? super T, ?>> joins) {
        this.joins = joins;
    }

    public JoinedSelect<T> addJoin(Join<? super T, ?> join) {
        this.joins.add(join);
        return this;
    }

    public List<Join<? super T, ?>> getJoins() {
        return this.joins;
    }

    public void createJoinedSql(T pdo, StringBuilder selectSql) {
        AbstractPersistentObject pdoPD = (AbstractPersistentObject)pdo.getPersistenceDelegate();
        Backend backend = pdoPD.getBackend();
        for (Join<? super T, ?> join : this.joins) {
            this.createJoinedSql((PersistentDomainObject<?>)pdo, backend, join, selectSql);
        }
    }

    private void createJoinedSql(PersistentDomainObject<?> pdo, Backend backend, Join<?, ?> join, StringBuilder selectSql) {
        if (join.getType() != JoinType.INNER && join.getType() != JoinType.LEFT) {
            throw new PersistenceException(pdo, "unsupported JoinType: " + join.getType().name());
        }
        PersistentDomainObject joinedPdo = Pdo.create(join.getJoinedClass(), (DomainContext)pdo.getPersistenceDelegate().getDomainContext());
        AbstractPersistentObject joinPD = (AbstractPersistentObject)joinedPdo.getPersistenceDelegate();
        String columnName = join.getColumnName();
        Object joinedColumnName = join.getJoinedColumnName();
        String joinSelectIdAlias = null;
        String selectJoinedSql = joinPD.createSelectAllSql(backend);
        if (join.isExplicitIdAliasRequired()) {
            joinSelectIdAlias = joinPD.getTableAlias() + ".id AS " + joinPD.getTableAlias() + "_id";
            joinedColumnName = join.getJoinAlias() + "." + joinPD.getTableAlias() + "_id";
        }
        String joinSql = columnName + "=" + (String)joinedColumnName;
        if (join.getExtraSql() != null) {
            joinSql = joinSql + join.getExtraSql();
        }
        backend.sqlJoinSelects(join.getType(), true, selectSql, selectJoinedSql, joinSelectIdAlias, join.getJoinAlias(), joinSql);
        for (Join<?, ?> subJoin : join.getJoins()) {
            this.createJoinedSql(joinedPdo, backend, subJoin, selectSql);
        }
    }

    public T getLastPdo() {
        return this.lastPdo;
    }

    public T currentPdo() {
        return this.pdo;
    }

    public T nextPdo(T pdo) {
        this.lastPdo = this.pdo;
        this.pdo = pdo;
        if (this.list != null && pdo != null) {
            Long pdoId = pdo.getPersistenceDelegate().getId();
            PersistentDomainObject knownPdo = (PersistentDomainObject)this.idMap.get(pdoId);
            if (knownPdo != null) {
                this.pdo = knownPdo;
            } else {
                this.list.add(pdo);
                this.idMap.put(pdoId, pdo);
            }
        }
        return this.pdo;
    }

    public void initialize(List<T> list) {
        if (list != null && !list.isEmpty()) {
            throw new PersistenceException("list must be empty");
        }
        this.list = list;
        this.pdo = null;
        this.lastPdo = null;
        this.idMap = new HashMap<Long, T>();
        for (Join<T, ?> join : this.joins) {
            join.initialize();
        }
    }
}

