/*
 * NumberRangeRemoteDelegateImpl.java
 *
 */

package org.tentackle.persist.ns.rmi;

import org.tentackle.ns.pdo.NumberRange;
import org.tentackle.persist.ns.NumberRangePersistenceImpl;
import java.rmi.RemoteException;
import org.tentackle.pdo.DomainContext;
import org.tentackle.persist.rmi.AbstractPersistentObjectRemoteDelegateImpl;
import org.tentackle.misc.TrackedList;
import org.tentackle.dbms.rmi.RemoteDbSessionImpl;


/**
 * Remote delegate implementation for {@link NumberRangePersistenceImpl}.
 */
public class NumberRangeRemoteDelegateImpl
             extends AbstractPersistentObjectRemoteDelegateImpl<NumberRange,NumberRangePersistenceImpl>
             implements NumberRangeRemoteDelegate {


  /**
   * Creates the remote delegate for {@link NumberRangePersistenceImpl}.
   *
   * @param session the RMI session
   * @param persistenceClass the persistence implementation class
   * @param pdoClass the pdo interface class
   */
  public NumberRangeRemoteDelegateImpl(RemoteDbSessionImpl session, Class<NumberRangePersistenceImpl> persistenceClass, Class<NumberRange> pdoClass) {
    super(session, persistenceClass, pdoClass);
  }

  // @wurblet inclrmi Include --missingok .$classname/methods

  //<editor-fold defaultstate="collapsed" desc="code 'inclrmi' generated by wurblet Include">//GEN-BEGIN:inclrmi


  @Override
  public TrackedList<NumberRange> selectByNumberPoolId(DomainContext context, long numberPoolId) throws RemoteException {
    try {
      setDomainContext(context);
      return dbObject.selectByNumberPoolId(numberPoolId);
    }
    catch (RuntimeException e) {
      throw createException(e);
    }
  }

  //</editor-fold>//GEN-END:inclrmi

}
