/*
 * Tentackle - https://tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package org.tentackle.persist.ns;

import org.tentackle.dbms.PreparedStatementWrapper;
import org.tentackle.dbms.ResultSetWrapper;
import org.tentackle.dbms.StatementId;
import org.tentackle.misc.TrackedList;
import org.tentackle.ns.pdo.NumberPool;
import org.tentackle.ns.pdo.NumberRange;
import org.tentackle.ns.pdo.NumberRangePersistence;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistentObjectService;
import org.tentackle.persist.AbstractPersistentObject;
import org.tentackle.persist.PersistentObjectClassVariables;
import org.tentackle.persist.ns.rmi.NumberRangeRemoteDelegate;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.sql.Backend;

import java.io.Serial;
import java.rmi.RemoteException;



/**
 * Number Space persistence implementation.
 *
 * @author harald
 */
@PersistentObjectService(NumberRange.class)
public class NumberRangePersistenceImpl extends AbstractPersistentObject<NumberRange, NumberRangePersistenceImpl> implements NumberRangePersistence {

  @Serial
  private static final long serialVersionUID = 1L;


  // @wurblet classVariables ClassVariables

  //<editor-fold defaultstate="collapsed" desc="code 'classVariables' generated by wurblet ClassVariables">//GEN-BEGIN:classVariables

  /** Variables common to all instances of NumberRangePersistenceImpl. */
  public static final PersistentObjectClassVariables<NumberRange, NumberRangePersistenceImpl> CLASSVARIABLES =
            PersistentObjectClassVariables.create(
                    NumberRange.class,
                    NumberRangePersistenceImpl.class,
                    "nrange",
                    null,
                    null);

  @Override
  public PersistentObjectClassVariables<NumberRange, NumberRangePersistenceImpl> getClassVariables() {
    return CLASSVARIABLES;
  }

  //</editor-fold>//GEN-END:classVariables

  // @wurblet fieldnames ColumnNames

  //<editor-fold defaultstate="collapsed" desc="code 'fieldnames' generated by wurblet ColumnNames">//GEN-BEGIN:fieldnames


  /** database column name for 'numberPoolId'. */
  public static final String CN_NUMBERPOOLID = "poolid";

  /** database column name for 'begin'. */
  public static final String CN_BEGIN = "rbegin";

  /** database column name for 'end'. */
  public static final String CN_END = "rend";

  //</editor-fold>//GEN-END:fieldnames

  // @wurblet declare Declare

  //<editor-fold defaultstate="collapsed" desc="code 'declare' generated by wurblet Declare">//GEN-BEGIN:declare


  /** ID of the number pool. */
  private long numberPoolId;
  /** the last persisted value of numberPoolId. */
  private long numberPoolIdPersisted;

  /** begin of range. */
  private long begin;
  /** the last persisted value of begin. */
  private long beginPersisted;

  /** end of range. */
  private long end;
  /** the last persisted value of end. */
  private long endPersisted;

  //</editor-fold>//GEN-END:declare


  /**
   * Creates a number space.
   *
   * @param pdo the number space PDO
   * @param context the domain context
   */
  public NumberRangePersistenceImpl (NumberRange pdo, DomainContext context)    {
    super(pdo, context);
  }

  /**
   * Creates a number space with a session only.
   *
   * @param pdo the number space PDO
   * @param session the session
   */
  public NumberRangePersistenceImpl(NumberRange pdo, Session session) {
    super(pdo, session);
  }

  /**
   * Creates a number space without domain context or session.
   *
   * @param pdo the number space PDO
   */
  public NumberRangePersistenceImpl(NumberRange pdo) {
    super(pdo);
  }

  /**
   * Creates a number space without domain context or session.
   */
  public NumberRangePersistenceImpl() {
    super();
  }


  // @wurblet methods MethodsImpl

  //<editor-fold defaultstate="collapsed" desc="code 'methods' generated by wurblet MethodsImpl">//GEN-BEGIN:methods


  @Override
  public NumberRangeRemoteDelegate getRemoteDelegate() {
    return (NumberRangeRemoteDelegate) super.getRemoteDelegate();
  }

  @Override
  public long getRootId() {
    return numberPoolId;
  }

  @Override
  public int getRootClassId() {
    return 6;
  }

  @Override
  public boolean isTracked() {
    return true;
  }

  @Override
  public void setModified(boolean modified) {
    super.setModified(modified);
    if (!modified) {
      numberPoolIdPersisted = numberPoolId;
      beginPersisted = begin;
      endPersisted = end;
    }
  }

  @Override
  public boolean differsPersisted() {
    return super.differsPersisted()
           || numberPoolIdPersisted != numberPoolId
           || beginPersisted != begin
           || endPersisted != end
           ;
  }

  @Override
  public boolean attributesModified() {
    return isForcedModified() || differsPersisted();
  }

  @Override
  public void getFields(ResultSetWrapper rs) {
    super.getFields(rs);
    if (rs.configureSection(CLASSVARIABLES)) {
      rs.configureColumn(CN_NUMBERPOOLID);
      rs.configureColumn(CN_BEGIN);
      rs.configureColumn(CN_END);
      rs.configureColumn(CN_ID);
      rs.configureColumn(CN_SERIAL);
    }
    numberPoolId = rs.getLong();
    begin = rs.getLong();
    end = rs.getLong();
    setId(rs.getLong());
    setSerial(rs.getLong());
  }

  @Override
  public int setFields(PreparedStatementWrapper st) {
    int ndx = super.setFields(st);
    st.setLong(++ndx, numberPoolId);
    st.setLong(++ndx, begin);
    st.setLong(++ndx, end);
    st.setLong(++ndx, getId());
    st.setLong(++ndx, getSerial());
    return ndx;
  }

  @Override
  public String createInsertSql(Backend backend) {
    return Backend.SQL_INSERT_INTO + getTableName() + Backend.SQL_LEFT_PARENTHESIS +
           CN_NUMBERPOOLID + Backend.SQL_COMMA +
           CN_BEGIN + Backend.SQL_COMMA +
           CN_END + Backend.SQL_COMMA +
           CN_ID + Backend.SQL_COMMA +
           CN_SERIAL +
           Backend.SQL_INSERT_VALUES +
           Backend.SQL_PAR_COMMA.repeat(4) +
           Backend.SQL_PAR + Backend.SQL_RIGHT_PARENTHESIS;
  }

  @Override
  public String createUpdateSql(Backend backend) {
    return Backend.SQL_UPDATE + getTableName() + Backend.SQL_SET +
           CN_NUMBERPOOLID + Backend.SQL_EQUAL_PAR_COMMA +
           CN_BEGIN + Backend.SQL_EQUAL_PAR_COMMA +
           CN_END + Backend.SQL_EQUAL_PAR_COMMA +
           CN_SERIAL + Backend.SQL_EQUAL + CN_SERIAL + Backend.SQL_PLUS_ONE +
           Backend.SQL_WHERE + CN_ID + Backend.SQL_EQUAL_PAR +
           Backend.SQL_AND + CN_SERIAL + Backend.SQL_EQUAL_PAR;
  }

  @Override
  public long getNumberPoolId()    {
    return numberPoolId;
  }

  /**
   * Sets the attribute numberPoolId.
   *
   * @param numberPoolId ID of the number pool
   */
  private void setNumberPoolId(long numberPoolId) {
    if (this.numberPoolId != numberPoolId) {
      assertMutable();
      firePropertyChange(AN_NUMBERPOOLID, this.numberPoolId, numberPoolId);
      this.numberPoolId = numberPoolId;
    }
  }

  @Override
  public boolean isNumberPoolIdModified() {
    return numberPoolId != numberPoolIdPersisted;
  }

  @Override
  public long getNumberPoolIdPersisted() {
    return numberPoolIdPersisted;
  }

  @Override
  public long getBegin()    {
    return begin;
  }

  @Override
  public void setBegin(long begin) {
    if (this.begin != begin) {
      assertMutable();
      firePropertyChange(AN_BEGIN, this.begin, begin);
      this.begin = begin;
    }
  }

  @Override
  public boolean isBeginModified() {
    return begin != beginPersisted;
  }

  @Override
  public long getBeginPersisted() {
    return beginPersisted;
  }

  @Override
  public long getEnd()    {
    return end;
  }

  @Override
  public void setEnd(long end) {
    if (this.end != end) {
      assertMutable();
      firePropertyChange(AN_END, this.end, end);
      this.end = end;
    }
  }

  @Override
  public boolean isEndModified() {
    return end != endPersisted;
  }

  @Override
  public long getEndPersisted() {
    return endPersisted;
  }

  /**
   * Copies all attributes from a snapshot back to this object.
   *
   * @param snapshot the snapshot object
   */
  protected void revertAttributesToSnapshot(NumberRangePersistenceImpl snapshot) {
    super.revertAttributesToSnapshot(snapshot);
    numberPoolId = snapshot.numberPoolId;
    numberPoolIdPersisted = snapshot.numberPoolIdPersisted;
    begin = snapshot.begin;
    beginPersisted = snapshot.beginPersisted;
    end = snapshot.end;
    endPersisted = snapshot.endPersisted;
  }

  //</editor-fold>//GEN-END:methods

  // @wurblet relations PdoRelations

  //<editor-fold defaultstate="collapsed" desc="code 'relations' generated by wurblet PdoRelations">//GEN-BEGIN:relations


  // NumberPool numberPool via numberPoolId
  private NumberPool numberPool;
  private boolean numberPoolLoaded;

  @Override
  public NumberPool getNumberPool()  {
    if (!numberPoolLoaded) {
      numberPool = numberPoolId == 0 ? null : on(NumberPool.class).select(numberPoolId);
      numberPoolLoaded = true;
    }
    return numberPool;
  }

  /**
   * Gets numberPool without performing a select if not loaded.
   *
   * @return numberPool NumberPool
   */
  public NumberPool getNumberPoolBlunt() {
    return numberPool;
  }

  @Override
  public void setNumberPool(NumberPool numberPool)  {
    this.numberPool = numberPool;
    setNumberPoolId(numberPool == null ? 0 : numberPool.getId());
    numberPoolLoaded = true;
  }

  /**
   * Sets numberPool without setting any attributes.
   *
   * @param numberPool NumberPool
   */
  public void setNumberPoolBlunt(NumberPool numberPool) {
    this.numberPool = numberPool;
    numberPoolLoaded = true;
  }

  @Override
  public void setSession(Session session)  {
    super.setSession(session);
    session.applyTo(numberPool);
  }

  @Override
  public void setDomainContext(DomainContext context)  {
    super.setDomainContext(context);
    context.applyTo(numberPool);
  }

  // selects composite list of NumberRange numberRangeList via NumberRange#numberPoolId
  // @wurblet selectByNumberPoolId PdoSelectList --tracked numberPoolId

  //</editor-fold>//GEN-END:relations

  //<editor-fold defaultstate="collapsed" desc="code 'selectByNumberPoolId' generated by wurblet PdoSelectList/PdoRelations">//GEN-BEGIN:selectByNumberPoolId

  @Override
  public TrackedList<NumberRange> selectByNumberPoolId(long numberPoolId) {
    if (getSession().isRemote())  {
      try {
        TrackedList<NumberRange> list = getRemoteDelegate().selectByNumberPoolId(getDomainContext(), numberPoolId);
        configureRemoteObjects(getDomainContext(), list);
        return list;
      }
      catch (RemoteException e) {
        throw PersistenceException.createFromRemoteException(this, e);
      }
    }
    PreparedStatementWrapper st = getPreparedStatement(SELECT_BY_NUMBER_POOL_ID_STMT,
      b -> {
        StringBuilder sql = createSelectAllInnerSql(b);
        sql.append(Backend.SQL_AND);
        sql.append(getColumnName(CN_NUMBERPOOLID));
        sql.append(Backend.SQL_EQUAL_PAR);
        b.buildSelectSql(sql, false, 0, 0);
        return sql.toString();
      }
    );
    int ndx = 1;
    st.setLong(ndx, numberPoolId);
    return executeTrackedListQuery(st);
  }

  private static final StatementId SELECT_BY_NUMBER_POOL_ID_STMT = new StatementId();


  //</editor-fold>//GEN-END:selectByNumberPoolId

}

