/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import org.tentackle.app.AbstractApplication;
import org.tentackle.common.Service;
import org.tentackle.dbms.AbstractDbObject;
import org.tentackle.dbms.ConnectionManager;
import org.tentackle.dbms.ConnectionManagerProvider;
import org.tentackle.dbms.DbObjectClassVariables;
import org.tentackle.dbms.DbUtilities;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.persist.PersistentObjectClassVariables;
import org.tentackle.session.Session;
import org.tentackle.session.SessionPool;
import org.tentackle.session.SessionPoolProvider;

@Service(value=DbUtilities.class)
public class PersistenceUtilities
extends DbUtilities {
    public <T> T createObject(Class<T> clazz) {
        Object obj = PersistentDomainObject.class.isAssignableFrom(clazz) ? Pdo.create(clazz) : super.createObject(clazz);
        return (T)obj;
    }

    public <T> T selectObject(Session session, Class<T> clazz, long objectId, boolean loadLazyReferences) {
        Object obj = null;
        if (PersistentDomainObject.class.isAssignableFrom(clazz)) {
            PersistentDomainObject pdo = Pdo.create(clazz, (Session)session).select(objectId);
            if (pdo != null) {
                pdo.getPersistenceDelegate().setDomainContext(pdo.getPersistenceDelegate().createValidContext());
                if (loadLazyReferences) {
                    ((AbstractDbObject)pdo.getPersistenceDelegate()).loadLazyReferences();
                }
                obj = pdo;
            }
        } else {
            obj = super.selectObject(session, clazz, objectId, loadLazyReferences);
        }
        return (T)obj;
    }

    public String determineTableSerialTableName(DbObjectClassVariables<?> clazzVar) {
        try {
            String tableSerialTableName = null;
            AbstractDbObject po = AbstractDbObject.newInstance((Class)clazzVar.clazz);
            if (po.isTableSerialProvided()) {
                tableSerialTableName = po.getTableName();
                if (clazzVar instanceof PersistentObjectClassVariables) {
                    PersistentObjectClassVariables cv = (PersistentObjectClassVariables)clazzVar;
                    while (cv != null) {
                        if (cv.tableName != null) {
                            tableSerialTableName = cv.tableName;
                        }
                        cv = cv.superClassVariables;
                    }
                }
            }
            return tableSerialTableName;
        }
        catch (Exception ex) {
            throw new IllegalStateException("can't evaluate the name of the table holding the tableserial for " + clazzVar, ex);
        }
    }

    public ConnectionManager getDefaultConnectionManager() {
        ConnectionManager manager = null;
        AbstractApplication application = AbstractApplication.getRunningApplication();
        if (application instanceof ConnectionManagerProvider) {
            manager = ((ConnectionManagerProvider)application).getConnectionManager();
        }
        if (manager == null) {
            manager = super.getDefaultConnectionManager();
        }
        return manager;
    }

    public SessionPool getDefaultSessionPool() {
        AbstractApplication application = AbstractApplication.getRunningApplication();
        if (application instanceof SessionPoolProvider) {
            return ((SessionPoolProvider)AbstractApplication.getRunningApplication()).getSessionPool();
        }
        return super.getDefaultSessionPool();
    }

    public Class<?> getServicedClass(Class<?> implementingClass) {
        return PdoUtilities.getInstance().determineServicedClass(implementingClass);
    }
}

