/**
 * SecurityRemoteDelegateImpl.java
 *
 */

package org.tentackle.persist.security.rmi;

import java.rmi.RemoteException;
import java.util.List;
import org.tentackle.misc.TrackedList;
import org.tentackle.pdo.DomainContext;
import org.tentackle.persist.rmi.AbstractPersistentObjectRemoteDelegateImpl;
import org.tentackle.dbms.rmi.RemoteDbSessionImpl;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.pdo.Security;
import org.tentackle.persist.security.SecurityPersistenceImpl;


/**
 * Remote delegate implementation for {@link SecurityPersistenceImpl}.
 */
public class SecurityRemoteDelegateImpl
             extends AbstractPersistentObjectRemoteDelegateImpl<Security,SecurityPersistenceImpl>
             implements SecurityRemoteDelegate {


  /**
   * Creates the remote delegate for {@link SecurityPersistenceImpl}.
   *
   * @param session the RMI session
   * @param persistenceClass the persistence implementation class
   * @param pdoClass the pdo interface class
   * @throws java.rmi.RemoteException
   */
  public SecurityRemoteDelegateImpl(RemoteDbSessionImpl session, Class<SecurityPersistenceImpl> persistenceClass, Class<Security> pdoClass) throws RemoteException {
    super(session, persistenceClass, pdoClass);
  }

  @Override
  public void assertRemoteSecurityManagerInitialized(DomainContext contextDb) throws RemoteException {
    try {
      setDomainContext(contextDb);
      dbObject.isPermissionAccepted(SecurityFactory.getInstance().getReadPermission());   // sufficient to update the security manager's table
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  /**
   * Include wurblet-generated method declarations.
   *
   * @wurblet inclrmi Include --missingok .$classname/methods
   */
  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:inclrmi


  @Override
  public List<Security> selectByGrantee(DomainContext context, int granteeClassId, long granteeId) throws RemoteException {
    try {
      setDomainContext(context);
      return dbObject.selectByGrantee(granteeClassId, granteeId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public TrackedList<Security> selectByObject(DomainContext context, int objectClassId, long objectId) throws RemoteException {
    try {
      setDomainContext(context);
      return dbObject.selectByObject(objectClassId, objectId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public TrackedList<Security> selectByObjectClass(DomainContext context, String objectClassName) throws RemoteException {
    try {
      setDomainContext(context);
      return dbObject.selectByObjectClass(objectClassName);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public TrackedList<Security> selectByDomainContext(DomainContext context, int domainContextClassId, long domainContextId) throws RemoteException {
    try {
      setDomainContext(context);
      return dbObject.selectByDomainContext(domainContextClassId, domainContextId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public int deleteByGrantee(int granteeClassId, long granteeId) throws RemoteException {
    try {
      return dbObject.deleteByGrantee(granteeClassId, granteeId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public int deleteByObject(int objectClassId, long objectId) throws RemoteException {
    try {
      return dbObject.deleteByObject(objectClassId, objectId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public int deleteByObjectClass(String objectClassName) throws RemoteException {
    try {
      return dbObject.deleteByObjectClass(objectClassName);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public int deleteByDomainContext(int domainContextClassId, long domainContextId) throws RemoteException {
    try {
      return dbObject.deleteByDomainContext(domainContextClassId, domainContextId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  // </editor-fold>//GEN-END:inclrmi

}
