/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.rmi.RemoteException;
import org.tentackle.persist.Db;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;
import org.tentackle.persist.rmi.RemoteDelegate;

public abstract class RemoteDelegateImpl<T>
implements RemoteDelegate {
    private final RemoteDbSessionImpl serverSession;
    private final Class<T> servicedClass;

    public RemoteDelegateImpl(RemoteDbSessionImpl serverSession, Class<T> servicedClass) throws RemoteException {
        this.serverSession = serverSession;
        this.servicedClass = servicedClass;
    }

    public RemoteDbSessionImpl getServerSession() {
        return this.serverSession;
    }

    public Db getSession() {
        return this.serverSession.getSession();
    }

    public Class<T> getServicedClass() {
        return this.servicedClass;
    }

    public void initialize() {
    }

    public RemoteException createException(Throwable t) {
        RemoteException rex = new RemoteException(this.toString(), t);
        rex.setStackTrace(t.getStackTrace());
        return rex;
    }

    public String toString() {
        return "servicedClass=" + this.servicedClass.getName() + ", session=" + this.getServerSession();
    }
}

