/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.tentackle.app.AbstractApplication;
import org.tentackle.io.ServerSocketConfigurator;
import org.tentackle.io.ServerSocketConfiguratorHolder;
import org.tentackle.io.SocketConfigurator;
import org.tentackle.io.SocketConfiguratorHolder;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.log.MethodStatistics;
import org.tentackle.misc.DiagnosticUtilities;
import org.tentackle.misc.Duration;
import org.tentackle.pdo.LoginFailedException;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.pdo.SessionManagerProvider;
import org.tentackle.pdo.SessionPool;
import org.tentackle.pdo.SessionPoolProvider;
import org.tentackle.persist.ConnectionManager;
import org.tentackle.persist.Db;
import org.tentackle.persist.rmi.DbRemoteDelegate;
import org.tentackle.persist.rmi.DbRemoteDelegateImpl;
import org.tentackle.persist.rmi.Exportable;
import org.tentackle.persist.rmi.RemoteDbConnectionImpl;
import org.tentackle.persist.rmi.RemoteDbSession;
import org.tentackle.persist.rmi.RemoteDbSessionCleanupThread;
import org.tentackle.persist.rmi.RemoteDelegate;
import org.tentackle.persist.rmi.RemoteDelegateImpl;
import org.tentackle.persist.rmi.RemoteDelegateInvocationHandler;
import org.tentackle.persist.rmi.RemoteDelegateLocator;
import org.tentackle.reflect.ReflectionHelper;

public abstract class RemoteDbSessionImpl
implements RemoteDbSession,
Exportable {
    private static final long serialVersionUID = 2805986467738001409L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDbSessionImpl.class);
    private static final Set<WeakReference<RemoteDbSessionImpl>> SESSIONS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static RemoteDbSessionCleanupThread cleanupThread;
    private static final AtomicLong LAST_SESSION_NUMBER;
    private static final ConcurrentHashMap<String, DelegateClasses> DELEGATE_CLASSES_MAP;
    private final RemoteDbConnectionImpl con;
    private final SessionInfo clientInfo;
    private final SessionInfo serverInfo;
    private final long sessionNumber;
    private String clientHost;
    private int timeout;
    private int port;
    private RMIClientSocketFactory csf;
    private RMIServerSocketFactory ssf;
    private int timeoutCount;
    private Db db;
    private long closedSince;
    private final MethodStatistics methodStats;
    private final Collection<WeakReference<RemoteDelegate>> exportedDelegates;

    public static void startCleanupThread(long checkInterval) {
        cleanupThread = new RemoteDbSessionCleanupThread(checkInterval, SESSIONS, 3);
        cleanupThread.start();
    }

    public static synchronized void stopCleanupThread() {
        if (cleanupThread != null && cleanupThread.isAlive()) {
            cleanupThread.requestTermination();
            cleanupThread = null;
        }
    }

    public static Collection<RemoteDbSessionImpl> getOpenSessions() {
        ArrayList<RemoteDbSessionImpl> openSessions = new ArrayList<RemoteDbSessionImpl>();
        for (WeakReference<RemoteDbSessionImpl> ref : SESSIONS) {
            RemoteDbSessionImpl session = (RemoteDbSessionImpl)ref.get();
            if (session == null || !session.isOpen()) continue;
            openSessions.add(session);
        }
        return openSessions;
    }

    public static SessionInfo isUserLoggedIn(SessionInfo userInfo) {
        for (RemoteDbSessionImpl session : RemoteDbSessionImpl.getOpenSessions()) {
            SessionInfo sessionSessionInfo = session.getClientSessionInfo();
            if (userInfo == sessionSessionInfo || !sessionSessionInfo.equals(userInfo)) continue;
            return sessionSessionInfo;
        }
        return null;
    }

    public RemoteDbSessionImpl(RemoteDbConnectionImpl con, SessionInfo clientInfo, SessionInfo serverInfo) throws RemoteException {
        this.con = con;
        this.clientInfo = clientInfo;
        this.serverInfo = serverInfo;
        this.methodStats = new MethodStatistics();
        this.sessionNumber = LAST_SESSION_NUMBER.incrementAndGet();
        this.exportedDelegates = new ArrayList<WeakReference<RemoteDelegate>>();
        try {
            this.clientHost = UnicastRemoteObject.getClientHost();
            this.db = this.openDb();
            clientInfo.setSince(System.currentTimeMillis());
            this.verifySessionInfo(clientInfo);
            this.db.setSessionInfo(clientInfo);
        }
        catch (Exception ex) {
            if (this.db != null) {
                this.cleanup(false);
                this.closeDb(false);
            }
            if (ex instanceof LoginFailedException) {
                throw (LoginFailedException)ex;
            }
            throw new RemoteException("could not setup remote session", ex);
        }
        SESSIONS.add(new WeakReference<RemoteDbSessionImpl>(this));
        this.port = con.getPort(this.db, clientInfo, serverInfo);
        this.csf = con.getClientSocketFactory(this.db, clientInfo, serverInfo);
        this.ssf = con.getServerSocketFactory(this.db, clientInfo, serverInfo);
        this.timeout = con.getSessionTimeout(this.db, clientInfo, serverInfo);
    }

    @Override
    public void exportMe() throws RemoteException {
        this.port = this.con.exportRemoteObject(this, this.port, this.csf, this.ssf);
        LOGGER.info("begin {0}", new Object[]{this});
    }

    @Override
    public void unexportMe() throws RemoteException {
        this.con.unexportRemoteObject(this);
    }

    public void exportRemoteDelegate(RemoteDelegate delegate) throws RemoteException {
        this.con.exportRemoteObject(delegate, this.port, this.csf, this.ssf);
        this.exportedDelegates.add(new WeakReference<RemoteDelegate>(delegate));
    }

    public void unexportRemoteDelegate(RemoteDelegate delegate) throws RemoteException {
        this.con.unexportRemoteObject(delegate);
        Iterator<WeakReference<RemoteDelegate>> iter = this.exportedDelegates.iterator();
        while (iter.hasNext()) {
            WeakReference<RemoteDelegate> ref = iter.next();
            RemoteDelegate dg = (RemoteDelegate)ref.get();
            if (dg == null) {
                iter.remove();
                continue;
            }
            if (dg != delegate) continue;
            iter.remove();
            break;
        }
    }

    public abstract void verifySessionInfo(SessionInfo var1) throws LoginFailedException;

    public long getSessionNumber() {
        return this.sessionNumber;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Db getSession() {
        return this.db;
    }

    public RemoteDbConnectionImpl getConnection() {
        return this.con;
    }

    @Override
    public SessionInfo getClientSessionInfo() {
        return this.clientInfo;
    }

    public SessionInfo getServerSessionInfo() {
        return this.serverInfo;
    }

    public long getClosedSince() {
        return this.closedSince;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return this.csf;
    }

    public void setClientSocketFactory(RMIClientSocketFactory csf) {
        this.csf = csf;
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public void setServerSocketFactory(RMIServerSocketFactory ssf) {
        this.ssf = ssf;
    }

    public void countMethodInvocation(Method method, Class<?> servicedClass, Duration duration) {
        this.methodStats.countMethodInvocation(method, servicedClass, duration);
    }

    protected Db openDb() throws LoginFailedException {
        SessionPool dbPool = null;
        ConnectionManager conMgr = null;
        if (AbstractApplication.getRunningApplication() instanceof SessionPoolProvider) {
            dbPool = ((SessionPoolProvider)AbstractApplication.getRunningApplication()).getSessionPool();
        } else if (AbstractApplication.getRunningApplication() instanceof SessionManagerProvider) {
            conMgr = (ConnectionManager)((SessionManagerProvider)AbstractApplication.getRunningApplication()).getSessionManager();
        } else {
            throw new PersistenceException("no running application with Db persistence at all");
        }
        if (dbPool != null) {
            try {
                Db pooledDb = (Db)dbPool.getSession();
                LOGGER.info("using {0}", new Object[]{pooledDb});
                return pooledDb;
            }
            catch (Exception ex) {
                throw new LoginFailedException("open Db failed", (Throwable)ex);
            }
        }
        Db newDb = new Db(conMgr, this.serverInfo);
        newDb.open();
        return newDb;
    }

    protected void cleanup(boolean crashed) {
        if (crashed) {
            LOGGER.warning("cleaning up crashed {0}{1}", new Object[]{this, DiagnosticUtilities.getInstance().createStackDump()});
        }
        if (this.db != null) {
            this.db.setCrashed(crashed);
            this.db.rollbackImmediately();
        }
        this.doLogStatistics(Logger.Level.INFO, true);
    }

    protected void doLogStatistics(Logger.Level level, boolean clear) {
        this.methodStats.logStatistics(level, "    >RMI-Stats: ", clear);
    }

    protected void closeDb(boolean cleanup) {
        if (this.db != null) {
            if (this.db.isPooled()) {
                this.db.rollbackImmediately();
                if (cleanup) {
                    this.db.close();
                    LOGGER.warning("pooled {0} closed due to session cleanup", new Object[]{this.db});
                } else {
                    LOGGER.info("returning {0} to pool", new Object[]{this.db});
                }
                this.db.setSessionInfo(this.serverInfo);
                this.db.getPool().putSession((Session)this.db);
            } else {
                this.db.close();
            }
            this.db = null;
            this.closedSince = System.currentTimeMillis();
        }
    }

    protected void forceCleanup() {
        this.closedSince = System.currentTimeMillis();
        Db zombieDb = this.db;
        if (zombieDb != null) {
            this.db = null;
            try {
                zombieDb.close();
                if (zombieDb.isPooled()) {
                    zombieDb.getPool().putSession((Session)zombieDb);
                }
            }
            catch (Exception ex) {
                LOGGER.warning("forced cleanup may be incomplete", (Throwable)ex);
            }
        }
    }

    public String getClientHostString() {
        return this.clientHost;
    }

    public String getOptions() {
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(ReflectionHelper.getClassBaseName(this.getClass())).append('#').append(this.sessionNumber).append(": csf=");
        if (this.csf == null) {
            buf.append("<system>");
        } else {
            SocketConfigurator csc;
            buf.append(ReflectionHelper.getClassBaseName(this.csf.getClass()));
            if (this.csf instanceof SocketConfiguratorHolder && (csc = ((SocketConfiguratorHolder)this.csf).getSocketConfigurator()) != null && csc.isValid()) {
                buf.append('[').append(csc).append(']');
            }
        }
        buf.append(", ssf=");
        if (this.ssf == null) {
            buf.append("<system>");
        } else {
            ServerSocketConfigurator ssc;
            buf.append(ReflectionHelper.getClassBaseName(this.ssf.getClass()));
            if (this.ssf instanceof ServerSocketConfiguratorHolder && (ssc = ((ServerSocketConfiguratorHolder)this.ssf).getSocketConfigurator()) != null && ssc.isValid()) {
                buf.append('[').append(ssc).append(']');
            }
        }
        buf.append(", port=");
        if (this.port == 0) {
            buf.append("<auto>");
        } else {
            buf.append(this.port);
        }
        buf.append(", timeout=").append(this.timeout).append(", user=").append(this.clientInfo).append(", host=").append(this.clientHost);
        return buf.toString();
    }

    public boolean isOpen() {
        return this.db != null;
    }

    public boolean isGrouped() {
        return this.db.getSessionGroupId() != 0;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.isOpen()) {
                LOGGER.warning("closing unreferenced open session: " + this, new Object[0]);
            }
            this.close();
        }
        catch (Exception ex) {
            try {
                LOGGER.severe("closing unreferenced session '" + this + "' failed in finalizer", (Throwable)ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String getServerName() throws RemoteException {
        try {
            return AbstractApplication.getRunningApplication().getName();
        }
        catch (Exception ex) {
            throw new RemoteException("getting application name failed", ex);
        }
    }

    @Override
    public void close() throws RemoteException {
        try {
            if (this.db != null) {
                LOGGER.info("end {0}", new Object[]{this});
                for (WeakReference<RemoteDelegate> ref : this.exportedDelegates) {
                    RemoteDelegate delegate = (RemoteDelegate)ref.get();
                    if (delegate == null) continue;
                    this.con.unexportRemoteObject(delegate);
                }
                this.exportedDelegates.clear();
                this.unexportMe();
                this.cleanup(false);
                this.closeDb(false);
            }
        }
        catch (Exception ex) {
            throw new RemoteException("closing db failed", ex);
        }
    }

    @Override
    public void log(Logger.Level level, String message) throws RemoteException {
        try {
            LOGGER.log(level, message, null);
        }
        catch (Exception ex) {
            throw new RemoteException("log() failed", ex);
        }
    }

    @Override
    public void logStatistics(Logger.Level level, boolean clear) throws RemoteException {
        try {
            this.doLogStatistics(level, clear);
        }
        catch (Exception ex) {
            throw new RemoteException("logStatistics failed", ex);
        }
    }

    @Override
    public <T extends RemoteDelegate> T getRemoteDelegate(String classname) throws RemoteException {
        try {
            DelegateClasses delegateClasses = DELEGATE_CLASSES_MAP.get(classname);
            if (delegateClasses == null) {
                ClassNotFoundException nfe = null;
                Class<?> clazz = Class.forName(classname);
                Class servicedClass = null;
                for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
                    Class nextServicedClass;
                    if (servicedClass == null && (nextServicedClass = PdoUtilities.getInstance().determineServicedClass(currentClazz)) != null) {
                        servicedClass = nextServicedClass;
                    }
                    try {
                        delegateClasses = new DelegateClasses(servicedClass, clazz, RemoteDelegateLocator.getInstance().findRemoteDelegate(currentClazz));
                        LOGGER.info("created remote delegate class mapping {0}", new Object[]{delegateClasses});
                        DELEGATE_CLASSES_MAP.put(classname, delegateClasses);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        if (currentClazz == Object.class) {
                            throw nfe;
                        }
                        if (nfe != null) continue;
                        nfe = e;
                        continue;
                    }
                }
                if (delegateClasses == null) {
                    throw new RemoteException("no delegate class found for " + clazz, nfe);
                }
            }
            T delegate = this.createRemoteDelegate(delegateClasses.delegateClass, delegateClasses.delegateImplClass, delegateClasses.clazz, delegateClasses.effectiveClass, new Object[0]);
            this.exportRemoteDelegate((RemoteDelegate)delegate);
            LOGGER.fine("Delegate created for session={0}, class={1}, port={2}, csf={3}, ssf={4}", new Object[]{this, delegateClasses.clazz, this.port, this.csf == null ? "<default>" : this.csf.getClass().getName(), this.ssf == null ? "<default>" : this.ssf.getClass().getName()});
            return delegate;
        }
        catch (RemoteException remex) {
            throw remex;
        }
        catch (Exception ex) {
            throw new RemoteException("coudn't create delegate for " + classname, ex);
        }
    }

    @Override
    public DbRemoteDelegate getDbRemoteDelegate() throws RemoteException {
        try {
            DbRemoteDelegate delegate = this.createRemoteDelegate(DbRemoteDelegate.class, DbRemoteDelegateImpl.class, Db.class, null, new Object[0]);
            this.exportRemoteDelegate(delegate);
            return delegate;
        }
        catch (Exception ex) {
            throw new RemoteException("coudn't create delegate for " + this.db, ex);
        }
    }

    public String createRemoteDelegateClassName(String className) {
        int ndx = className.lastIndexOf(46);
        String pkgName = className.substring(0, ndx);
        String clsName = className.substring(ndx + 1);
        return pkgName + ".rmi." + clsName + "RemoteDelegate";
    }

    public String createRemoteDelegateImplClassName(String className) {
        return this.createRemoteDelegateClassName(className) + "Impl";
    }

    public <T extends RemoteDelegate, I extends RemoteDelegateImpl<?>> T createRemoteDelegateInstance(Class<T> delegateClass, Class<I> delegateImplClass, Class<?> clazz, Class<?> effectiveClass, Object ... configArgs) throws InstantiationException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<I> constructor = effectiveClass == null ? delegateImplClass.getConstructor(RemoteDbSessionImpl.class, Class.class) : delegateImplClass.getConstructor(RemoteDbSessionImpl.class, Class.class, Class.class);
        RemoteDelegateImpl delegate = effectiveClass == null ? (RemoteDelegateImpl)constructor.newInstance(this, clazz) : (RemoteDelegateImpl)constructor.newInstance(this, effectiveClass, clazz);
        delegate.initialize();
        if (configArgs != null && configArgs.length > 0) {
            Method configureMethod = delegateImplClass.getMethod("configureDelegate", Object[].class);
            configureMethod.invoke((Object)delegate, new Object[]{configArgs});
        }
        return (T)delegate;
    }

    public <T extends RemoteDelegate, I extends RemoteDelegateImpl<?>> T createRemoteDelegate(Class<T> delegateClass, Class<I> delegateImplClass, Class<?> clazz, Class<?> effectiveClass, Object ... configArgs) throws InstantiationException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (T)((RemoteDelegate)Proxy.newProxyInstance(delegateImplClass.getClassLoader(), new Class[]{delegateClass, Remote.class}, (InvocationHandler)new RemoteDelegateInvocationHandler((RemoteDelegateImpl)this.createRemoteDelegateInstance(delegateClass, delegateImplClass, clazz, effectiveClass, configArgs))));
    }

    public boolean hasTimedOut() {
        this.timeoutCount = this.db.isAlive() ? 0 : ++this.timeoutCount;
        return this.timeoutCount > this.timeout;
    }

    public void polled() {
        this.db.setAlive(false);
    }

    static {
        LAST_SESSION_NUMBER = new AtomicLong();
        DELEGATE_CLASSES_MAP = new ConcurrentHashMap();
    }

    private static class DelegateClasses {
        private final Class<?> clazz;
        private final Class<?> effectiveClass;
        private final Class<RemoteDelegate> delegateClass;
        private final Class<RemoteDelegateImpl<?>> delegateImplClass;

        private DelegateClasses(Class<?> effectiveClass, Class<?> clazz, Class<RemoteDelegate> delegateClass, Class<RemoteDelegateImpl<?>> delegateImplClass) {
            this.effectiveClass = effectiveClass == clazz ? null : effectiveClass;
            this.clazz = clazz;
            this.delegateClass = delegateClass;
            this.delegateImplClass = delegateImplClass;
        }

        private DelegateClasses(Class<?> effectiveClass, Class<?> clazz, RemoteDelegateLocator.Result delegates) {
            this(clazz, effectiveClass == null ? delegates.getEffectiveClass() : effectiveClass, delegates.getRemoteDelegate(), delegates.getRemoteDelegateImpl());
        }

        public String toString() {
            return this.clazz.getName() + " -> " + this.delegateClass.getName() + " / " + this.delegateImplClass.getName();
        }
    }
}

