/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tentackle.daemon.Scavenger;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.persist.Db;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;

public class RemoteDbSessionCleanupThread
extends Thread
implements Scavenger {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDbSessionCleanupThread.class);
    private final long checkInterval;
    private final int cleanupRetryMax;
    private final Set<WeakReference<RemoteDbSessionImpl>> sessions;
    private final Map<RemoteDbSessionImpl, Integer> zombieSessions;
    private volatile boolean terminationRequested;

    public RemoteDbSessionCleanupThread(long checkInterval, Set<WeakReference<RemoteDbSessionImpl>> sessions, int cleanupRetryMax) {
        super("Session Cleanup");
        this.checkInterval = checkInterval;
        this.sessions = sessions;
        this.cleanupRetryMax = cleanupRetryMax;
        this.zombieSessions = new HashMap<RemoteDbSessionImpl, Integer>();
        this.setDaemon(true);
    }

    public void requestTermination() {
        this.terminationRequested = true;
        this.interrupt();
    }

    public boolean isScavenging() {
        return true;
    }

    @Override
    public void run() {
        LOGGER.info(this.getName() + " started with interval=" + this.checkInterval + ", max.retries=" + this.cleanupRetryMax, new Object[0]);
        while (!this.terminationRequested) {
            try {
                RemoteDbSessionCleanupThread.sleep(this.checkInterval);
                this.cleanupZombieSessions();
                this.verifySessions();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception ex) {
                LOGGER.severe("cleanup sessions failed", (Throwable)ex);
            }
        }
        LOGGER.info(this.getName() + " terminated", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void verifySessions() {
        RemoteDbSessionImpl session;
        HashSet<Integer> aliveGroups = new HashSet<Integer>();
        HashSet<Integer> deadTxGroups = new HashSet<Integer>();
        Iterator<WeakReference<RemoteDbSessionImpl>> iter = this.sessions.iterator();
        while (iter.hasNext()) {
            session = (RemoteDbSessionImpl)iter.next().get();
            if (session == null) {
                iter.remove();
                continue;
            }
            if (!session.isOpen()) continue;
            Db db = session.getSession();
            if (db == null || !db.isOpen()) {
                if (db != null) {
                    LOGGER.warning("session Db " + db + " already closed in " + session + " -> cleanup forced and removed from session list", new Object[0]);
                    session.forceCleanup();
                }
                iter.remove();
                continue;
            }
            int group = db.getSessionGroupId();
            boolean timedOut = session.hasTimedOut();
            if (timedOut) {
                Class<RemoteDbSessionImpl> clazz = RemoteDbSessionImpl.class;
                // MONITORENTER : org.tentackle.persist.rmi.RemoteDbSessionImpl.class
                boolean inTransaction = db.isTxRunning();
                timedOut = session.hasTimedOut();
                // MONITOREXIT : clazz
                if (timedOut) {
                    if (group == 0) {
                        LOGGER.info("disconnect dead " + session + ", ungrouped", new Object[0]);
                        this.cleanupSession(session);
                        iter.remove();
                        continue;
                    }
                    if (inTransaction) {
                        deadTxGroups.add(group);
                    }
                }
            }
            if (!timedOut && group > 0) {
                aliveGroups.add(group);
            }
            session.polled();
        }
        iter = this.sessions.iterator();
        while (iter.hasNext()) {
            boolean notAlive;
            int group;
            session = (RemoteDbSessionImpl)iter.next().get();
            if (session == null) {
                iter.remove();
                continue;
            }
            if (!session.isOpen() || (group = session.getSession().getSessionGroupId()) <= 0) continue;
            boolean deadInTransaction = deadTxGroups.contains(group);
            boolean bl = notAlive = !aliveGroups.contains(group);
            if (!deadInTransaction && !notAlive) continue;
            if (deadInTransaction) {
                LOGGER.info("disconnect dead {0}, group={1}, due to hanging transaction on {2}", new Object[]{session, group, session.getSession()});
            } else {
                LOGGER.info("disconnect dead {0}, group={1}", new Object[]{session, group});
            }
            this.cleanupSession(session);
            iter.remove();
        }
    }

    protected void cleanupSession(RemoteDbSessionImpl session) {
        try {
            session.cleanup(true);
            session.closeDb(true);
        }
        catch (Exception ex) {
            LOGGER.severe("session cleanup failed for " + session + "\n    -> moved to zombie sessions!", (Throwable)ex);
            this.zombieSessions.put(session, 1);
        }
    }

    protected void cleanupZombieSessions() {
        Iterator<Map.Entry<RemoteDbSessionImpl, Integer>> iter = this.zombieSessions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<RemoteDbSessionImpl, Integer> entry = iter.next();
            RemoteDbSessionImpl session = entry.getKey();
            if (this.cleanupZombieSession(session)) {
                iter.remove();
                continue;
            }
            int cleanupCount = entry.getValue();
            if (cleanupCount >= this.cleanupRetryMax) {
                LOGGER.severe("zombie session refused to cleanup " + cleanupCount + " times -> to GC: " + session, new Object[0]);
                session.forceCleanup();
                iter.remove();
                continue;
            }
            entry.setValue(cleanupCount + 1);
        }
    }

    protected boolean cleanupZombieSession(RemoteDbSessionImpl session) {
        try {
            LOGGER.info("cleaning up zombie " + session, new Object[0]);
            session.cleanup(true);
            session.closeDb(true);
            return true;
        }
        catch (Exception ex) {
            LOGGER.severe("zombie session cleanup failed for " + session, (Throwable)ex);
            return false;
        }
    }
}

