/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import org.tentackle.common.Service;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.persist.rmi.RemoteDelegate;
import org.tentackle.persist.rmi.RemoteDelegateImpl;
import org.tentackle.persist.rmi.RemoteDelegateLocator;

@Service(value=RemoteDelegateLocator.class)
public class DefaultRemoteDelegateLocator
implements RemoteDelegateLocator {
    @Override
    public RemoteDelegateLocator.Result findRemoteDelegate(Class<?> clazz) throws ClassNotFoundException {
        String className = clazz.getName();
        int ndx = className.lastIndexOf(46);
        String pkgName = className.substring(0, ndx);
        Class<?> effectiveClazz = this.findEffectiveClass(clazz);
        String effectiveClassName = effectiveClazz.getName();
        ndx = effectiveClassName.lastIndexOf(46);
        String clsName = effectiveClassName.substring(ndx + 1);
        String delegateName = pkgName + ".rmi." + clsName + "RemoteDelegate";
        Class<?> delegateClass = Class.forName(delegateName);
        if (!delegateClass.isInterface()) {
            throw new PersistenceException(delegateClass + " is not an interface");
        }
        if (!RemoteDelegate.class.isAssignableFrom(delegateClass)) {
            throw new PersistenceException(delegateClass + " does not extend " + RemoteDelegate.class);
        }
        Class<?> delegateImplClass = Class.forName(delegateName + "Impl");
        if (delegateImplClass.isInterface()) {
            throw new PersistenceException(delegateImplClass + " is an interface");
        }
        if (!RemoteDelegateImpl.class.isAssignableFrom(delegateImplClass)) {
            throw new PersistenceException(delegateImplClass + " does not extend " + RemoteDelegateImpl.class);
        }
        return new DefaultResult(effectiveClazz, delegateClass, delegateImplClass);
    }

    protected Class<?> findEffectiveClass(Class<?> clazz) {
        Class<?> servicedClass = PdoUtilities.getInstance().determineServicedClass(clazz);
        return servicedClass != null ? servicedClass : clazz;
    }

    private static class DefaultResult
    implements RemoteDelegateLocator.Result {
        private final Class<?> effectiveClass;
        private final Class<RemoteDelegate> remoteDelegate;
        private final Class<RemoteDelegateImpl<?>> remoteDelegateImpl;

        private DefaultResult(Class<?> effectiveClass, Class<RemoteDelegate> remoteDelegate, Class<RemoteDelegateImpl<?>> remoteDelegateImpl) {
            this.effectiveClass = effectiveClass;
            this.remoteDelegate = remoteDelegate;
            this.remoteDelegateImpl = remoteDelegateImpl;
        }

        @Override
        public Class<?> getEffectiveClass() {
            return this.effectiveClass;
        }

        @Override
        public Class<RemoteDelegate> getRemoteDelegate() {
            return this.remoteDelegate;
        }

        @Override
        public Class<RemoteDelegateImpl<?>> getRemoteDelegateImpl() {
            return this.remoteDelegateImpl;
        }
    }
}

