/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;
import java.util.StringTokenizer;
import org.tentackle.io.SocketFactoryFactory;
import org.tentackle.io.SocketFactoryType;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.ApplicationException;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.persist.rmi.RemoteDbConnectionImpl;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;
import org.tentackle.reflect.ReflectionHelper;

public class DbServer {
    public static final String CONNECTION_CLASS = "connectionclass";
    public static final String RMI_SERVICE = "service";
    public static final String CREATE_REGISTRY = "createregistry";
    public static final String TIMEOUT = "timeout";
    public static final String TIMEOUT_INTERVAL = "timeoutinterval";
    public static final String PORTS = "ports";
    public static final String PORT = "port";
    public static final String CIPHER_SUITES = "ciphersuites";
    public static final String PROTOCOLS = "protocols";
    public static final String CLIENT_AUTH = "clientauth";
    private static final Logger LOGGER = LoggerFactory.getLogger(DbServer.class);
    private final SessionInfo sessionInfo;
    private String service;
    private boolean createRegistry;
    private Class<? extends RemoteDbConnectionImpl> connectionClass;
    private RemoteDbConnectionImpl connectionObject;
    private int sessionTimeout;
    private long sessionTimeoutCheckInterval;
    private int port;
    private Registry registry;
    private RMIClientSocketFactory loginCsf;
    private RMIServerSocketFactory loginSsf;
    private RMIClientSocketFactory csf;
    private RMIServerSocketFactory ssf;
    private int plainPort;
    private int compressedPort;
    private int sslPort;
    private int compressedSslPort;

    public DbServer(SessionInfo sessionInfo, Class<? extends RemoteDbConnectionImpl> connectionClass) throws ApplicationException {
        int i;
        StringTokenizer stok;
        SocketFactoryType factoryType;
        this.sessionInfo = sessionInfo;
        this.connectionClass = connectionClass == null ? RemoteDbConnectionImpl.class : connectionClass;
        Properties props = sessionInfo.getProperties();
        String val = props.getProperty(CONNECTION_CLASS);
        if (val != null) {
            try {
                this.connectionClass = Class.forName(val);
            }
            catch (ClassNotFoundException ex) {
                throw new ApplicationException("connection class '" + val + "' not found");
            }
        }
        this.service = (val = props.getProperty(RMI_SERVICE)) != null ? val : "rmi://localhost:1099/" + ReflectionHelper.getClassBaseName(this.getClass());
        try {
            URI uri = new URI(this.service);
            int servicePort = uri.getPort();
            if (servicePort != 1099) {
                this.plainPort = servicePort;
                this.compressedPort = servicePort + 1;
                this.sslPort = servicePort + 2;
                this.compressedSslPort = servicePort + 3;
            }
        }
        catch (URISyntaxException ex) {
            throw new ApplicationException("malformed service url", (Throwable)ex);
        }
        val = props.getProperty(CREATE_REGISTRY);
        if (val != null) {
            this.createRegistry = true;
            if (!val.isEmpty()) {
                factoryType = SocketFactoryType.parse((String)val);
                this.loginCsf = SocketFactoryFactory.getInstance().createClientSocketFactory(null, factoryType);
                this.loginSsf = SocketFactoryFactory.getInstance().createServerSocketFactory(null, factoryType);
            }
        }
        if ((val = props.getProperty(TIMEOUT)) != null) {
            this.sessionTimeout = Integer.parseInt(val);
        }
        this.sessionTimeoutCheckInterval = (val = props.getProperty(TIMEOUT_INTERVAL)) != null ? Long.parseLong(val) : 1000L;
        val = props.getProperty(PORTS);
        if (val != null) {
            stok = new StringTokenizer(val, " \t,;");
            int pos = 0;
            while (stok.hasMoreTokens()) {
                int p = Integer.valueOf(stok.nextToken());
                switch (pos) {
                    case 0: {
                        this.plainPort = p;
                        break;
                    }
                    case 1: {
                        this.compressedPort = p;
                        break;
                    }
                    case 2: {
                        this.sslPort = p;
                        break;
                    }
                    case 3: {
                        this.compressedSslPort = p;
                        break;
                    }
                    default: {
                        throw new ApplicationException("malformed 'ports = " + val + "'");
                    }
                }
                ++pos;
            }
            if (pos == 0) {
                throw new ApplicationException("missing port numbers in 'ports = " + val + "'");
            }
            if (pos == 1) {
                this.compressedPort = this.plainPort + 1;
                this.sslPort = this.plainPort + 2;
                this.compressedSslPort = this.plainPort + 3;
            } else if (pos < 4) {
                throw new ApplicationException("either one or all four ports must be given in 'ports = " + val + "'");
            }
            this.checkPort(this.plainPort);
            this.checkPort(this.compressedPort);
            this.checkPort(this.sslPort);
            this.checkPort(this.compressedSslPort);
        }
        if ((val = props.getProperty(CIPHER_SUITES)) != null) {
            stok = new StringTokenizer(val, " \t,;");
            SocketFactoryFactory.enabledCipherSuites = new String[stok.countTokens()];
            i = 0;
            while (stok.hasMoreTokens()) {
                SocketFactoryFactory.enabledCipherSuites[i++] = stok.nextToken();
            }
        }
        if ((val = props.getProperty(PROTOCOLS)) != null) {
            stok = new StringTokenizer(val, " \t,;");
            SocketFactoryFactory.enabledProtocols = new String[stok.countTokens()];
            i = 0;
            while (stok.hasMoreTokens()) {
                SocketFactoryFactory.enabledProtocols[i++] = stok.nextToken();
            }
        }
        if ((val = props.getProperty(CLIENT_AUTH)) != null) {
            SocketFactoryFactory.needClientAuth = true;
        }
        factoryType = SocketFactoryType.parse((String)sessionInfo.getProperties().getProperty("socketfactory"));
        this.csf = SocketFactoryFactory.getInstance().createClientSocketFactory(null, factoryType);
        this.ssf = SocketFactoryFactory.getInstance().createServerSocketFactory(null, factoryType);
        val = props.getProperty(PORT);
        if (val != null) {
            this.port = Integer.valueOf(val);
            this.checkPort(this.port);
        }
        this.port = this.getPort(this.port, factoryType);
    }

    public DbServer(SessionInfo serverInfo) throws ApplicationException {
        this(serverInfo, null);
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public int getPort(int requestedPort, SocketFactoryType factoryType) throws ApplicationException {
        this.checkPort(requestedPort);
        int p = 0;
        switch (factoryType) {
            case DEFAULT: {
                p = this.port;
                break;
            }
            case SYSTEM: 
            case PLAIN: {
                p = this.plainPort;
                break;
            }
            case SSL: {
                p = this.sslPort;
                break;
            }
            case COMPRESSED: {
                p = this.compressedPort;
                break;
            }
            case SSL_COMPRESSED: {
                p = this.compressedSslPort;
            }
        }
        if (p == 0) {
            p = requestedPort;
        }
        if (requestedPort != 0 && requestedPort != p) {
            throw new ApplicationException("protocol for requested port " + requestedPort + " is fixed to " + p);
        }
        if (p < 0) {
            throw new ApplicationException("service at this port is disabled");
        }
        return p;
    }

    public int getPlainPort() {
        return this.plainPort;
    }

    public int getCompressedPort() {
        return this.compressedPort;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public int getCompressedSslPort() {
        return this.compressedSslPort;
    }

    public int getPort() {
        return this.port;
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return this.csf;
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public RMIClientSocketFactory getLoginClientSocketFactory() {
        return this.loginCsf;
    }

    public RMIServerSocketFactory getLoginServerSocketFactory() {
        return this.loginSsf;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public long getSessionTimeoutCheckInterval() {
        return this.sessionTimeoutCheckInterval;
    }

    public void start() throws ApplicationException {
        try {
            int registryPort = 0;
            boolean useRegSF = false;
            if (this.createRegistry) {
                URI uri = new URI(this.service);
                registryPort = uri.getPort();
                if (registryPort <= 0) {
                    registryPort = 1099;
                }
                if (this.loginCsf != null && this.loginSsf != null) {
                    this.registry = LocateRegistry.createRegistry(registryPort, this.loginCsf, this.loginSsf);
                    useRegSF = true;
                } else {
                    this.registry = LocateRegistry.createRegistry(registryPort);
                }
            }
            Constructor<? extends RemoteDbConnectionImpl> constructor = this.connectionClass.getConstructor(DbServer.class, Integer.TYPE, RMIClientSocketFactory.class, RMIServerSocketFactory.class);
            this.connectionObject = constructor.newInstance(this, this.port, useRegSF ? this.loginCsf : this.csf, useRegSF ? this.loginSsf : this.ssf);
            LOGGER.info("\nTentackle RMI-server " + this.getClass().getName() + "\ndefault client socket factory = " + (this.csf == null ? "<system default>" : this.csf.getClass().getName()) + "\ndefault server socket factory = " + (this.ssf == null ? "<system default>" : this.ssf.getClass().getName()) + "\nservice = " + this.service + (this.createRegistry ? ", registry created on port " + registryPort + "\nlogin client socket factory = " + (this.loginCsf == null ? "<system default>" : this.loginCsf.getClass().getName()) + "\nlogin server socket factory = " + (this.loginSsf == null ? "<system default>" : this.loginSsf.getClass().getName()) : "") + "\nlogin port = " + (this.port == 0 ? "<system default>" : Integer.valueOf(this.port)) + ", session timeout = " + this.sessionTimeout + "*" + this.sessionTimeoutCheckInterval + "ms", new Object[0]);
            if (this.createRegistry) {
                URI uri = new URI(this.service);
                String path = uri.getPath();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                this.registry.bind(path, this.connectionObject);
            } else {
                Naming.rebind(this.service, this.connectionObject);
            }
            if (this.sessionTimeoutCheckInterval > 0L) {
                RemoteDbSessionImpl.startCleanupThread(this.sessionTimeoutCheckInterval);
            }
        }
        catch (Exception e) {
            throw new ApplicationException("server startup failed", (Throwable)e);
        }
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void stop() throws ApplicationException {
        try {
            Naming.unbind(this.service);
            if (this.connectionObject != null) {
                this.connectionObject.unexportRemoteObject(this.connectionObject);
                this.connectionObject = null;
            }
            if (this.registry != null) {
                for (String name : this.registry.list()) {
                    LOGGER.info("unbinding {0}", new Object[]{name});
                    this.registry.unbind(name);
                }
                UnicastRemoteObject.unexportObject(this.registry, true);
                this.registry = null;
            }
        }
        catch (Exception e) {
            throw new ApplicationException("server shutdown failed", (Throwable)e);
        }
    }

    private void checkPort(int port) throws ApplicationException {
        if (port < -1 || port > 0 && port < 1024) {
            throw new ApplicationException("illegal port number " + port + ". Possible values: -1, 0, >= 1024");
        }
    }
}

