/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.rmi.RemoteException;
import java.util.List;
import org.tentackle.misc.IdSerialTuple;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.AbstractDbObject;
import org.tentackle.persist.rmi.AbstractDbObjectRemoteDelegate;
import org.tentackle.persist.rmi.DbObjectResult;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;
import org.tentackle.persist.rmi.RemoteDelegateImpl;

public class AbstractDbObjectRemoteDelegateImpl<P extends AbstractDbObject<P>>
extends RemoteDelegateImpl<P>
implements AbstractDbObjectRemoteDelegate<P> {
    private static final long serialVersionUID = -1047294990270307668L;
    protected P dbObject;

    public AbstractDbObjectRemoteDelegateImpl(RemoteDbSessionImpl serverSession, Class<P> clazz) throws RemoteException {
        super(serverSession, clazz);
    }

    @Override
    public void initialize() {
        this.dbObject = this.newInstance();
        ((AbstractDbObject)this.dbObject).setOverloadable(true);
    }

    protected P newInstance() {
        try {
            return (P)AbstractDbObject.newInstance(this.getSession(), this.getServicedClass());
        }
        catch (Exception e) {
            throw new PersistenceException((Session)this.getSession(), "creating object for class '" + this.getServicedClass() + "' failed", (Throwable)e);
        }
    }

    protected void validate(P object) throws RemoteException {
    }

    @Override
    public long obtainReservedId() throws RemoteException {
        try {
            return -((AbstractDbObject)this.dbObject).getIdSource().nextId(this.getSession());
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public P selectObject(long id) throws RemoteException {
        try {
            return ((AbstractDbObject)this.newInstance()).selectObject(id);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public P selectLockedObject(long id) throws RemoteException {
        try {
            return ((AbstractDbObject)this.newInstance()).selectLockedObject(id);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<? extends P> selectAllObjects() throws RemoteException {
        try {
            return ((AbstractDbObject)this.dbObject).selectAllObjects();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<IdSerialTuple> selectAllIdSerial() throws RemoteException {
        try {
            return ((AbstractDbObject)this.dbObject).selectAllIdSerial();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public long selectSerial(long id) throws RemoteException {
        try {
            return ((AbstractDbObject)this.dbObject).selectSerial(id);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public long selectMaxId() throws RemoteException {
        try {
            return ((AbstractDbObject)this.dbObject).selectMaxId();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public long selectMaxTableSerial() throws RemoteException {
        try {
            return ((AbstractDbObject)this.dbObject).selectMaxTableSerial();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public void updatePlain(P obj) throws RemoteException {
        try {
            ((AbstractDbObject)obj).setSession(this.getSession());
            ((AbstractDbObject)obj).updatePlain();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public void dummyUpdate(P obj) throws RemoteException {
        try {
            ((AbstractDbObject)obj).setSession(this.getSession());
            ((AbstractDbObject)obj).dummyUpdate();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public void updateSerial(long id, long serial) throws RemoteException {
        try {
            ((AbstractDbObject)this.dbObject).setId(id);
            ((AbstractDbObject)this.dbObject).setSerial(serial);
            ((AbstractDbObject)this.dbObject).updateSerial();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public void updateSerialAndTableSerial(long id, long serial, long tableSerial) throws RemoteException {
        try {
            ((AbstractDbObject)this.dbObject).setId(id);
            ((AbstractDbObject)this.dbObject).setSerial(serial);
            ((AbstractDbObject)this.dbObject).setTableSerial(tableSerial);
            ((AbstractDbObject)this.dbObject).updateSerialAndTableSerial();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<IdSerialTuple> selectExpiredTableSerials(long oldSerial) throws RemoteException {
        try {
            return ((AbstractDbObject)this.dbObject).selectExpiredTableSerials(oldSerial);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<IdSerialTuple> selectExpiredTableSerials(long oldSerial, long maxSerial) throws RemoteException {
        try {
            return ((AbstractDbObject)this.dbObject).selectExpiredTableSerials(oldSerial, maxSerial);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<IdSerialTuple> getExpirationBacklog(long minSerial, long maxSerial) throws RemoteException {
        try {
            return ((AbstractDbObject)this.dbObject).getExpirationBacklog(minSerial, maxSerial);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<IdSerialTuple> getExpiredTableSerials(long oldSerial, long maxSerial) throws RemoteException {
        try {
            return ((AbstractDbObject)this.dbObject).getExpiredTableSerials(oldSerial, maxSerial);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public void deletePlain(long id, long serial) throws RemoteException {
        try {
            ((AbstractDbObject)this.dbObject).setId(id);
            ((AbstractDbObject)this.dbObject).setSerial(serial);
            ((AbstractDbObject)this.dbObject).deletePlain();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public void insertPlain(P obj) throws RemoteException {
        try {
            ((AbstractDbObject)obj).setSession(this.getSession());
            ((AbstractDbObject)obj).insertPlain();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public DbObjectResult updateObject(P obj) throws RemoteException {
        try {
            ((AbstractDbObject)obj).setSession(this.getSession());
            ((AbstractDbObject)obj).updateObject();
            return new DbObjectResult((AbstractDbObject<?>)obj);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public DbObjectResult insertObject(P obj) throws RemoteException {
        try {
            ((AbstractDbObject)obj).setSession(this.getSession());
            ((AbstractDbObject)obj).insertObject();
            return new DbObjectResult((AbstractDbObject<?>)obj);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public DbObjectResult saveObject(P obj) throws RemoteException {
        try {
            ((AbstractDbObject)obj).setSession(this.getSession());
            this.validate(obj);
            ((AbstractDbObject)obj).saveObject();
            return new DbObjectResult((AbstractDbObject<?>)obj);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public P persistObject(P obj) throws RemoteException {
        try {
            ((AbstractDbObject)obj).setSession(this.getSession());
            this.validate(obj);
            return (P)(((AbstractDbObject)obj).persistObject() != null ? obj : null);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public DbObjectResult deleteObject(P obj) throws RemoteException {
        try {
            ((AbstractDbObject)obj).setSession(this.getSession());
            ((AbstractDbObject)obj).deleteObject();
            return new DbObjectResult((AbstractDbObject<?>)obj);
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public long countModification() throws RemoteException {
        try {
            return ((AbstractDbObject)this.dbObject).countModification();
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public long getModificationCount() throws RemoteException {
        try {
            return ((AbstractDbObject)this.dbObject).getModificationCount();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }

    @Override
    public boolean isReferenced(long id) throws RemoteException {
        try {
            return ((AbstractDbObject)((AbstractDbObject)this.newInstance()).selectObject(id)).isReferenced();
        }
        catch (RuntimeException e) {
            throw this.createException(e);
        }
    }
}

