/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.misc.IdSerialTuple;

public class TableSerialExpirationBacklog {
    public static int defaultSize = 64;
    private final ExpirationSet[] expirations;
    private int nextNdx;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public TableSerialExpirationBacklog(int size) {
        this.expirations = new ExpirationSet[size];
        for (int i = 0; i < size; ++i) {
            this.expirations[i] = null;
        }
    }

    public TableSerialExpirationBacklog() {
        this(defaultSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExpiration(long minSerial, long maxSerial, List<IdSerialTuple> idSerTuples) {
        if (idSerTuples != null && !idSerTuples.isEmpty()) {
            this.lock.writeLock().lock();
            try {
                this.expirations[this.nextNdx++] = new ExpirationSet(minSerial, maxSerial, idSerTuples);
                if (this.nextNdx >= this.expirations.length) {
                    this.nextNdx = 0;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IdSerialTuple> getExpiration(long minSerial, long maxSerial) {
        ExpirationSet[] matchedExps = new ExpirationSet[this.expirations.length];
        int matchCount = 0;
        this.lock.readLock().lock();
        try {
            int ndx = this.nextNdx;
            for (int i = 0; i < this.expirations.length; ++i) {
                ExpirationSet exp;
                if (ndx >= this.expirations.length) {
                    ndx = 0;
                }
                if ((exp = this.expirations[ndx++]) == null || exp.maxSerial < minSerial || exp.minSerial > maxSerial) continue;
                matchedExps[matchCount++] = exp;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        while (matchCount > 0) {
            if ((matchedExps = this.merge(matchedExps, matchCount)).length == matchCount) {
                for (int m = 0; m < matchCount; ++m) {
                    ExpirationSet exp = matchedExps[m];
                    if (exp.minSerial > minSerial || exp.maxSerial < maxSerial) continue;
                    TreeSet<IdSerialTuple> setById = new TreeSet<IdSerialTuple>((o1, o2) -> {
                        int rv = Long.compare(o2.getId(), o1.getId());
                        if (rv == 0) {
                            rv = Long.compare(o2.getSerial(), o1.getSerial());
                        }
                        return rv;
                    });
                    for (IdSerialTuple idSer : exp.idSerTuples) {
                        if (idSer.getSerial() <= minSerial || idSer.getSerial() > maxSerial) continue;
                        setById.add(idSer);
                    }
                    ArrayList<IdSerialTuple> expireList = new ArrayList<IdSerialTuple>();
                    IdSerialTuple lastIdSer = null;
                    for (IdSerialTuple idSer : setById) {
                        if (lastIdSer == null || lastIdSer.getId() == idSer.getId()) {
                            lastIdSer = idSer;
                            continue;
                        }
                        expireList.add(lastIdSer);
                        lastIdSer = idSer;
                    }
                    if (lastIdSer != null) {
                        expireList.add(lastIdSer);
                    }
                    return expireList;
                }
                break;
            }
            matchCount = matchedExps.length;
        }
        return null;
    }

    private ExpirationSet[] merge(ExpirationSet[] expSets, int count) {
        ExpirationSet[] mergedSets = new ExpirationSet[count];
        mergedSets[0] = expSets[0].clone();
        int mergeCount = 1;
        for (int i = 1; i < count; ++i) {
            ExpirationSet exp = expSets[i];
            boolean merged = false;
            for (int j = 0; j < mergeCount; ++j) {
                ExpirationSet mexp = mergedSets[j];
                if (exp.maxSerial >= mexp.minSerial && exp.minSerial <= mexp.minSerial) {
                    mexp.minSerial = exp.minSerial;
                    if (exp.maxSerial > mexp.maxSerial) {
                        mexp.maxSerial = exp.maxSerial;
                    }
                    merged = true;
                }
                if (exp.minSerial <= mexp.maxSerial && exp.maxSerial >= mexp.maxSerial) {
                    mexp.maxSerial = exp.maxSerial;
                    if (exp.minSerial < mexp.minSerial) {
                        mexp.minSerial = exp.minSerial;
                    }
                    merged = true;
                }
                if (!merged) continue;
                mexp.idSerTuples.addAll(exp.idSerTuples);
                break;
            }
            if (merged) continue;
            mergedSets[mergeCount++] = exp.clone();
        }
        ExpirationSet[] nMergedSets = new ExpirationSet[mergeCount];
        System.arraycopy(mergedSets, 0, nMergedSets, 0, mergeCount);
        return nMergedSets;
    }

    private static class ExpirationSet
    implements Cloneable {
        private long minSerial;
        private long maxSerial;
        private final List<IdSerialTuple> idSerTuples;

        private ExpirationSet(long minSerial, long maxSerial, List<IdSerialTuple> idSerTuples) {
            this.minSerial = minSerial;
            this.maxSerial = maxSerial;
            this.idSerTuples = idSerTuples;
        }

        public ExpirationSet clone() {
            try {
                return (ExpirationSet)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new TentackleRuntimeException("clone failed", (Throwable)ex);
            }
        }
    }
}

