/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.ConstraintException;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.Db;
import org.tentackle.persist.ManagedConnection;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementHistory;

public class StatementWrapper
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementWrapper.class);
    protected final ManagedConnection con;
    protected Statement stmt;
    protected String sql;
    protected boolean ready;
    protected boolean running;
    protected boolean cancelled;
    protected WeakReference<ResultSetWrapper> openResultSet;

    public StatementWrapper(ManagedConnection con, Statement stmt) {
        this.con = con;
        this.stmt = stmt;
    }

    public ManagedConnection getConnection() {
        return this.con;
    }

    public Statement getStatement() {
        return this.stmt;
    }

    public Db getSession() {
        Db db = this.con.getSession();
        if (db == null) {
            LOGGER.warning("statement " + this + " not attached to connection " + this.con, new Object[0]);
        }
        return db;
    }

    public Db getAttachedSession() {
        Db db = this.getSession();
        if (db == null) {
            throw new PersistenceException("connection " + this.con + " already detached from statement " + this);
        }
        return db;
    }

    public synchronized void markReady() {
        if (this.isMarkedReady()) {
            String msg = "statement " + this + " marked ready and not consumed yet";
            this.forceDetached();
            throw new PersistenceException((Session)this.getSession(), msg);
        }
        this.ready = true;
        this.cancelled = false;
    }

    public synchronized void unmarkReady() {
        if (!this.isClosed() && !this.isMarkedReady()) {
            String msg = "statement " + this + " already consumed";
            this.forceDetached();
            throw new PersistenceException((Session)this.getSession(), msg);
        }
        this.ready = false;
        this.setRunning(false);
    }

    public synchronized boolean isMarkedReady() {
        return this.ready;
    }

    public void consume() {
        LOGGER.fine("statement {0} consumed", new Object[]{this});
        this.unmarkReady();
        this.detachSession();
    }

    public String getSql() {
        return this.sql;
    }

    public String toString() {
        return "{ " + (this.stmt == null ? "<closed>" : this.stmt.toString()) + " }";
    }

    protected void detachSession() {
        Db db = this.getSession();
        if (db != null) {
            db.detach();
        }
    }

    protected int executeUpdateImpl(String sql) throws SQLException {
        this.sql = sql;
        return this.stmt.executeUpdate(sql);
    }

    public int executeUpdate(String sql) {
        LOGGER.finest("execute update {0} = {1}", new Object[]{this, sql});
        try {
            this.con.countForClearWarnings();
            this.assertOpen();
            this.assertNotReadOnly();
            this.unmarkReady();
            Db db = this.getAttachedSession();
            db.setAlive(true);
            this.setRunning(true);
            StatementHistory history = this.con.logStatementHistory(this);
            int count = this.executeUpdateImpl(sql);
            history.end();
            this.setRunning(false);
            if (count > 0) {
                db.addToUpdateCount(count);
            }
            this.detachSession();
            return count;
        }
        catch (SQLException e) {
            Db db = this.getAttachedSession();
            if (!db.checkForDeadLink(e) && db.getBackend().isConstraintException(e)) {
                throw new ConstraintException((Session)db, this.toString(), (Throwable)e);
            }
            throw new PersistenceException((Session)db, this.toString(), (Throwable)e);
        }
    }

    protected ResultSet executeQueryImpl(String sql) throws SQLException {
        this.sql = sql;
        return this.stmt.executeQuery(sql);
    }

    ResultSetWrapper createResultSetWrapper(ResultSet jdbcResultSet) {
        ResultSetWrapper rs = new ResultSetWrapper(this, jdbcResultSet);
        this.con.addResultSet(rs);
        this.openResultSet = new WeakReference<ResultSetWrapper>(rs);
        return rs;
    }

    void forgetResultSetWrapper(ResultSetWrapper rs) {
        this.con.removeResultSet(rs);
        this.openResultSet = null;
    }

    public ResultSetWrapper executeQuery(String sql, boolean withinTx) {
        LOGGER.finest("execute query {0} = {1}", new Object[]{this, sql});
        long txVoucher = 0L;
        try {
            this.con.countForClearWarnings();
            this.assertOpen();
            Db db = this.getAttachedSession();
            db.setAlive(true);
            this.setRunning(true);
            if (withinTx) {
                txVoucher = db.begin("executeQuery");
            }
            StatementHistory history = this.con.logStatementHistory(this);
            ResultSetWrapper resultSet = this.createResultSetWrapper(this.executeQueryImpl(sql));
            history.end();
            if (withinTx) {
                resultSet.setCommitOnCloseVoucher(true, txVoucher);
            }
            return resultSet;
        }
        catch (SQLException e) {
            Db db = this.getAttachedSession();
            db.checkForDeadLink(e);
            if (withinTx) {
                try {
                    db.rollback(txVoucher);
                }
                catch (RuntimeException rex) {
                    db.logException(LOGGER, Logger.Level.SEVERE, "statement failed", e);
                }
            } else {
                db.forceDetached();
            }
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public ResultSetWrapper executeQuery(String sql) {
        return this.executeQuery(sql, false);
    }

    protected synchronized void setRunning(boolean running) {
        this.running = running;
        if (running) {
            this.con.addRunningStatement(this);
        } else {
            this.con.removeRunningStatement(this);
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void cancel() {
        try {
            if (this.stmt != null) {
                LOGGER.info("canceling statement: {0}", new Object[]{this});
                this.stmt.cancel();
            }
            this.setRunning(false);
            this.cancelled = true;
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void close() {
        Statement st = this.stmt;
        if (st != null) {
            try {
                if (this.isMarkedReady()) {
                    LOGGER.warning("statement " + this + " not consumed -> cleanup", new Object[0]);
                    this.ready = false;
                }
                st.close();
            }
            catch (SQLException sqx) {
                throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)sqx);
            }
            finally {
                this.stmt = null;
                WeakReference<ResultSetWrapper> ref = this.openResultSet;
                if (ref != null) {
                    ResultSetWrapper rs = (ResultSetWrapper)ref.get();
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (RuntimeException rex) {
                            LOGGER.severe("closing result set failed for statement " + this, (Throwable)rex);
                        }
                    }
                    this.openResultSet = null;
                }
            }
        }
    }

    public boolean isClosed() {
        return this.stmt == null;
    }

    public void setFetchSize(int rows) {
        this.assertOpen();
        try {
            this.stmt.setFetchSize(rows);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public int getFetchSize() {
        this.assertOpen();
        try {
            return this.stmt.getFetchSize();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setMaxRows(int max) {
        this.assertOpen();
        try {
            this.stmt.setMaxRows(max);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public int getMaxRows() {
        this.assertOpen();
        try {
            return this.stmt.getMaxRows();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setFetchDirection(int direction) {
        this.assertOpen();
        try {
            this.stmt.setFetchDirection(direction);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public int getFetchDirection() {
        this.assertOpen();
        try {
            return this.stmt.getFetchDirection();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    protected void assertOpen() {
        if (this.stmt == null) {
            throw new PersistenceException((Session)this.getSession(), "statement already closed");
        }
    }

    protected void assertNotReadOnly() {
        Db db = this.getSession();
        if (db != null && db.isReadOnly()) {
            throw new PersistenceException((Session)db, "is read-only");
        }
    }

    protected void forceDetached() {
        try {
            Db db = this.getSession();
            if (db != null) {
                db.forceDetached();
            }
        }
        catch (RuntimeException rex) {
            LOGGER.severe("emergency detach failed", (Throwable)rex);
        }
    }
}

