/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.tentackle.common.Compare;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.log.StatisticsResult;
import org.tentackle.misc.Duration;
import org.tentackle.persist.StatementHistory;

public class StatementStatistics
implements Comparable<StatementStatistics> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementStatistics.class);
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    private static final Map<StatementStatistics, StatementStatistics> STAT_MAP = new HashMap<StatementStatistics, StatementStatistics>();
    private static long since;
    public static boolean with_parameters;
    private final int instanceNumber = INSTANCE_COUNT.incrementAndGet();
    private final String sql;
    private final String txName;
    private final Map<Integer, Object> parameters;
    private final StatisticsResult statResult;

    public static synchronized void collect(StatementHistory history) {
        StatementStatistics key = new StatementStatistics(history.getSql(), history.getTxName(), with_parameters ? history.getParameters() : null);
        StatementStatistics value = STAT_MAP.get(key);
        if (value == null) {
            value = key;
            STAT_MAP.put(key, value);
        }
        value.countInvocation(history.getDuration());
    }

    public static synchronized Set<StatementStatistics> getStatistics(boolean clear) {
        TreeSet<StatementStatistics> stats = new TreeSet<StatementStatistics>(STAT_MAP.values());
        if (clear) {
            StatementStatistics.clearStatistics();
        }
        return stats;
    }

    public static synchronized void clearStatistics() {
        STAT_MAP.clear();
        since = System.currentTimeMillis();
    }

    public static synchronized long getSince() {
        if (since == 0L) {
            since = System.currentTimeMillis();
        }
        return since;
    }

    public static void log(Logger logger, Logger.Level level, boolean clear) {
        try {
            if (logger.isLoggable(level)) {
                StringBuilder buf = new StringBuilder("SQL Statement Statistics:");
                for (StatementStatistics stat : StatementStatistics.getStatistics(clear)) {
                    buf.append("\n    ");
                    buf.append(stat);
                }
                logger.log(level, buf.toString(), null);
            }
        }
        catch (RuntimeException rex) {
            LOGGER.severe("cannot log SQL statistics", (Throwable)rex);
        }
    }

    public StatementStatistics(String sql, String txName, Map<Integer, Object> parameters) {
        this.sql = sql;
        this.txName = txName;
        this.parameters = parameters;
        this.statResult = new StatisticsResult();
    }

    public void countInvocation(Duration duration) {
        if (duration != null && duration.isValid()) {
            this.statResult.count(duration);
        }
    }

    public StatisticsResult getStatistics() {
        return this.statResult;
    }

    public Map<Integer, Object> getParameters() {
        return this.parameters;
    }

    public String getSql() {
        return this.sql;
    }

    public String getTxName() {
        return this.txName;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + (this.sql != null ? this.sql.hashCode() : 0);
        hash = 79 * hash + (this.txName != null ? this.txName.hashCode() : 0);
        hash = 79 * hash + (this.parameters != null ? this.parameters.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatementStatistics other = (StatementStatistics)obj;
        if (this.sql == null ? other.sql != null : !this.sql.equals(other.sql)) {
            return false;
        }
        if (this.txName == null ? other.txName != null : !this.txName.equals(other.txName)) {
            return false;
        }
        return this.parameters == other.parameters || this.parameters != null && this.parameters.equals(other.parameters);
    }

    @Override
    public int compareTo(StatementStatistics o) {
        int rv = Compare.compare((Comparable)((Object)this.sql), (Comparable)((Object)o.sql));
        if (rv == 0) {
            rv = this.instanceNumber - o.instanceNumber;
        }
        return rv;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(">SQL-Stats: ");
        buf.append(this.statResult.getMinDuration().millisToString()).append(' ').append(this.statResult.getMaxDuration().millisToString()).append(' ').append(this.statResult.getTotalDuration().millisToString()).append(" ms / ").append(this.statResult.getCount()).append(" x ").append(this.sql == null ? "<null>" : this.sql);
        if (this.parameters != null && !this.parameters.isEmpty()) {
            for (Integer pos : new TreeSet<Integer>(this.parameters.keySet())) {
                buf.append(", ").append(pos).append("='");
                Object value = this.parameters.get(pos);
                buf.append(value == null ? "<null>" : value.toString()).append("'");
            }
        }
        if (this.txName != null) {
            buf.append(" in [").append(this.txName).append(']');
        }
        return buf.toString();
    }
}

