/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeSet;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.Duration;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.StatementWrapper;

public class StatementHistory {
    public static long logMinDurationMillis;
    private static final DateFormat START_TIME_FORMAT;
    private static final Logger LOGGER;
    private final String txName;
    private final long executionStart;
    private final Duration duration;
    private final String sql;
    private final Map<Integer, Object> parameters;

    public StatementHistory(StatementWrapper statement) {
        this.parameters = statement instanceof PreparedStatementWrapper ? ((PreparedStatementWrapper)statement).getParameters() : null;
        this.txName = statement.getAttachedSession().getTxName();
        this.executionStart = System.currentTimeMillis();
        this.duration = new Duration();
        this.sql = statement.getSql();
    }

    public void end() {
        this.duration.end();
        if (logMinDurationMillis > 0L && this.duration.millis() > (double)logMinDurationMillis) {
            LOGGER.warning(">>> duration >>> " + this.toString(), new Object[0]);
        } else if (LOGGER.isFinerLoggable()) {
            LOGGER.finer(this.toString(), new Object[0]);
        }
    }

    public long getExecutionStart() {
        return this.executionStart;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public String getTxName() {
        return this.txName;
    }

    public Map<Integer, Object> getParameters() {
        return this.parameters;
    }

    public String getSql() {
        return this.sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder();
        DateFormat dateFormat = START_TIME_FORMAT;
        synchronized (dateFormat) {
            buf.append(START_TIME_FORMAT.format(new Date(this.getExecutionStart())));
        }
        buf.append('(');
        if (this.duration.isValid()) {
            buf.append(this.duration.millisToString());
            buf.append("ms): ");
        } else {
            buf.append("running): ");
        }
        buf.append(this.sql);
        if (this.parameters != null && !this.parameters.isEmpty()) {
            for (Integer pos : new TreeSet<Integer>(this.parameters.keySet())) {
                buf.append(", ");
                buf.append(pos);
                buf.append("='");
                Object value = this.parameters.get(pos);
                buf.append(value == null ? "<null>" : value.toString());
                buf.append("'");
            }
        }
        if (this.txName != null) {
            buf.append(" in [").append(this.txName).append(']');
        }
        return buf.toString();
    }

    static {
        START_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
        LOGGER = LoggerFactory.getLogger(StatementHistory.class);
    }
}

