/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tentackle.common.BMoney;
import org.tentackle.common.Binary;
import org.tentackle.common.DMoney;
import org.tentackle.common.Date;
import org.tentackle.common.Time;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.DateHelper;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.Db;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetSection;
import org.tentackle.persist.ResultSetSkipBlock;
import org.tentackle.persist.StatementWrapper;

public class ResultSetWrapper
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetWrapper.class);
    private ResultSet rs;
    private StatementWrapper stmt;
    private Db db;
    private int columnOffset;
    private boolean commitOnCloseVoucherValid;
    private long commitOnCloseVoucher;
    private boolean closeStatementOnClose;
    private int columnCount;
    private ResultSetMetaData metaData;
    private List<ResultSetSkipBlock> skipBlocks;
    private ResultSetSkipBlock skipBlock;
    private int skipBlockIndex;
    private boolean cursorMovedInSkipMode;
    private Map<Object, ResultSetSection> sections;
    private ResultSetSection currentSection;

    public ResultSetWrapper(StatementWrapper stmt, ResultSet rs) {
        this.stmt = stmt;
        this.rs = rs;
        this.db = stmt.getSession();
        if (this.db == null) {
            stmt.consume();
            throw new PersistenceException("connection already closed for " + this);
        }
        this.closeStatementOnClose = !(stmt instanceof PreparedStatementWrapper) || ((PreparedStatementWrapper)stmt).getStatementKey() == null;
        this.columnCount = -1;
    }

    public Db getSession() {
        return this.db;
    }

    public String toString() {
        return this.stmt == null ? "(closed resultset)" : this.stmt.toString();
    }

    public ResultSetMetaData getMetaData() {
        if (this.metaData == null) {
            try {
                this.metaData = this.rs.getMetaData();
            }
            catch (SQLException sqx) {
                throw new PersistenceException((Session)this.db, (Throwable)sqx);
            }
        }
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ResultSet rset = this.rs;
        if (rset != null) {
            try {
                StatementWrapper st = this.stmt;
                if (st != null && !st.isClosed()) {
                    st.unmarkReady();
                    st.forgetResultSetWrapper(this);
                    boolean voucherValid = this.commitOnCloseVoucherValid;
                    Db session = this.db;
                    if (voucherValid && session != null) {
                        session.commit(this.commitOnCloseVoucher);
                        this.commitOnCloseVoucher = 0L;
                        this.commitOnCloseVoucherValid = false;
                    }
                }
                rset.close();
            }
            catch (SQLException sqx) {
                throw new PersistenceException((Session)this.db, (Throwable)sqx);
            }
            catch (RuntimeException rex) {
                LOGGER.severe("closing result set wrapper " + this + " failed", (Throwable)rex);
            }
            finally {
                this.db = null;
                this.rs = null;
                this.skipBlock = null;
                this.skipBlocks = null;
                StatementWrapper st = this.stmt;
                if (st != null) {
                    st.detachSession();
                    if (this.closeStatementOnClose) {
                        st.close();
                    }
                    this.stmt = null;
                }
            }
        }
    }

    public boolean isClosed() {
        return this.rs == null;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed()) {
                LOGGER.warning("pending resultset '" + this + "' closed by finalizer", new Object[0]);
                this.close();
            }
        }
        catch (Exception ex) {
            try {
                LOGGER.severe("closing pending resultset '" + this + "' failed in finalizer", new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            super.finalize();
        }
    }

    public void setCommitOnCloseVoucher(boolean commitOnCloseVoucherValid, long commitOnCloseVoucher) {
        this.commitOnCloseVoucherValid = commitOnCloseVoucherValid;
        this.commitOnCloseVoucher = commitOnCloseVoucher;
    }

    public boolean isCommitOnCloseVoucherValid() {
        return this.commitOnCloseVoucherValid;
    }

    public long getCommitOnCloseVoucher() {
        if (!this.isCommitOnCloseVoucherValid()) {
            throw new PersistenceException("commitOnCloseVoucher is not valid");
        }
        return this.commitOnCloseVoucher;
    }

    public void setCloseStatementOnclose(boolean closeStatementOnClose) {
        this.closeStatementOnClose = closeStatementOnClose;
    }

    public boolean isCloseStatementOnclose() {
        return this.closeStatementOnClose;
    }

    public void setColumnOffset(int columnOffset) {
        this.columnOffset = columnOffset;
    }

    public int getColumnOffset() {
        return this.columnOffset;
    }

    public int getColumnCount() {
        if (this.columnCount == -1) {
            try {
                this.columnCount = this.getMetaData().getColumnCount();
            }
            catch (SQLException sqx) {
                throw new PersistenceException((Session)this.db, (Throwable)sqx);
            }
        }
        return this.columnCount;
    }

    public boolean isInSkipMode() {
        return this.skipBlocks != null;
    }

    public int findColumn(String name) {
        if (this.isInSkipMode()) {
            int ndx = this.skipBlock.findColumn(name);
            return ndx - this.columnOffset;
        }
        try {
            return this.rs.findColumn(name) - this.columnOffset;
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public void skipColumns(int columnCount) {
        this.assertInSkipMode();
        this.skipBlock.applyColumnIndex(this.skipBlock.getSkippedColumns() + columnCount);
    }

    public void startSkip() {
        if (this.cursorMovedInSkipMode) {
            this.assertInSkipMode();
            this.skipBlock = this.skipBlocks.get(0);
            this.skipBlockIndex = 0;
        } else {
            this.skipBlock = new ResultSetSkipBlock(this, 0);
            this.skipBlocks = new ArrayList<ResultSetSkipBlock>();
            this.skipBlocks.add(this.skipBlock);
            this.cursorMovedInSkipMode = false;
        }
    }

    public void endSkip() {
        this.skipBlocks = null;
        this.skipBlock = null;
    }

    public List<ResultSetSkipBlock> getSkipBlocks() {
        this.assertInSkipMode();
        return this.skipBlocks;
    }

    public int getSkipBlockIndex() {
        this.assertInSkipMode();
        return this.skipBlockIndex;
    }

    public void skip() {
        this.assertInSkipMode();
        if (this.cursorMovedInSkipMode) {
            ++this.skipBlockIndex;
            if (this.skipBlockIndex >= this.skipBlocks.size()) {
                throw new PersistenceException((Session)this.db, "only " + this.skipBlocks.size() + " skip blocks used so far in " + this);
            }
            this.skipBlock = this.skipBlocks.get(this.skipBlockIndex);
        } else {
            int skippedColumns = this.skipBlock == null ? 0 : this.skipBlock.getMaxColumnIndex();
            this.skipBlock = new ResultSetSkipBlock(this, skippedColumns);
            this.skipBlocks.add(this.skipBlock);
        }
    }

    public void skip(int columnCount) {
        this.skipColumns(columnCount);
        this.skip();
    }

    public boolean configureSection(Object key) {
        if (this.sections == null) {
            this.sections = new HashMap<Object, ResultSetSection>();
        }
        this.currentSection = this.sections.get(key);
        if (this.currentSection == null) {
            this.currentSection = new ResultSetSection(this, key);
            this.sections.put(key, this.currentSection);
            return true;
        }
        this.currentSection.resetColumnIndex();
        return false;
    }

    public void configureColumn(String name) {
        this.assertValidSection();
        this.currentSection.configureColumn(name);
    }

    public void setFetchSize(int rows) {
        try {
            this.rs.setFetchSize(rows);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public int getFetchSize() {
        try {
            return this.rs.getFetchSize();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public void setFetchDirection(int direction) {
        try {
            this.rs.setFetchDirection(direction);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public int getFetchDirection() {
        try {
            return this.rs.getFetchDirection();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public boolean next() {
        try {
            this.clearSection();
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public boolean previous() {
        try {
            this.clearSection();
            return this.rs.previous();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public boolean first() {
        try {
            this.clearSection();
            return this.rs.first();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public boolean last() {
        try {
            this.clearSection();
            return this.rs.last();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public void beforeFirst() {
        try {
            this.clearSection();
            this.rs.beforeFirst();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public void afterLast() {
        try {
            this.clearSection();
            this.rs.afterLast();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public boolean isBeforeFirst() {
        try {
            return this.rs.isBeforeFirst();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public boolean isAfterLast() {
        try {
            return this.rs.isAfterLast();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public int getRow() {
        try {
            return this.rs.getRow();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public boolean absolute(int row) {
        try {
            this.clearSection();
            return this.rs.absolute(row);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public boolean relative(int rows) {
        try {
            this.clearSection();
            return this.rs.relative(rows);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public boolean wasNull() {
        try {
            return this.rs.wasNull();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Object getObject(String name) {
        try {
            return this.rs.getObject(name);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public String getString(String name, boolean mapNull) {
        try {
            String str = this.rs.getString(name);
            if (mapNull && str != null && str.equals(this.db.getBackend().getEmptyString())) {
                return null;
            }
            return str;
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public String getString(String name) {
        return this.getString(name, false);
    }

    public boolean getBoolean(String name) {
        try {
            return this.rs.getBoolean(name);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Boolean getABoolean(String name) {
        boolean value = this.getBoolean(name);
        return this.wasNull() ? null : Boolean.valueOf(value);
    }

    public float getFloat(String name) {
        try {
            return this.rs.getFloat(name);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Float getAFloat(String name) {
        float value = this.getFloat(name);
        return this.wasNull() ? null : Float.valueOf(value);
    }

    public double getDouble(String name) {
        try {
            return this.rs.getDouble(name);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Double getADouble(String name) {
        double value = this.getDouble(name);
        return this.wasNull() ? null : Double.valueOf(value);
    }

    public BigDecimal getBigDecimal(String name) {
        try {
            return this.rs.getBigDecimal(name);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public BMoney getBMoney(String name) {
        double value = this.getDouble(name);
        return this.wasNull() ? null : new BMoney(value, this.getInt(name + "P"));
    }

    public DMoney getDMoney(String name) {
        try {
            BigDecimal decimal = this.rs.getBigDecimal(name);
            if (!this.wasNull()) {
                return new DMoney(decimal.movePointLeft(this.getInt(name + "P")));
            }
            return null;
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public byte getByte(String name) {
        try {
            return this.rs.getByte(name);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Byte getAByte(String name) {
        byte value = this.getByte(name);
        return this.wasNull() ? null : Byte.valueOf(value);
    }

    public char getChar(String name) {
        try {
            String val = this.rs.getString(name);
            return val == null || val.length() == 0 ? (char)'\u0000' : val.charAt(0);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Character getCharacter(String name, boolean mapNull) {
        char value = this.getChar(name);
        return this.wasNull() ? null : (mapNull && value == ' ' ? null : Character.valueOf(value));
    }

    public Character getCharacter(String name) {
        return this.getCharacter(name, false);
    }

    public short getShort(String name) {
        try {
            return this.rs.getShort(name);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Short getAShort(String name) {
        short value = this.getShort(name);
        return this.wasNull() ? null : Short.valueOf(value);
    }

    public int getInt(String name) {
        try {
            return this.rs.getInt(name);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Integer getInteger(String name) {
        int value = this.getInt(name);
        return this.wasNull() ? null : Integer.valueOf(value);
    }

    public long getLong(String name) {
        try {
            return this.rs.getLong(name);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Long getALong(String name) {
        long value = this.getLong(name);
        return this.wasNull() ? null : Long.valueOf(value);
    }

    public Date getDate(String name, Calendar timezone, boolean mapNull) {
        try {
            java.sql.Date date;
            java.sql.Date date2 = date = timezone == null ? this.rs.getDate(name) : this.rs.getDate(name, timezone);
            if (date == null || mapNull && date.equals(DateHelper.MIN_DATE)) {
                return null;
            }
            return new Date(date.getTime());
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Date getDate(String name, Calendar timezone) {
        return this.getDate(name, timezone, false);
    }

    public Date getDate(String name, boolean mapNull) {
        return this.getDate(name, null, mapNull);
    }

    public Date getDate(String name) {
        return this.getDate(name, null, false);
    }

    public org.tentackle.common.Timestamp getTimestamp(String name, Calendar timezone, boolean mapNull) {
        try {
            Timestamp ts;
            Timestamp timestamp = ts = timezone == null ? this.rs.getTimestamp(name) : this.rs.getTimestamp(name, timezone);
            if (ts == null || mapNull && ts.equals((Timestamp)DateHelper.MIN_TIMESTAMP)) {
                return null;
            }
            org.tentackle.common.Timestamp tts = new org.tentackle.common.Timestamp(ts.getTime());
            tts.setNanos(ts.getNanos());
            return tts;
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public org.tentackle.common.Timestamp getTimestamp(String name, Calendar timezone) {
        return this.getTimestamp(name, timezone, false);
    }

    public org.tentackle.common.Timestamp getTimestamp(String name, boolean mapNull) {
        return this.getTimestamp(name, null, mapNull);
    }

    public org.tentackle.common.Timestamp getTimestamp(String name) {
        return this.getTimestamp(name, null, false);
    }

    public Time getTime(String name, Calendar timezone) {
        try {
            java.sql.Time time = timezone == null ? this.rs.getTime(name) : this.rs.getTime(name, timezone);
            return time == null ? null : new Time(time.getTime());
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Time getTime(String name) {
        return this.getTime(name, null);
    }

    public Binary<?> getBinary(String name, int bufSize) {
        try {
            return Binary.createBinary((InputStream)this.rs.getBinaryStream(name), (int)bufSize);
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Object getObject(int pos) {
        try {
            return this.rs.getObject(pos + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public String getString(int pos, boolean mapNull) {
        try {
            String str = this.rs.getString(pos + this.columnOffset);
            if (mapNull && str != null && str.equals(this.db.getBackend().getEmptyString())) {
                return null;
            }
            return str;
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public String getString(int pos) {
        return this.getString(pos, false);
    }

    public boolean getBoolean(int pos) {
        try {
            return this.rs.getBoolean(pos + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Boolean getABoolean(int pos) {
        boolean value = this.getBoolean(pos);
        return this.wasNull() ? null : Boolean.valueOf(value);
    }

    public float getFloat(int pos) {
        try {
            return this.rs.getFloat(pos + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Float getAFloat(int pos) {
        float value = this.getFloat(pos);
        return this.wasNull() ? null : Float.valueOf(value);
    }

    public double getDouble(int pos) {
        try {
            return this.rs.getDouble(pos + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Double getADouble(int pos) {
        double value = this.getDouble(pos);
        return this.wasNull() ? null : Double.valueOf(value);
    }

    public BigDecimal getBigDecimal(int pos) {
        try {
            return this.rs.getBigDecimal(pos + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public BMoney getBMoney(int pos, int ppos) {
        double value = this.getDouble(pos);
        return this.wasNull() ? null : new BMoney(value, this.getInt(ppos));
    }

    public DMoney getDMoney(int pos, int ppos) {
        BigDecimal value = this.getBigDecimal(pos);
        return this.wasNull() ? null : new DMoney(value.movePointLeft(this.getInt(ppos)));
    }

    public byte getByte(int pos) {
        try {
            return this.rs.getByte(pos + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Byte getAByte(int pos) {
        byte value = this.getByte(pos);
        return this.wasNull() ? null : Byte.valueOf(value);
    }

    public char getChar(int pos) {
        try {
            String val = this.rs.getString(pos + this.columnOffset);
            return val == null || val.length() == 0 ? (char)'\u0000' : val.charAt(0);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Character getCharacter(int pos, boolean mapNull) {
        char value = this.getChar(pos);
        return this.wasNull() ? null : (mapNull && value == ' ' ? null : Character.valueOf(value));
    }

    public Character getCharacter(int pos) {
        return this.getCharacter(pos, false);
    }

    public short getShort(int pos) {
        try {
            return this.rs.getShort(pos + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Short getAShort(int pos) {
        short value = this.getShort(pos);
        return this.wasNull() ? null : Short.valueOf(value);
    }

    public int getInt(int pos) {
        try {
            return this.rs.getInt(pos + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Integer getInteger(int pos) {
        int value = this.getInt(pos);
        return this.wasNull() ? null : Integer.valueOf(value);
    }

    public long getLong(int pos) {
        try {
            return this.rs.getLong(pos + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Long getALong(int pos) {
        long value = this.getLong(pos);
        return this.wasNull() ? null : Long.valueOf(value);
    }

    public Date getDate(int pos, Calendar timezone, boolean mapNull) {
        try {
            java.sql.Date date;
            java.sql.Date date2 = date = timezone == null ? this.rs.getDate(pos + this.columnOffset) : this.rs.getDate(pos + this.columnOffset, timezone);
            if (date == null || mapNull && date.equals(DateHelper.MIN_DATE)) {
                return null;
            }
            return new Date(date.getTime());
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Date getDate(int pos, boolean mapNull) {
        return this.getDate(pos, null, mapNull);
    }

    public Date getDate(int pos, Calendar timezone) {
        return this.getDate(pos, timezone, false);
    }

    public Date getDate(int pos) {
        return this.getDate(pos, null, false);
    }

    public org.tentackle.common.Timestamp getTimestamp(int pos, Calendar timezone, boolean mapNull) {
        try {
            Timestamp ts;
            Timestamp timestamp = ts = timezone == null ? this.rs.getTimestamp(pos + this.columnOffset) : this.rs.getTimestamp(pos + this.columnOffset, timezone);
            if (ts == null || mapNull && ts.equals((Timestamp)DateHelper.MIN_TIMESTAMP)) {
                return null;
            }
            org.tentackle.common.Timestamp tts = new org.tentackle.common.Timestamp(ts.getTime());
            tts.setNanos(ts.getNanos());
            return tts;
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public org.tentackle.common.Timestamp getTimestamp(int pos, boolean mapNull) {
        return this.getTimestamp(pos, null, mapNull);
    }

    public org.tentackle.common.Timestamp getTimestamp(int pos, Calendar timezone) {
        return this.getTimestamp(pos, timezone, false);
    }

    public org.tentackle.common.Timestamp getTimestamp(int pos) {
        return this.getTimestamp(pos, null, false);
    }

    public Time getTime(int pos, Calendar timezone) {
        try {
            java.sql.Time time = timezone == null ? this.rs.getTime(pos + this.columnOffset) : this.rs.getTime(pos + this.columnOffset, timezone);
            return time == null ? null : new Time(time.getTime());
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Time getTime(int pos) {
        return this.getTime(pos, null);
    }

    public Binary<?> getBinary(int pos, int bufSize) {
        try {
            return Binary.createBinary((InputStream)this.rs.getBinaryStream(pos + this.columnOffset), (int)bufSize);
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public String getString(boolean mapNull) {
        try {
            String str = this.rs.getString(this.nextConfiguredIndex() + this.columnOffset);
            if (mapNull && str != null && str.equals(this.db.getBackend().getEmptyString())) {
                return null;
            }
            return str;
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public String getString() {
        return this.getString(this.nextConfiguredIndex(), false);
    }

    public boolean getBoolean() {
        try {
            return this.rs.getBoolean(this.nextConfiguredIndex() + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Boolean getABoolean() {
        boolean value = this.getBoolean(this.nextConfiguredIndex());
        return this.wasNull() ? null : Boolean.valueOf(value);
    }

    public float getFloat() {
        try {
            return this.rs.getFloat(this.nextConfiguredIndex() + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Float getAFloat() {
        float value = this.getFloat(this.nextConfiguredIndex());
        return this.wasNull() ? null : Float.valueOf(value);
    }

    public double getDouble() {
        try {
            return this.rs.getDouble(this.nextConfiguredIndex() + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Double getADouble() {
        double value = this.getDouble(this.nextConfiguredIndex());
        return this.wasNull() ? null : Double.valueOf(value);
    }

    public BigDecimal getBigDecimal() {
        try {
            return this.rs.getBigDecimal(this.nextConfiguredIndex() + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public BMoney getBMoney() {
        double value = this.getDouble(this.nextConfiguredIndex());
        return this.wasNull() ? null : new BMoney(value, this.getInt(this.nextConfiguredIndex()));
    }

    public DMoney getDMoney() {
        BigDecimal value = this.getBigDecimal(this.nextConfiguredIndex());
        return this.wasNull() ? null : new DMoney(value.movePointLeft(this.getInt(this.nextConfiguredIndex())));
    }

    public byte getByte() {
        try {
            return this.rs.getByte(this.nextConfiguredIndex() + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Byte getAByte() {
        byte value = this.getByte(this.nextConfiguredIndex());
        return this.wasNull() ? null : Byte.valueOf(value);
    }

    public char getChar() {
        try {
            String val = this.rs.getString(this.nextConfiguredIndex() + this.columnOffset);
            return val == null || val.length() == 0 ? (char)'\u0000' : val.charAt(0);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Character getCharacter(boolean mapNull) {
        char value = this.getChar(this.nextConfiguredIndex());
        return this.wasNull() ? null : (mapNull && value == ' ' ? null : Character.valueOf(value));
    }

    public Character getCharacter() {
        return this.getCharacter(this.nextConfiguredIndex(), false);
    }

    public short getShort() {
        try {
            return this.rs.getShort(this.nextConfiguredIndex() + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Short getAShort() {
        short value = this.getShort(this.nextConfiguredIndex());
        return this.wasNull() ? null : Short.valueOf(value);
    }

    public int getInt() {
        try {
            return this.rs.getInt(this.nextConfiguredIndex() + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Integer getInteger() {
        int value = this.getInt(this.nextConfiguredIndex());
        return this.wasNull() ? null : Integer.valueOf(value);
    }

    public long getLong() {
        try {
            return this.rs.getLong(this.nextConfiguredIndex() + this.columnOffset);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Long getALong() {
        long value = this.getLong(this.nextConfiguredIndex());
        return this.wasNull() ? null : Long.valueOf(value);
    }

    public Date getDate(Calendar timezone, boolean mapNull) {
        try {
            java.sql.Date date;
            int pos = this.nextConfiguredIndex();
            java.sql.Date date2 = date = timezone == null ? this.rs.getDate(pos + this.columnOffset) : this.rs.getDate(pos + this.columnOffset, timezone);
            if (date == null || mapNull && date.equals(DateHelper.MIN_DATE)) {
                return null;
            }
            return new Date(date.getTime());
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Date getDate(boolean mapNull) {
        return this.getDate(this.nextConfiguredIndex(), null, mapNull);
    }

    public Date getDate(Calendar timezone) {
        return this.getDate(this.nextConfiguredIndex(), timezone, false);
    }

    public Date getDate() {
        return this.getDate(this.nextConfiguredIndex(), null, false);
    }

    public org.tentackle.common.Timestamp getTimestamp(Calendar timezone, boolean mapNull) {
        try {
            Timestamp ts;
            int pos = this.nextConfiguredIndex();
            Timestamp timestamp = ts = timezone == null ? this.rs.getTimestamp(pos + this.columnOffset) : this.rs.getTimestamp(pos + this.columnOffset, timezone);
            if (ts == null || mapNull && ts.equals((Timestamp)DateHelper.MIN_TIMESTAMP)) {
                return null;
            }
            org.tentackle.common.Timestamp tts = new org.tentackle.common.Timestamp(ts.getTime());
            tts.setNanos(ts.getNanos());
            return tts;
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public org.tentackle.common.Timestamp getTimestamp(boolean mapNull) {
        return this.getTimestamp(this.nextConfiguredIndex(), null, mapNull);
    }

    public org.tentackle.common.Timestamp getTimestamp(Calendar timezone) {
        return this.getTimestamp(this.nextConfiguredIndex(), timezone, false);
    }

    public org.tentackle.common.Timestamp getTimestamp() {
        return this.getTimestamp(this.nextConfiguredIndex(), null, false);
    }

    public Time getTime(Calendar timezone) {
        try {
            int pos = this.nextConfiguredIndex();
            java.sql.Time time = timezone == null ? this.rs.getTime(pos + this.columnOffset) : this.rs.getTime(pos + this.columnOffset, timezone);
            return time == null ? null : new Time(time.getTime());
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    public Time getTime() {
        return this.getTime(this.nextConfiguredIndex(), null);
    }

    public Binary<?> getBinary(int bufSize) {
        try {
            return Binary.createBinary((InputStream)this.rs.getBinaryStream(this.nextConfiguredIndex() + this.columnOffset), (int)bufSize);
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Session)this.db, (Throwable)e);
        }
    }

    private void clearSection() {
        if (this.rs == null) {
            throw new PersistenceException("result set already closed");
        }
        this.currentSection = null;
        if (this.isInSkipMode()) {
            this.cursorMovedInSkipMode = true;
        }
    }

    private int nextConfiguredIndex() {
        this.assertValidSection();
        return this.currentSection.nextColumnIndex();
    }

    private void assertValidSection() {
        if (this.currentSection == null) {
            throw new PersistenceException((Session)this.db, "no current section configured for automatic indexed retrieval");
        }
    }

    private void assertInSkipMode() {
        if (!this.isInSkipMode()) {
            throw new PersistenceException((Session)this.db, "result set is not in skipmode");
        }
    }
}

