/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.util.HashSet;
import java.util.Set;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.ResultSetWrapper;

public class ResultSetSection {
    private final ResultSetWrapper rs;
    private final Object key;
    private Set<String> configuredNames;
    private int[] configuredOffsets;
    private int columnIndex;

    public ResultSetSection(ResultSetWrapper rs, Object key) {
        this.rs = rs;
        this.key = key;
    }

    public Object getKey() {
        return this.key;
    }

    public void configureColumn(String name) {
        int ndx;
        if (this.configuredNames == null) {
            this.configuredNames = new HashSet<String>();
            this.configuredOffsets = new int[this.rs.getColumnCount()];
        }
        if ((ndx = this.configuredNames.size()) >= this.configuredOffsets.length) {
            throw new PersistenceException((Session)this.rs.getSession(), "more columns configured than in result set (" + this.configuredOffsets.length + ")");
        }
        this.configuredOffsets[ndx] = this.rs.findColumn(name);
        if (!this.configuredNames.add(name)) {
            throw new PersistenceException((Session)this.rs.getSession(), "column '" + name + "' already configured");
        }
    }

    public void resetColumnIndex() {
        this.columnIndex = 0;
    }

    public int nextColumnIndex() {
        if (this.configuredOffsets == null) {
            throw new PersistenceException((Session)this.rs.getSession(), "no columns configured for automatic indexed retrieval");
        }
        if (this.columnIndex >= this.configuredNames.size()) {
            throw new PersistenceException((Session)this.rs.getSession(), "more columns retrieved than configured (" + this.configuredNames.size() + ")");
        }
        return this.configuredOffsets[this.columnIndex++];
    }
}

