/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.tentackle.misc.ScrollableResource;
import org.tentackle.pdo.AbstractPersistentObject;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.JoinedSelect;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.Session;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.rmi.RemoteResultSetCursor;

public class ResultSetCursor<T extends PersistentDomainObject<T>>
implements ScrollableResource<T> {
    private final T pdoProxy;
    private final ResultSetWrapper rs;
    private final JoinedSelect<T> js;
    private final RemoteResultSetCursor<T> remoteCursor;
    private final Session session;
    private final DomainContext context;
    private int row;
    private boolean firstInvoked;
    private boolean noNext;
    private boolean eof;
    private boolean closed;

    public ResultSetCursor(T pdo, ResultSetWrapper rs, JoinedSelect<T> js) {
        this.pdoProxy = pdo;
        this.rs = rs;
        this.js = js;
        if (js != null) {
            js.initialize(null);
        }
        this.context = pdo.getDomainContext();
        this.session = this.context.getSession();
        this.remoteCursor = null;
        this.assertSessionIsLocal();
        ((AbstractPersistentObject)pdo.getPersistenceDelegate()).assertRootContextIsAccepted();
    }

    public ResultSetCursor(T pdo, ResultSetWrapper rs) {
        this(pdo, rs, null);
    }

    public ResultSetCursor(DomainContext context, RemoteResultSetCursor<T> remoteCursor) {
        this.context = context;
        this.remoteCursor = remoteCursor;
        this.session = context.getSession();
        this.pdoProxy = null;
        this.rs = null;
        this.js = null;
        this.assertSessionIsRemote();
    }

    public ResultSetWrapper getResultSet() {
        this.assertSessionIsLocal();
        return this.rs;
    }

    public JoinedSelect<T> getJoinedSelect() {
        this.assertSessionIsLocal();
        return this.js;
    }

    public RemoteResultSetCursor<T> getRemoteCursor() {
        this.assertSessionIsRemote();
        return this.remoteCursor;
    }

    public Session getSession() {
        return this.session;
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    public void close() {
        if (!this.closed) {
            if (this.session.isRemote()) {
                try {
                    this.remoteCursor.close();
                }
                catch (RemoteException ex) {
                    throw new PersistenceException(this.session, (Throwable)ex);
                }
            } else {
                this.rs.close();
            }
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getRow() {
        return this.row;
    }

    public boolean setRow(int row) {
        if (row < 0) {
            throw new PersistenceException(this.session, "invalid row " + row);
        }
        if (this.session.isRemote()) {
            try {
                this.row = this.remoteCursor.setRow(row);
                return this.row == row;
            }
            catch (RemoteException ex) {
                throw new PersistenceException(this.session, (Throwable)ex);
            }
        }
        this.assertNoJoins();
        boolean rv = this.rs.absolute(row);
        this.row = rv ? row : this.rs.getRow();
        this.firstInvoked = false;
        return rv;
    }

    public boolean first() {
        if (this.session.isRemote()) {
            try {
                boolean rv = this.remoteCursor.first();
                this.row = rv ? 1 : 0;
                return rv;
            }
            catch (RemoteException ex) {
                throw new PersistenceException(this.session, (Throwable)ex);
            }
        }
        boolean rv = false;
        if (this.js != null) {
            this.js.initialize(null);
            this.eof = false;
            this.noNext = true;
        }
        if (this.row == 0) {
            rv = this.next();
        } else if (this.row == 1) {
            rv = true;
        } else if (this.rs.first()) {
            this.row = 1;
            rv = true;
        } else {
            this.row = 0;
        }
        this.firstInvoked = rv;
        return rv;
    }

    public boolean last() {
        if (this.session.isRemote()) {
            try {
                this.row = this.remoteCursor.last();
                return this.row > 0;
            }
            catch (RemoteException ex) {
                throw new PersistenceException(this.session, (Throwable)ex);
            }
        }
        this.assertNoJoins();
        boolean rv = false;
        if (this.rs.last()) {
            this.row = this.rs.getRow();
            rv = true;
        } else {
            this.row = 0;
        }
        this.firstInvoked = false;
        return rv;
    }

    public boolean next() {
        boolean rv;
        if (this.session.isRemote()) {
            try {
                boolean rv2 = this.remoteCursor.next();
                if (rv2) {
                    ++this.row;
                }
                return rv2;
            }
            catch (RemoteException ex) {
                throw new PersistenceException(this.session, (Throwable)ex);
            }
        }
        if (this.eof) {
            rv = false;
        } else if (this.noNext) {
            this.noNext = false;
            rv = true;
        } else {
            rv = this.rs.next();
            if (rv) {
                ++this.row;
            }
        }
        this.firstInvoked = false;
        return rv;
    }

    public boolean previous() {
        if (this.session.isRemote()) {
            try {
                boolean rv = this.remoteCursor.previous();
                if (rv) {
                    --this.row;
                }
                return rv;
            }
            catch (RemoteException ex) {
                throw new PersistenceException(this.session, (Throwable)ex);
            }
        }
        this.assertNoJoins();
        boolean rv = this.rs.previous();
        if (rv) {
            --this.row;
        }
        this.firstInvoked = false;
        return rv;
    }

    public boolean scroll(int rows) {
        if (this.session.isRemote()) {
            try {
                int expectedRow = this.row + rows;
                this.row = this.remoteCursor.scroll(rows);
                return this.row == expectedRow;
            }
            catch (RemoteException ex) {
                throw new PersistenceException(this.session, (Throwable)ex);
            }
        }
        return this.setRow(this.row + rows);
    }

    public void beforeFirst() {
        if (this.session.isRemote()) {
            try {
                this.remoteCursor.beforeFirst();
                this.row = 0;
                return;
            }
            catch (RemoteException ex) {
                throw new PersistenceException(this.session, (Throwable)ex);
            }
        }
        if (this.js != null) {
            this.js.initialize(null);
            this.eof = false;
            this.noNext = true;
        }
        this.rs.beforeFirst();
        this.row = 0;
        this.firstInvoked = false;
    }

    public void afterLast() {
        if (this.session.isRemote()) {
            try {
                this.row = this.remoteCursor.afterLast();
                return;
            }
            catch (RemoteException ex) {
                throw new PersistenceException(this.session, (Throwable)ex);
            }
        }
        this.assertNoJoins();
        this.rs.afterLast();
        this.row = this.rs.getRow();
        this.firstInvoked = false;
    }

    public boolean isBeforeFirst() {
        if (this.session.isRemote()) {
            return this.row == 0;
        }
        return this.rs.isBeforeFirst();
    }

    public boolean isAfterLast() {
        if (this.session.isRemote()) {
            try {
                return this.remoteCursor.isAfterLast();
            }
            catch (RemoteException ex) {
                throw new PersistenceException(this.session, (Throwable)ex);
            }
        }
        return this.rs.isAfterLast();
    }

    public T get() {
        if (this.row > 0) {
            T pdo;
            block8: {
                if (this.session.isRemote()) {
                    try {
                        PersistentDomainObject obj = (PersistentDomainObject)this.remoteCursor.get();
                        this.configureRemoteObject(obj);
                        return (T)obj;
                    }
                    catch (RemoteException ex) {
                        throw new PersistenceException(this.session, (Throwable)ex);
                    }
                }
                if (this.js == null) {
                    PersistentDomainObject pdo2 = Pdo.create(this.pdoProxy);
                    AbstractPersistentObject po = (AbstractPersistentObject)pdo2.getPersistenceDelegate();
                    return (T)po.derivePdoFromPo(pdo2, po.readFromResultSetWrapper(this.rs));
                }
                pdo = this.js.currentPdo();
                while (true) {
                    if (!this.firstInvoked && !this.next()) {
                        this.eof = true;
                        break block8;
                    }
                    this.noNext = false;
                    ((AbstractPersistentObject)this.pdoProxy.getPersistenceDelegate()).readJoinedRow(this.rs, this.js);
                    if (pdo == null) {
                        pdo = this.js.currentPdo();
                        continue;
                    }
                    if (pdo != this.js.currentPdo()) break;
                }
                this.noNext = true;
            }
            return pdo;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<T> toList() {
        List<Object> list;
        if (this.session.isRemote()) {
            try {
                list = this.remoteCursor.toList();
                if (list == null) return list;
                for (PersistentDomainObject persistentDomainObject : list) {
                    this.configureRemoteObject(persistentDomainObject);
                }
                return list;
            }
            catch (RemoteException ex) {
                throw PersistenceException.createFromRemoteException((Object)this.session, (RemoteException)ex);
            }
        } else {
            list = new ArrayList();
            this.toList(list);
        }
        return list;
    }

    public List<T> toListAndClose() {
        List<T> list = this.toList();
        this.close();
        return list;
    }

    public void setFetchSize(int rows) {
        if (this.session.isRemote()) {
            try {
                this.remoteCursor.setFetchSize(rows);
            }
            catch (RemoteException ex) {
                throw PersistenceException.createFromRemoteException((Object)this.session, (RemoteException)ex);
            }
        } else {
            this.rs.setFetchSize(rows);
        }
    }

    public int getFetchSize() {
        if (this.session.isRemote()) {
            try {
                return this.remoteCursor.getFetchSize();
            }
            catch (RemoteException ex) {
                throw PersistenceException.createFromRemoteException((Object)this.session, (RemoteException)ex);
            }
        }
        return this.rs.getFetchSize();
    }

    public void setFetchDirection(int direction) {
        this.rs.setFetchDirection(direction);
    }

    public int getFetchDirection() {
        return this.rs.getFetchDirection();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FetchList<T> fetch() {
        FetchList<T> list;
        block11: {
            T obj;
            list = null;
            if (this.closed) return list;
            if (this.session.isRemote()) {
                try {
                    list = this.remoteCursor.fetch();
                    if (list != null) {
                        for (PersistentDomainObject obj2 : list) {
                            this.configureRemoteObject(obj2);
                        }
                        this.row += list.size();
                        if (this.firstInvoked) {
                            this.firstInvoked = false;
                            --this.row;
                        }
                        if (!list.closed) return list;
                        this.closed = true;
                        return list;
                    }
                    this.closed = true;
                    return list;
                }
                catch (RemoteException ex) {
                    throw PersistenceException.createFromRemoteException((Object)this.session, (RemoteException)ex);
                }
            }
            int fetchMax = this.getFetchSize();
            if (fetchMax < 1) {
                list = new FetchList();
                this.toList(list);
                list.closed = true;
                this.close();
                return list;
            }
            list = new FetchList();
            if (this.firstInvoked && this.row == 1) {
                obj = this.get();
                if (obj != null) {
                    list.add(obj);
                }
                this.firstInvoked = false;
            }
            fetchMax = this.row / fetchMax * fetchMax + fetchMax;
            while (this.row < fetchMax) {
                if (this.next()) {
                    obj = this.get();
                    if (obj == null) continue;
                    list.add(obj);
                    continue;
                }
                break block11;
            }
            return list;
        }
        this.close();
        list.closed = true;
        if (!list.isEmpty()) return list;
        return null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected void toList(List<T> list) {
        boolean exists = this.first();
        while (exists) {
            T obj = this.get();
            if (obj != null) {
                list.add(obj);
            }
            exists = this.next();
        }
    }

    protected void configureRemoteObject(T pdo) {
        if (this.context != null) {
            AbstractPersistentObject po = (AbstractPersistentObject)pdo.getPersistenceDelegate();
            po.configureRemoteObject(this.context, pdo);
        } else if (pdo != null) {
            this.session.applyTo(pdo);
        }
    }

    protected void assertSessionIsRemote() {
        if (!this.session.isRemote()) {
            throw new PersistenceException(this.session, "operation not allowed for local sessions");
        }
    }

    protected void assertSessionIsLocal() {
        if (this.session.isRemote()) {
            throw new PersistenceException(this.session, "operation not allowed for remote sessions");
        }
    }

    protected void assertNoJoins() {
        if (this.js != null) {
            throw new PersistenceException(this.session, "operation not allowed for cursors with joins");
        }
    }

    public static class FetchList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = 1L;
        boolean closed;
    }
}

