/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.tentackle.common.ServiceFactory;
import org.tentackle.log.Logger;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextDependable;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.RemoteSession;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.persist.rmi.RemoteDbSession;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.SecurityManager;
import org.tentackle.security.SecurityResult;

public class RemoteSessionAdapter
implements RemoteSession {
    private final RemoteDbSession rs;

    public RemoteSessionAdapter(RemoteDbSession rs) {
        this.rs = rs;
    }

    public RemoteDbSession getRemoteDbSession() {
        return this.rs;
    }

    public SessionInfo getClientSessionInfo() {
        try {
            return this.rs.getClientSessionInfo();
        }
        catch (RemoteException rex) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)rex);
        }
    }

    public String getServerName() {
        try {
            return this.rs.getServerName();
        }
        catch (RemoteException rex) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)rex);
        }
    }

    public void log(Logger.Level level, String message) {
        try {
            this.rs.log(level, message);
        }
        catch (RemoteException rex) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)rex);
        }
    }

    public void logStatistics(Logger.Level level, boolean clear) {
        try {
            this.rs.logStatistics(level, clear);
        }
        catch (RemoteException rex) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)rex);
        }
    }

    public <T extends DomainContextDependable> T getExtension(DomainContext context, Class<T> extIf) {
        SecurityFactory sf = SecurityFactory.getInstance();
        SecurityManager sm = sf.getSecurityManager();
        SecurityResult sr = sm.evaluate(context, (Permission)sf.getExecutePermission(), extIf);
        if (!sr.isAccepted()) {
            throw new SecurityException(sr.explain("no execute permission for " + extIf.getName()));
        }
        DomainContextDependable adapter = (DomainContextDependable)ServiceFactory.createService(extIf);
        try {
            Method m = adapter.getClass().getMethod("setDomainContext", DomainContext.class);
            m.invoke((Object)adapter, context);
            return (T)adapter;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new PersistenceException("could not create adapter for " + extIf, (Throwable)ex);
        }
    }
}

