/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.tentackle.common.BMoney;
import org.tentackle.common.Binary;
import org.tentackle.common.DMoney;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.Convertible;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.persist.Db;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementKey;
import org.tentackle.sql.BackendPreparedStatement;

public class Query {
    private static final Logger LOGGER = LoggerFactory.getLogger(Query.class);
    private final List<QueryItem> items = new ArrayList<QueryItem>();
    private int fetchSize;
    private int maxRows;
    private int offset;
    private int limit;
    private boolean statementCached;

    public void setStatementCached(boolean statementCached) {
        this.statementCached = statementCached;
    }

    public boolean isStatementCached() {
        return this.statementCached;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void add(String sql, Object ... data) {
        this.items.add(new QueryItem(sql, data));
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public ResultSetWrapper execute(Db db, int resultSetType, int resultSetConcurrency) {
        PreparedStatementWrapper st;
        String sql = this.createSql(db);
        if (this.statementCached) {
            StatementKey key = this.createStatementKey(sql);
            st = db.getPreparedStatement(key, false, resultSetType, resultSetConcurrency, () -> sql);
        } else {
            st = db.createPreparedStatement(sql, resultSetType, resultSetConcurrency);
        }
        this.apply(db, st);
        if (this.fetchSize != 0) {
            st.setFetchSize(this.fetchSize);
        }
        if (this.maxRows != 0) {
            st.setMaxRows(this.maxRows);
        }
        ResultSetWrapper rs = null;
        try {
            rs = db.getBackend().needTxForFetchsize() && this.fetchSize != 0 && resultSetType == 1003 && resultSetConcurrency == 1007 ? st.executeQuery(true) : st.executeQuery();
            if (!this.statementCached) {
                rs.setCloseStatementOnclose(true);
            }
        }
        catch (RuntimeException ex) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (RuntimeException rex) {
                    LOGGER.warning("closing resultset failed: " + rex.getMessage(), new Object[0]);
                }
            }
            try {
                st.consume();
            }
            catch (RuntimeException rex) {
                LOGGER.warning("marking statement consumed failed: " + rex.getMessage(), new Object[0]);
            }
            if (!st.isClosed()) {
                try {
                    st.close();
                }
                catch (RuntimeException rex) {
                    LOGGER.warning("closing statement failed: " + rex.getMessage(), new Object[0]);
                }
            }
            throw ex;
        }
        return rs;
    }

    public ResultSetWrapper execute(Db db, int resultSetType) {
        return this.execute(db, resultSetType, 1007);
    }

    public ResultSetWrapper execute(Db db) {
        return this.execute(db, 1003, 1007);
    }

    public int getRowCount(Db db) {
        StringBuilder buf = this.buildInnerSql();
        buf.insert(0, "SELECT COUNT(*) FROM (");
        buf.append(')');
        if (db.getBackend().needAliasForSubselect()) {
            buf.append(" AS F_O_O");
        }
        int count = 0;
        try (PreparedStatementWrapper st = db.createPreparedStatement(buf.toString());){
            this.applyParameters(st, 1);
            try (ResultSetWrapper rs = st.executeQuery();){
                if (rs.next()) {
                    count = rs.getInt(1);
                }
            }
        }
        return count;
    }

    public void apply(Db db, PreparedStatementWrapper st) {
        int ndx = db.getBackend().setLeadingSelectParameters((BackendPreparedStatement)st, this.limit, this.offset);
        ndx = this.applyParameters(st, ndx);
        db.getBackend().setTrailingSelectParameters((BackendPreparedStatement)st, ndx, this.limit, this.offset);
    }

    public int applyParameters(PreparedStatementWrapper st, int ndx) {
        for (QueryItem item : this.items) {
            if (item.data == null) continue;
            for (int dataIndex = 0; dataIndex < item.data.length; ++dataIndex) {
                Object data = item.data[dataIndex];
                if (data instanceof Convertible) {
                    data = ((Convertible)data).toExternal();
                }
                if (data instanceof Number) {
                    if (data instanceof DMoney) {
                        st.setDMoney(ndx, (DMoney)data);
                        ndx += 2;
                        continue;
                    }
                    if (data instanceof BMoney) {
                        st.setBMoney(ndx, (BMoney)data);
                        ndx += 2;
                        continue;
                    }
                    if (data instanceof Double) {
                        st.setDouble(ndx++, (Double)data);
                        continue;
                    }
                    if (data instanceof Float) {
                        st.setFloat(ndx++, (Float)data);
                        continue;
                    }
                    if (data instanceof Long) {
                        st.setLong(ndx++, (Long)data);
                        continue;
                    }
                    if (data instanceof Integer) {
                        st.setInteger(ndx++, (Integer)data);
                        continue;
                    }
                    if (data instanceof Short) {
                        st.setShort(ndx++, (Short)data);
                        continue;
                    }
                    if (data instanceof Byte) {
                        st.setByte(ndx++, (Byte)data);
                        continue;
                    }
                    if (!(data instanceof BigDecimal)) continue;
                    st.setBigDecimal(ndx++, (BigDecimal)data);
                    continue;
                }
                if (data instanceof String) {
                    st.setString(ndx++, (String)data);
                    continue;
                }
                if (data instanceof Character) {
                    st.setChar(ndx++, ((Character)data).charValue());
                    continue;
                }
                if (data instanceof Boolean) {
                    st.setBoolean(ndx++, (Boolean)data);
                    continue;
                }
                if (data instanceof Timestamp) {
                    st.setTimestamp(ndx++, (Timestamp)data);
                    continue;
                }
                if (data instanceof Date) {
                    st.setDate(ndx++, (Date)data);
                    continue;
                }
                if (data instanceof Time) {
                    st.setTime(ndx++, (Time)data);
                    continue;
                }
                if (data instanceof Binary) {
                    st.setBinary(ndx++, (Binary)data);
                    continue;
                }
                if (data == null) {
                    throw new PersistenceException("null value in '" + item + "' arg[" + dataIndex + "]");
                }
                throw new PersistenceException("unsupported type " + data.getClass() + " in '" + item + "' arg[" + dataIndex + "]");
            }
        }
        return ndx;
    }

    public String createSql(Db db) {
        StringBuilder sql = this.buildInnerSql();
        db.getBackend().buildSelectSql(sql, false, this.limit, this.offset);
        return sql.toString();
    }

    public StatementKey createStatementKey(String sql) {
        return new StatementKey(sql);
    }

    public StringBuilder buildInnerSql() {
        StringBuilder buf = new StringBuilder();
        for (QueryItem item : this.items) {
            buf.append(item.sql);
        }
        return buf;
    }

    private static class QueryItem {
        private final String sql;
        private final Object[] data;

        private QueryItem(String sql, Object ... data) {
            this.sql = sql;
            this.data = data;
        }

        public String toString() {
            return this.sql;
        }
    }
}

