/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.tentackle.common.BMoney;
import org.tentackle.common.Binary;
import org.tentackle.common.DMoney;
import org.tentackle.misc.DateHelper;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.Db;
import org.tentackle.persist.ManagedConnection;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementKey;
import org.tentackle.persist.StatementWrapper;
import org.tentackle.sql.BackendPreparedStatement;

public class PreparedStatementWrapper
extends StatementWrapper
implements BackendPreparedStatement {
    private final StatementKey statementKey;
    private int columnOffset;
    private Map<Integer, Object> parameters;

    public PreparedStatementWrapper(ManagedConnection con, PreparedStatement stmt, StatementKey statementKey, String sql) {
        super(con, stmt);
        this.statementKey = statementKey;
        this.sql = sql;
        Db db = this.getAttachedSession();
        if (db.getFetchSize() != 0) {
            this.setFetchSize(db.getFetchSize());
        }
        if (db.getMaxRows() != 0) {
            this.setMaxRows(db.getMaxRows());
        }
        this.parameters = new HashMap<Integer, Object>();
    }

    @Override
    public String toString() {
        String s2;
        String s1 = super.toString();
        if (s1.equals(s2 = "{ " + this.getSql() + " }")) {
            return s1;
        }
        return s2 + " -> " + s1;
    }

    @Override
    public void close() {
        super.close();
        this.con.removePreparedStatement(this);
    }

    @Override
    public PreparedStatement getStatement() {
        return (PreparedStatement)this.stmt;
    }

    public StatementKey getStatementKey() {
        return this.statementKey;
    }

    public void setColumnOffset(int columnOffset) {
        this.columnOffset = columnOffset;
    }

    public int getColumnOffset() {
        return this.columnOffset;
    }

    protected int effectivePosition(int p) {
        return this.columnOffset + p;
    }

    protected void rememberParameter(int p, Object value) {
        this.parameters.put(p, value);
    }

    @Override
    protected void detachSession() {
        super.detachSession();
        this.parameters = new HashMap<Integer, Object>();
    }

    public void clearParameters() {
        try {
            this.getStatement().clearParameters();
            this.parameters.clear();
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public Object getParameter(int p) {
        return this.parameters.get(this.effectivePosition(p));
    }

    public Map<Integer, Object> getParameters() {
        return this.parameters;
    }

    @Override
    protected int executeUpdateImpl(String sql) throws SQLException {
        return this.getStatement().executeUpdate();
    }

    public int executeUpdate() {
        return super.executeUpdate(null);
    }

    @Override
    protected ResultSet executeQueryImpl(String sql) throws SQLException {
        return this.getStatement().executeQuery();
    }

    public ResultSetWrapper executeQuery(boolean withinTx) {
        return super.executeQuery(null, withinTx);
    }

    public ResultSetWrapper executeQuery() {
        return this.executeQuery(false);
    }

    public void setNull(int p, int type) {
        try {
            int ep = this.effectivePosition(p);
            this.getStatement().setNull(ep, type);
            this.rememberParameter(ep, null);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setString(int p, String s, boolean mapNull) {
        try {
            int ep = this.effectivePosition(p);
            if (s == null) {
                if (mapNull) {
                    s = this.getAttachedSession().getBackend().getEmptyString();
                    this.getStatement().setString(ep, s);
                } else {
                    this.getStatement().setNull(ep, 12);
                }
            } else {
                this.getStatement().setString(ep, s);
            }
            this.rememberParameter(ep, s);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setString(int p, String s) {
        this.setString(p, s, false);
    }

    public void setBoolean(int p, boolean b) {
        try {
            int ep = this.effectivePosition(p);
            this.getStatement().setBoolean(ep, b);
            this.rememberParameter(ep, b);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setBoolean(int p, Boolean b) {
        if (b == null) {
            this.setNull(p, -7);
        } else {
            this.setBoolean(p, (boolean)b);
        }
    }

    public void setByte(int p, byte b) {
        try {
            int ep = this.effectivePosition(p);
            this.getStatement().setByte(ep, b);
            this.rememberParameter(ep, b);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setByte(int p, Byte b) {
        if (b == null) {
            this.setNull(p, -6);
        } else {
            this.setByte(p, (byte)b);
        }
    }

    public void setChar(int p, char c) {
        try {
            int ep = this.effectivePosition(p);
            this.getStatement().setString(ep, String.valueOf(c));
            this.rememberParameter(ep, Character.valueOf(c));
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setCharacter(int p, Character c, boolean mapNull) {
        if (c == null) {
            if (mapNull) {
                this.setChar(p, ' ');
            } else {
                this.setNull(p, 1);
            }
        } else {
            this.setChar(p, c.charValue());
        }
    }

    public void setCharacter(int p, Character c) {
        this.setCharacter(p, c, false);
    }

    public void setShort(int p, short s) {
        try {
            int ep = this.effectivePosition(p);
            this.getStatement().setShort(ep, s);
            this.rememberParameter(ep, s);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setShort(int p, Short s) {
        if (s == null) {
            this.setNull(p, 5);
        } else {
            this.setShort(p, (short)s);
        }
    }

    public void setInt(int p, int i) {
        try {
            int ep = this.effectivePosition(p);
            this.getStatement().setInt(ep, i);
            this.rememberParameter(ep, i);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setInteger(int p, Integer i) {
        if (i == null) {
            this.setNull(p, 4);
        } else {
            this.setInt(p, i);
        }
    }

    public void setLong(int p, long l) {
        if (this.getAttachedSession().getBackend().needSetLongWorkaround()) {
            this.setInt(p, (int)l);
        } else {
            try {
                int ep = this.effectivePosition(p);
                this.getStatement().setLong(ep, l);
                this.rememberParameter(ep, l);
            }
            catch (SQLException e) {
                throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
            }
        }
    }

    public void setLong(int p, Long l) {
        if (l == null) {
            this.setNull(p, -5);
        } else {
            this.setLong(p, (long)l);
        }
    }

    public void setFloat(int p, float f) {
        try {
            int ep = this.effectivePosition(p);
            this.getStatement().setFloat(ep, f);
            this.rememberParameter(ep, Float.valueOf(f));
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setFloat(int p, Float f) {
        if (f == null) {
            this.setNull(p, 6);
        } else {
            this.setFloat(p, f.floatValue());
        }
    }

    public void setDouble(int p, double d) {
        try {
            int ep = this.effectivePosition(p);
            this.getStatement().setDouble(ep, d);
            this.rememberParameter(ep, d);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setDouble(int p, Double d) {
        if (d == null) {
            this.setNull(p, 8);
        } else {
            this.setDouble(p, (double)d);
        }
    }

    public void setBigDecimal(int p, BigDecimal d) {
        if (d == null) {
            this.setNull(p, 3);
        } else {
            try {
                int ep = this.effectivePosition(p);
                this.getStatement().setBigDecimal(ep, d);
                this.rememberParameter(ep, d);
            }
            catch (SQLException e) {
                throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
            }
        }
    }

    public void setBMoney(int p, BMoney m) {
        try {
            int ep = this.effectivePosition(p);
            if (m == null) {
                this.getStatement().setNull(ep, 8);
                this.getStatement().setNull(ep + 1, 4);
                this.rememberParameter(ep, null);
                this.rememberParameter(ep + 1, null);
            } else {
                double d = m.doubleValue();
                int s = m.scale();
                this.getStatement().setDouble(ep, d);
                this.getStatement().setInt(ep + 1, s);
                this.rememberParameter(ep, d);
                this.rememberParameter(ep + 1, s);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setDMoney(int p, DMoney m) {
        try {
            int ep = this.effectivePosition(p);
            if (m == null) {
                this.getStatement().setNull(ep, 3);
                this.getStatement().setNull(ep + 1, 4);
                this.rememberParameter(ep, null);
                this.rememberParameter(ep + 1, null);
            } else {
                int s = m.scale();
                BigDecimal d = m.movePointRight(s);
                this.getStatement().setBigDecimal(ep, d);
                this.getStatement().setInt(ep + 1, s);
                this.rememberParameter(ep, d);
                this.rememberParameter(ep + 1, s);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setDate(int p, Date d, Calendar timezone, boolean mapNull) {
        try {
            int ep = this.effectivePosition(p);
            if (d == null && mapNull) {
                d = DateHelper.MIN_DATE;
            }
            if (d == null) {
                this.getStatement().setNull(ep, 91);
            } else if (timezone == null) {
                this.getStatement().setDate(ep, d);
            } else {
                this.getStatement().setDate(ep, d, timezone);
            }
            this.rememberParameter(ep, d);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setDate(int p, Date d, Calendar timezone) {
        this.setDate(p, d, timezone, false);
    }

    public void setDate(int p, Date d, boolean mapNull) {
        this.setDate(p, d, null, mapNull);
    }

    public void setDate(int p, Date d) {
        this.setDate(p, d, null, false);
    }

    public void setTimestamp(int p, Timestamp ts, Calendar timezone, boolean mapNull) {
        try {
            int ep = this.effectivePosition(p);
            if (ts == null && mapNull) {
                ts = DateHelper.MIN_TIMESTAMP;
            }
            if (ts == null) {
                this.getStatement().setNull(ep, 93);
            } else if (timezone == null) {
                this.getStatement().setTimestamp(ep, ts);
            } else {
                this.getStatement().setTimestamp(ep, ts, timezone);
            }
            this.rememberParameter(ep, ts);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setTimestamp(int p, Timestamp ts, Calendar timezone) {
        this.setTimestamp(p, ts, timezone, false);
    }

    public void setTimestamp(int p, Timestamp ts, boolean mapNull) {
        this.setTimestamp(p, ts, null, mapNull);
    }

    public void setTimestamp(int p, Timestamp ts) {
        this.setTimestamp(p, ts, null, false);
    }

    public void setTime(int p, Time t, Calendar timezone) {
        try {
            int ep = this.effectivePosition(p);
            if (t == null) {
                this.getStatement().setNull(ep, 92);
            } else if (timezone == null) {
                this.getStatement().setTime(ep, t);
            } else {
                this.getStatement().setTime(ep, t, timezone);
            }
            this.rememberParameter(ep, t);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }

    public void setTime(int p, Time t) {
        this.setTime(p, t, null);
    }

    public void setBinary(int p, Binary<?> b) {
        try {
            int ep = this.effectivePosition(p);
            if (b == null || b.getLength() == 0) {
                b = null;
                this.getStatement().setNull(ep, -4);
            } else {
                this.getStatement().setBinaryStream(ep, b.getInputStream(), b.getLength());
            }
            this.rememberParameter(ep, b);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.getSession(), this.toString(), (Throwable)e);
        }
    }
}

