/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.util.HashMap;
import java.util.Map;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.AbstractIdSource;
import org.tentackle.persist.Db;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementId;
import org.tentackle.persist.StatementKey;

public class ObjectSequenceId
extends AbstractIdSource {
    public static final int GLOBAL_MULTIPLIER = 1;
    public static final int SEQUENCE_MULTIPLIER = 100;
    private static final Map<String, ObjectSequenceId> SEQUENCES = new HashMap<String, ObjectSequenceId>();
    private static final StatementId SELECT_ID = new StatementId();
    private final int sequenceMultiplier;
    private final int globalMultiplier;
    private int idCount;
    private long sequenceNo;

    public static synchronized ObjectSequenceId get(String name, int sequenceMultiplier, int globalMultiplier) {
        ObjectSequenceId seq = SEQUENCES.get(name);
        if (seq == null) {
            seq = new ObjectSequenceId(name, sequenceMultiplier, globalMultiplier);
            SEQUENCES.put(name, seq);
        } else if (seq.globalMultiplier != globalMultiplier || seq.sequenceMultiplier != sequenceMultiplier) {
            throw new PersistenceException("attempt to configure id source with different multipliers for '" + name + "', configured: " + seq.sequenceMultiplier + "/" + seq.globalMultiplier + ", attempt: " + sequenceMultiplier + "/" + globalMultiplier);
        }
        return seq;
    }

    public static synchronized ObjectSequenceId get(String name) {
        return ObjectSequenceId.get(name, 100, 1);
    }

    private ObjectSequenceId(String name, int sequenceMultiplier, int globalMultiplier) {
        super(name);
        this.sequenceMultiplier = sequenceMultiplier;
        this.globalMultiplier = globalMultiplier;
        this.idCount = sequenceMultiplier;
    }

    @Override
    public boolean isLockFree() {
        return true;
    }

    @Override
    public synchronized long nextId(Db db) {
        block17: {
            this.assertDbNotRemote(db);
            if (this.idCount >= this.sequenceMultiplier) {
                try {
                    PreparedStatementWrapper selectStatement = db.getPreparedStatement(new StatementKey(SELECT_ID, this.getClass()), false, () -> db.getBackend().sqlNextFromSequene(this.getName()));
                    try (ResultSetWrapper rs = selectStatement.executeQuery();){
                        if (rs.next()) {
                            this.sequenceNo = rs.getLong(1);
                            this.idCount = 0;
                            break block17;
                        }
                        throw new PersistenceException((Session)db, "cannot retrieve ID from sequence");
                    }
                }
                catch (RuntimeException e) {
                    if (e instanceof PersistenceException) {
                        throw e;
                    }
                    throw new PersistenceException((Session)db, (Throwable)e);
                }
            }
        }
        return (this.sequenceNo * (long)this.sequenceMultiplier + (long)this.idCount++) * (long)this.globalMultiplier;
    }
}

