/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.AbstractIdSource;
import org.tentackle.persist.CommitTxRunnable;
import org.tentackle.persist.Db;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementId;
import org.tentackle.persist.StatementKey;

public class ObjectId
extends AbstractIdSource {
    private static final long serialVersionUID = -2463189262257268747L;
    private static final StatementId SELECT_ID = new StatementId();
    private static final StatementId INCREMENT_ID = new StatementId();
    private static final StatementId UPDATE_ID = new StatementId();
    private long lastId;
    private long lastTxCount;
    private boolean registerTxPending;

    public ObjectId(String name) {
        super(name);
    }

    @Override
    public boolean isLockFree() {
        return false;
    }

    @Override
    public synchronized long nextId(Db db) {
        block19: {
            this.assertDbNotRemote(db);
            long txVoucher = db.begin("nextId");
            try {
                if (db.getTxNumber() > this.lastTxCount) {
                    this.lastTxCount = db.getTxNumber();
                    this.registerTxPending = true;
                    PreparedStatementWrapper incrementStatement = db.getPreparedStatement(new StatementKey(INCREMENT_ID, this.getClass()), false, () -> "UPDATE " + this.getName() + " SET " + "id" + "=" + "id" + "+1");
                    PreparedStatementWrapper selectStatement = db.getPreparedStatement(new StatementKey(SELECT_ID, this.getClass()), false, () -> "SELECT id FROM " + this.getName());
                    this.assertOneRowAffected(db, incrementStatement.executeUpdate());
                    try (ResultSetWrapper rs = selectStatement.executeQuery();){
                        if (rs.next()) {
                            this.lastId = rs.getLong(1);
                            db.commit(txVoucher);
                            break block19;
                        }
                        throw new PersistenceException((Session)db, "table " + this.getName() + " is empty");
                    }
                }
                if (txVoucher != 0L) {
                    throw new PersistenceException((Session)db, "transaction counter corrupted");
                }
                ++this.lastId;
                if (this.registerTxPending) {
                    db.registerCommitTxRunnable(new CommitTxRunnable(){
                        private static final long serialVersionUID = 3540652948263201449L;

                        @Override
                        public void commit(Db db) {
                            PreparedStatementWrapper updateStatement = db.getPreparedStatement(new StatementKey(UPDATE_ID, this.getClass()), false, () -> "UPDATE " + ObjectId.this.getName() + " SET " + "id" + "=?");
                            updateStatement.setLong(1, ObjectId.this.lastId);
                            ObjectId.this.assertOneRowAffected(db, updateStatement.executeUpdate());
                        }
                    });
                    this.registerTxPending = false;
                }
                db.commit(txVoucher);
            }
            catch (RuntimeException e) {
                db.rollback(txVoucher);
                if (e instanceof PersistenceException) {
                    throw e;
                }
                throw new PersistenceException((Session)db, (Throwable)e);
            }
        }
        return this.lastId;
    }
}

