/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.sql.SQLException;
import java.util.Date;
import java.util.Random;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.FormatHelper;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.Db;
import org.tentackle.persist.DefaultConnectionManager;
import org.tentackle.persist.ManagedConnection;

public class MpxConnectionManager
extends DefaultConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MpxConnectionManager.class);
    protected final Db serverDb;
    protected final int incSize;
    protected final int minSize;
    protected final int minMinutes;
    protected final int maxMinutes;
    protected int[] unConList;
    protected int unConCount;
    protected Random random;
    protected boolean initialized;
    private boolean shutdownRequested;
    private Thread connectThread;
    private final Object connectGoMutex;
    private final Object connectDoneMutex;
    private volatile int conRequestCount;
    private int warnLogSize;
    private int infoLogSize;

    public MpxConnectionManager(String name, Db serverDb, int maxDb, int idOffset, int iniSize, int incSize, int minSize, int maxSize, int minMinutes, int maxMinutes) {
        super(name, iniSize, maxSize, idOffset);
        if (minSize > maxSize || minMinutes > maxMinutes || incSize < 0 || incSize > maxSize - iniSize || maxDb > 0 && maxDb < iniSize) {
            throw new IllegalArgumentException("illegal or conflicting parameters");
        }
        this.serverDb = serverDb;
        this.maxDbSize = maxDb;
        this.incSize = incSize;
        this.minSize = minSize;
        this.minMinutes = minMinutes;
        this.maxMinutes = maxMinutes;
        this.infoLogSize = this.maxConSize / 4;
        this.warnLogSize = this.maxConSize / 2;
        this.random = new Random();
        this.unConList = new int[iniSize];
        this.connectGoMutex = new Object();
        this.connectDoneMutex = new Object();
        this.connectThread = new ConnectionThread(this.getName() + " Connection Management Thread");
    }

    public MpxConnectionManager(Db serverDb) {
        this("mpx-mgr", serverDb, 1000, serverDb.getSessionId() + 1, 8, 2, 4, 100, 720, 2160);
    }

    @Override
    public synchronized void shutdown() {
        this.shutdownRequested = true;
        this.connectThread.interrupt();
        try {
            this.connectThread.join();
        }
        catch (InterruptedException ex) {
            LOGGER.warning(this + ": stopping the connect thread failed", (Throwable)ex);
        }
        super.shutdown();
        this.unConCount = 0;
    }

    public int getInfoLogSize() {
        return this.infoLogSize;
    }

    public void setInfoLogSize(int infoLogSize) {
        this.infoLogSize = infoLogSize;
    }

    public int getWarnLogSize() {
        return this.warnLogSize;
    }

    public void setWarnLogSize(int warnLogSize) {
        this.warnLogSize = warnLogSize;
    }

    protected void pushUnattached(int index) {
        if (this.unConCount >= this.unConList.length) {
            int[] nUnConList = new int[this.unConList.length << 1];
            System.arraycopy(this.unConList, 0, nUnConList, 0, this.unConList.length);
            for (int j = this.unConList.length; j < nUnConList.length; ++j) {
                nUnConList[j] = -1;
            }
            this.unConList = nUnConList;
        }
        this.unConList[this.unConCount++] = index;
    }

    protected int popUnattached() {
        return this.unConCount > 0 ? this.unConList[--this.unConCount] : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int createConnections(int count) {
        try {
            int conSize;
            MpxConnectionManager mpxConnectionManager = this;
            synchronized (mpxConnectionManager) {
                conSize = this.getConnectionCount();
            }
            if (conSize + count < this.minSize) {
                count = this.minSize - conSize;
            }
            if (this.maxConSize > 0) {
                if (conSize + count > this.maxConSize) {
                    count = this.maxConSize - conSize;
                }
                if (count == 0) {
                    LOGGER.severe(this + ": *** maximum number of connections reached: " + this.maxConSize + " ***", new Object[0]);
                } else if (conSize + count > this.getInfoLogSize()) {
                    String msg = this + ": increasing number of connections by " + count + " to " + (conSize + count) + " of " + this.maxConSize + " (unattached=" + this.unConCount + ")";
                    if (conSize + count > this.getWarnLogSize()) {
                        StringBuilder buf = new StringBuilder(msg).append("\n\n  attached connections:");
                        for (ManagedConnection con : ManagedConnection.getManagedConnections()) {
                            if (con.getManager() != this || !con.isAttached()) continue;
                            buf.append("\n\n  ").append(con.toDiagnosticString());
                        }
                        LOGGER.warning(buf.toString(), new Object[0]);
                    } else {
                        LOGGER.info(msg, new Object[0]);
                    }
                }
            }
            for (int i = 0; i < count; ++i) {
                ManagedConnection con = new ManagedConnection(this, this.serverDb.getBackend(), this.serverDb.connect());
                con.setExpireAt(con.getEstablishedSince() + (long)(this.minMinutes * 60 + this.random.nextInt((this.maxMinutes - this.minMinutes) * 60)) * 1000L);
                LOGGER.info("{0}: open connection {1}, valid until {2}", new Object[]{this, con, FormatHelper.formatTimestamp((Date)new Date(con.getExpireAt()))});
                MpxConnectionManager mpxConnectionManager2 = this;
                synchronized (mpxConnectionManager2) {
                    this.pushUnattached(this.addConnection(con));
                    continue;
                }
            }
            return count;
        }
        catch (SQLException ex) {
            throw new PersistenceException(this + ": creating connection failed", (Throwable)ex);
        }
    }

    @Override
    public synchronized int login(Session session) {
        if (!this.initialized) {
            this.createConnections(this.iniSize);
            this.connectThread.start();
            this.initialized = true;
        }
        int id = this.addDb((Db)session) + this.idOffset;
        LOGGER.fine("{0} logged into {1}, id={2}", new Object[]{session, this, id});
        return id;
    }

    @Override
    public synchronized void logout(Session session) {
        this.assertSessionBelongsToMe(session);
        int index = this.convertConnectionIdToIndex(session.getSessionId());
        this.removeDb(index);
        LOGGER.fine("{0} logged out from {1}, id={2}", new Object[]{session, this, session.getSessionId()});
        ManagedConnection con = ((Db)session).getConnection();
        if (con != null) {
            con.forceDetached();
            if (con.isDead()) {
                this.cleanupDeadConnection(con);
                int[] newUnConList = new int[this.unConList.length];
                int newUnConCount = 0;
                for (int i = 0; i < this.unConCount; ++i) {
                    ManagedConnection c = this.conList[this.unConList[i]];
                    c.verifyConnection();
                    if (c.isDead()) {
                        this.cleanupDeadConnection(c);
                        continue;
                    }
                    newUnConList[newUnConCount++] = c.getIndex();
                }
                this.unConList = newUnConList;
                this.unConCount = newUnConCount;
                this.reopenConnections();
            } else {
                this.pushUnattached(con.getIndex());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(Session session) {
        this.assertSessionBelongsToMe(session);
        ManagedConnection con = ((Db)session).getConnection();
        int loopCount = 0;
        while (con == null) {
            MpxConnectionManager mpxConnectionManager = this;
            synchronized (mpxConnectionManager) {
                int conIndex = this.popUnattached();
                if (conIndex >= 0) {
                    con = this.conList[conIndex];
                    if (con.getIndex() != conIndex) {
                        throw new PersistenceException(session, "connection " + con + " has wrong index " + con.getIndex() + ", expected " + conIndex);
                    }
                    if (System.currentTimeMillis() - con.getDetachedSince() > (long)this.minMinutes * 30000L) {
                        con.verifyConnection();
                    }
                    if (con.isDead()) {
                        this.cleanupDeadConnection(con);
                        con = null;
                        continue;
                    }
                    break;
                }
            }
            boolean request = false;
            boolean runningOutOfConnections = false;
            Object object = this;
            synchronized (object) {
                if (this.conRequestCount == 0) {
                    this.conRequestCount = this.incSize;
                    request = true;
                } else if (this.conRequestCount < 0) {
                    this.conRequestCount = 0;
                    if (++loopCount > 20) {
                        throw new PersistenceException(this + ": max. number of concurrent connections in use: " + this.maxConSize);
                    }
                    runningOutOfConnections = true;
                }
            }
            if (runningOutOfConnections) {
                try {
                    long ms = loopCount > 1 ? (long)(1000 + this.random.nextInt(4000)) : (long)(100 + this.random.nextInt(400));
                    LOGGER.warning(this + ": Running out of connections! Putting " + session + " to sleep for " + ms + " ms, loop " + loopCount, new Object[0]);
                    Thread.sleep(ms);
                }
                catch (InterruptedException ex) {
                    LOGGER.fine("interrupted!", new Object[0]);
                }
            }
            if (request) {
                Object object2 = this.connectGoMutex;
                synchronized (object2) {
                    this.connectGoMutex.notifyAll();
                }
            }
            object = this.connectDoneMutex;
            synchronized (object) {
                try {
                    this.connectDoneMutex.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        con.attachSession((Db)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach(Session session) {
        this.assertSessionBelongsToMe(session);
        ManagedConnection con = ((Db)session).getConnection();
        if (con == null) {
            throw new PersistenceException(this + ": no connection attached to " + session);
        }
        con.detachSession((Db)session);
        if (!con.isAttached()) {
            boolean closeIt = false;
            MpxConnectionManager mpxConnectionManager = this;
            synchronized (mpxConnectionManager) {
                if (!con.getAutoCommit()) {
                    LOGGER.severe("connection " + con + " detached while still in transaction -> marked dead", new Object[0]);
                    con.setDead(true);
                }
                if (con.isDead()) {
                    this.cleanupDeadConnection(con);
                    try {
                        session.close();
                    }
                    catch (RuntimeException rex) {
                        LOGGER.warning("closing Db failed", (Throwable)rex);
                    }
                } else if (con.getExpireAt() > 0L && con.getExpireAt() < con.getDetachedSince()) {
                    this.removeConnection(con.getIndex());
                    closeIt = true;
                } else {
                    this.pushUnattached(con.getIndex());
                }
            }
            if (closeIt) {
                LOGGER.info("{0}: closing connection {1}, open since {2}", new Object[]{this, con, FormatHelper.formatTimestamp((Date)new Date(con.getEstablishedSince()))});
                con.close();
                this.reopenConnections();
            }
        }
    }

    @Override
    public synchronized void forceDetach(Session session) {
        this.assertSessionBelongsToMe(session);
        ManagedConnection con = ((Db)session).getConnection();
        if (con != null) {
            con.forceDetached();
            this.pushUnattached(con.getIndex());
        }
    }

    private void cleanupDeadConnection(ManagedConnection con) {
        this.removeConnection(con.getIndex());
        try {
            LOGGER.warning(this + ": closing **DEAD** connection " + con, new Object[0]);
            con.close();
        }
        catch (PersistenceException ex) {
            LOGGER.warning("closing **DEAD** connection failed -> ignored", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reopenConnections() {
        boolean reopen = false;
        Object object = this;
        synchronized (object) {
            int num;
            if (this.conRequestCount == 0 && (num = this.minSize - this.getConnectionCount()) > 0) {
                reopen = true;
                this.conRequestCount = num;
            }
        }
        if (reopen) {
            object = this.connectGoMutex;
            synchronized (object) {
                this.connectGoMutex.notifyAll();
            }
        }
    }

    private class ConnectionThread
    extends Thread {
        public ConnectionThread(String name) {
            super(name);
            this.setDaemon(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!MpxConnectionManager.this.shutdownRequested) {
                Object object = MpxConnectionManager.this.connectGoMutex;
                synchronized (object) {
                    try {
                        MpxConnectionManager.this.connectGoMutex.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.fine("interrupted!", new Object[0]);
                    }
                    if (!MpxConnectionManager.this.shutdownRequested && MpxConnectionManager.this.conRequestCount > 0) {
                        try {
                            int count = MpxConnectionManager.this.createConnections(MpxConnectionManager.this.conRequestCount);
                            MpxConnectionManager mpxConnectionManager = MpxConnectionManager.this;
                            synchronized (mpxConnectionManager) {
                                MpxConnectionManager.this.conRequestCount = count == 0 ? -1 : 0;
                            }
                        }
                        catch (Exception e) {
                            LOGGER.warning(MpxConnectionManager.this + ": creating connections failed", (Throwable)e);
                        }
                        Object object2 = MpxConnectionManager.this.connectDoneMutex;
                        synchronized (object2) {
                            MpxConnectionManager.this.connectDoneMutex.notifyAll();
                        }
                    }
                }
            }
        }
    }
}

